/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field;

import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibListField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.FieldEndpointTestcases;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.TestHelper;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractFieldEndpointTest
extends AbstractMeshTest
implements FieldEndpointTestcases {
    protected NodeResponse readNode(HibNode node, String ... expandedFieldNames) {
        NodeParametersImpl parameters = new NodeParametersImpl();
        parameters.setLanguages(new String[]{"en"});
        parameters.setExpandedFieldNames(expandedFieldNames);
        return (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.tx(() -> node.getUuid()), new ParameterProvider[]{parameters, new VersioningParametersImpl().draft()}));
    }

    protected void createNodeAndExpectFailure(String fieldKey, Field field, HttpResponseStatus status, String bodyMessageI18nKey, String ... i18nParams) {
        if (field != null) {
            try (Tx tx = this.tx();){
                HibNode node = this.folder("2015");
                this.prepareTypedSchema(node, TestHelper.fieldIntoSchema(field).setName(fieldKey), true);
                tx.success();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNodeUuid(this.folder("2015").getUuid());
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        nodeCreateRequest.setLanguage("en");
        if (fieldKey != null) {
            nodeCreateRequest.getFields().put(fieldKey, field);
        }
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}), (HttpResponseStatus)status, (String)bodyMessageI18nKey, (String[])i18nParams);
    }

    protected NodeResponse updateNode(String fieldKey, Field field) {
        return this.updateNode(fieldKey, field, false);
    }

    protected NodeResponse updateNode(String fieldKey, Field field, boolean expandAll) {
        this.tx(tx -> {
            this.prepareTypedSchema(this.schemaContainer("folder"), Optional.ofNullable(field).stream().map(TestHelper::fieldIntoSchema).map(schema -> schema.setName(fieldKey)).collect(Collectors.toList()), Optional.empty());
            tx.success();
        });
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.getFields().put(fieldKey, field);
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            HibNode node = this.folder("2015");
            nodeUpdateRequest.setVersion(contentDao.getLatestDraftFieldContainer(node, this.english()).getVersion().toString());
            tx2.success();
        }
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", uuid, nodeUpdateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        Assert.assertNotNull((String)"The response could not be found in the result of the future.", (Object)response);
        Assert.assertNotNull((String)"The field was not included in the response.", (Object)response.getFields().hasField(fieldKey));
        return response;
    }

    protected void updateNodeFailure(String fieldKey, Field field, HttpResponseStatus status, String bodyMessageI18nKey, String ... i18nParams) {
        HibNode node = this.folder("2015");
        this.tx(tx -> {
            this.prepareTypedSchema(node, TestHelper.fieldIntoSchema(field).setName(fieldKey), true);
            tx.success();
        });
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.getFields().put(fieldKey, field);
        nodeUpdateRequest.setVersion((String)this.tx(tx -> tx.contentDao().getLatestDraftFieldContainer(node, this.english()).getVersion().toString()));
        ClientHelper.call(() -> this.client().updateNode("dummy", (String)this.tx(() -> node.getUuid()), nodeUpdateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}), (HttpResponseStatus)status, (String)bodyMessageI18nKey, (String[])i18nParams);
    }

    protected <U, T extends HibListField<?, ?, U>> List<U> getListValues(Function<String, T> getter, String fieldKey) {
        HibListField field = (HibListField)getter.apply(fieldKey);
        return field != null ? field.getValues() : null;
    }

    @Override
    @Test
    public void testDeleteField() {
        NodeResponse response = this.createNodeWithField();
        ClientHelper.call(() -> this.client().deleteNode("dummy", response.getUuid(), new ParameterProvider[0]));
    }
}

