/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.branch.HibBranch;
import com.gentics.mesh.core.data.dao.BranchDao;
import com.gentics.mesh.core.data.dao.NodeDao;
import com.gentics.mesh.core.data.dao.PersistingContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.DataProvider;
import com.gentics.mesh.core.field.FieldFetcher;
import com.gentics.mesh.core.field.FieldTestcases;
import com.gentics.mesh.core.rest.common.FieldTypes;
import com.gentics.mesh.core.rest.error.GenericRestException;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.FieldList;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaModel;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaModelImpl;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.test.context.TestHelper;
import com.gentics.mesh.util.Tuple;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.mockito.Mockito;

public abstract class AbstractFieldTest<FS extends FieldSchema>
extends AbstractMeshTest
implements FieldTestcases {
    protected abstract FS createFieldSchema(boolean var1);

    protected PersistingContentDao contentDao() {
        return this.contentDao(Tx.get());
    }

    protected PersistingContentDao contentDao(Tx tx) {
        return ((CommonTx)tx.unwrap()).contentDao();
    }

    protected Tuple<HibNode, HibNodeFieldContainer> createNode(boolean isRequiredField, String segmentField) {
        NodeDao nodeDao = Tx.get().nodeDao();
        BranchDao branchDao = Tx.get().branchDao();
        SchemaModelImpl schema = new SchemaModelImpl();
        schema.setName("dummySchema");
        schema.addField(this.createFieldSchema(isRequiredField));
        if (segmentField != null) {
            schema.setSegmentField(segmentField);
        }
        HibSchema container = CommonTx.get().schemaDao().create((SchemaVersionModel)schema, null, null, false);
        HibSchemaVersion version = (HibSchemaVersion)container.getLatestVersion();
        Tx.get().commit();
        HibNode node = nodeDao.create(this.project(), this.user(), version);
        HibBranch branch = (HibBranch)branchDao.findByUuid((HibCoreElement)this.initialBranch().getProject(), this.initialBranch().getUuid());
        nodeDao.setParentNode(node, branch.getUuid(), nodeDao.findByUuidGlobal(this.project().getBaseNode().getUuid()));
        EventQueueBatch batch = (EventQueueBatch)Mockito.mock(EventQueueBatch.class);
        Tx.get().branchDao().assignSchemaVersion(branch, this.user(), version, batch);
        HibNodeFieldContainer nodeContainer = Tx.get().contentDao().createFieldContainer(node, this.english(), branch, this.user());
        return Tuple.tuple((Object)node, (Object)nodeContainer);
    }

    protected NodeResponse transform(HibNode node) throws Exception {
        String json = this.getJson(node);
        Assert.assertNotNull((Object)json);
        NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
        Assert.assertNotNull((Object)response);
        return response;
    }

    protected SchemaModel prepareNode(HibNode node, String listName, String listType) {
        ListFieldSchemaImpl nodeListFieldSchema = new ListFieldSchemaImpl();
        nodeListFieldSchema.setName(listName);
        nodeListFieldSchema.setListType(listType);
        try {
            this.prepareTypedSchema(node.getSchemaContainer(), List.of(nodeListFieldSchema), Optional.empty());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ((HibSchemaVersion)node.getSchemaContainer().getLatestVersion()).getSchema();
    }

    protected void assertList(int expectedItems, String fieldKey, String listType, NodeResponse response) {
        Field deserializedList = response.getFields().getField(fieldKey, FieldTypes.LIST, listType, false);
        Assert.assertNotNull((Object)deserializedList);
        FieldList listField = (FieldList)deserializedList;
        Assert.assertEquals((String)("The list of type {" + listType + "} did not contain the expected amount of items."), (long)expectedItems, (long)listField.getItems().size());
    }

    protected void invokeRemoveFieldViaNullTestcase(String fieldName, FieldFetcher fetcher, DataProvider dummyFieldCreator, Consumer<HibNodeFieldContainer> updater) {
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(false, null).v2();
        dummyFieldCreator.set((HibFieldContainer)container, fieldName);
        updater.accept(container);
        Assert.assertNull((String)"The field should have been deleted by setting it to null", (Object)fetcher.fetch((HibFieldContainer)container, fieldName));
    }

    protected void invokeUpdateFromRestTestcase(String fieldName, FieldFetcher fetcher, DataProvider createEmpty) {
        InternalActionContext ac = this.mockActionContext();
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(false, null).v2();
        this.updateContainer(ac, container, fieldName, null);
        Assert.assertNull((String)"No field should have been created", (Object)fetcher.fetch((HibFieldContainer)container, fieldName));
    }

    protected void invokeRemoveRequiredFieldViaNullTestcase(String fieldName, FieldFetcher fetcher, DataProvider createDummyData, Consumer<HibNodeFieldContainer> updater) {
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(true, null).v2();
        createDummyData.set((HibFieldContainer)container, fieldName);
        try {
            updater.accept(container);
            Assert.fail((String)"The update should have failed");
        }
        catch (GenericRestException e) {
            Assert.assertEquals((Object)"node_error_required_field_not_deletable", (Object)e.getI18nKey());
            Assertions.assertThat((Object[])e.getI18nParameters()).containsExactly((Object[])new String[]{fieldName, "dummySchema"});
        }
    }

    protected void invokeRemoveSegmentFieldViaNullTestcase(String fieldName, FieldFetcher fetcher, DataProvider createDummyData, Consumer<HibNodeFieldContainer> updater) {
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(false, fieldName).v2();
        createDummyData.set((HibFieldContainer)container, fieldName);
        updater.accept(container);
    }

    protected void invokeUpdateFromRestNullOnCreateRequiredTestcase(String fieldName, FieldFetcher fetcher) {
        this.invokeUpdateFromRestNullOnCreateRequiredTestcase(fieldName, fetcher, true);
    }

    protected void invokeUpdateFromRestNullOnCreateRequiredTestcase(String fieldName, FieldFetcher fetcher, boolean expectError) {
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(true, null).v2();
        try {
            InternalActionContext ac = this.mockActionContext();
            this.updateContainer(ac, container, fieldName, null);
            if (expectError) {
                Assert.fail((String)"The update should have failed but it did not.");
            }
        }
        catch (GenericRestException e) {
            Assert.assertEquals((Object)"node_error_missing_required_field_value", (Object)e.getI18nKey());
            Assertions.assertThat((Object[])e.getI18nParameters()).containsExactly((Object[])new String[]{fieldName, "dummySchema"});
            Assert.assertNull((String)"No field should have been created", (Object)fetcher.fetch((HibFieldContainer)container, fieldName));
        }
    }

    protected void invokeUpdateFromRestValidSimpleValueTestcase(String fieldName, DataProvider createDummyData, Consumer<HibNodeFieldContainer> updater, Consumer<HibNodeFieldContainer> asserter) {
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.createNode(false, null).v2();
        createDummyData.set((HibFieldContainer)container, fieldName);
        updater.accept(container);
        asserter.accept(container);
    }

    protected void updateContainer(InternalActionContext ac, HibNodeFieldContainer container, String fieldKey, Field field) {
        FieldMapImpl fieldMap = new FieldMapImpl();
        fieldMap.put(fieldKey, field);
        if (field != null) {
            try (Tx tx = this.tx();){
                this.prepareTypedSchema(container.getNode(), TestHelper.fieldIntoSchema(field).setName(fieldKey), true);
                tx.commit();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        container.updateFieldsFromRest(ac, (FieldMap)fieldMap);
    }
}

