/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;

@FunctionalInterface
public interface FieldSchemaCreator {
    public static final FieldSchemaCreator CREATEBINARY = name -> FieldUtil.createBinaryFieldSchema((String)name);
    public static final FieldSchemaCreator CREATEBINARY_WITH_CHECK_URL = name -> FieldUtil.createBinaryFieldSchema((String)name, (String)"http://localhost/check");
    public static final FieldSchemaCreator CREATEBOOLEAN = name -> FieldUtil.createBooleanFieldSchema((String)name);
    public static final FieldSchemaCreator CREATEBOOLEANLIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"boolean");
    public static final FieldSchemaCreator CREATEDATE = name -> FieldUtil.createDateFieldSchema((String)name);
    public static final FieldSchemaCreator CREATEDATELIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"date");
    public static final FieldSchemaCreator CREATEHTML = name -> FieldUtil.createHtmlFieldSchema((String)name);
    public static final FieldSchemaCreator CREATEHTMLLIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"html");
    public static final FieldSchemaCreator CREATEMICRONODE = name -> {
        MicronodeFieldSchema schema = FieldUtil.createMicronodeFieldSchema((String)name);
        schema.setAllowedMicroSchemas(new String[]{"vcard"});
        return schema;
    };
    public static final FieldSchemaCreator CREATEMICRONODELIST = name -> {
        ListFieldSchema schema = FieldUtil.createListFieldSchema((String)name, (String)"micronode");
        schema.setAllowedSchemas(new String[]{"vcard"});
        return schema;
    };
    public static final FieldSchemaCreator CREATENODE = name -> FieldUtil.createNodeFieldSchema((String)name);
    public static final FieldSchemaCreator CREATENODELIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"node");
    public static final FieldSchemaCreator CREATENUMBER = name -> FieldUtil.createNumberFieldSchema((String)name);
    public static final FieldSchemaCreator CREATENUMBERLIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"number");
    public static final FieldSchemaCreator CREATESTRING = name -> FieldUtil.createStringFieldSchema((String)name);
    public static final FieldSchemaCreator CREATESTRINGLIST = name -> FieldUtil.createListFieldSchema((String)name, (String)"string");

    public FieldSchema create(String var1);
}

