/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.reactivex.Observable;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractBinaryFieldUploadEndpointParameterizedTest
extends AbstractMeshTest {
    @Parameterized.Parameter
    public int numUploads;
    public static Optional<Boolean> initialSyncWrites = Optional.empty();

    @Parameterized.Parameters
    public static Collection<Object> paramData() {
        return IntStream.of(1, 2, 5, 10, 25, 50, 100).boxed().collect(Collectors.toList());
    }

    public abstract boolean isSyncWrites();

    @Test
    public void testParallelDupUpload() throws IOException {
        this.testParallelUpload(true);
    }

    @Test
    public void testParallelDiffUpload() throws IOException {
        this.testParallelUpload(false);
    }

    protected void testParallelUpload(boolean useSameName) throws IOException {
        String folderUuid = (String)this.tx(() -> this.folder("news").getUuid());
        try (Tx tx = this.tx();){
            this.prepareTypedSchema(this.folder("news"), (FieldSchema)FieldUtil.createBinaryFieldSchema((String)"image"), false);
            tx.success();
        }
        Buffer buffer = this.getBuffer("/pictures/blume.jpg");
        initialSyncWrites = initialSyncWrites.or(() -> Optional.of(this.mesh().globalLock().isSyncWrites()));
        this.getTestContext().getInstanceProvider().setSyncWrites(this.isSyncWrites());
        Observable.range((int)0, (int)this.numUploads).flatMapSingle(number -> {
            NodeCreateRequest request = new NodeCreateRequest();
            request.setLanguage("en");
            request.setParentNodeUuid(folderUuid);
            request.setSchemaName("folder");
            request.getFields().put("slug", (Field)FieldUtil.createStringField((String)("folder" + number)));
            return this.client().createNode("dummy", request, new ParameterProvider[0]).toSingle().flatMap(node -> {
                byte[] data = buffer.getBytes();
                int size = data.length;
                ByteArrayInputStream ins = new ByteArrayInputStream(data);
                return this.client().updateNodeBinaryField(this.projectName(), node.getUuid(), "en", node.getVersion(), "image", (InputStream)ins, (long)size, (String)(useSameName ? "blume.jpg" : number + "blume.jpg"), "image/jpeg", new ParameterProvider[0]).toSingle();
            });
        }).lastOrError().ignoreElement().blockingAwait();
        this.getTestContext().getInstanceProvider().setSyncWrites(initialSyncWrites.get().booleanValue());
    }
}

