/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BinaryFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaListResponse;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.image.CropMode;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class BinaryFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "binaryField";

    @Before
    public void updateSchema() throws IOException {
        this.setSchema(false);
    }

    private void setSchema(boolean isRequired) throws IOException {
        try (Tx tx = this.tx();){
            BinaryFieldSchemaImpl binaryFieldSchema = new BinaryFieldSchemaImpl();
            binaryFieldSchema.setName(FIELD_NAME);
            binaryFieldSchema.setLabel("Some label");
            binaryFieldSchema.setRequired(isRequired);
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(binaryFieldSchema), Optional.empty());
            this.prepareTypedSchema(this.folder("2015"), (FieldSchema)binaryFieldSchema, true);
            tx.success();
        }
    }

    @Override
    public void testReadNodeWithExistingField() throws IOException {
    }

    @Override
    public void testUpdateNodeFieldWithField() {
    }

    @Test
    public void testVersionConflictUpload() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        NodeResponse responseA = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        MeshAssertions.assertThat((String)responseA.getVersion()).doesNotMatch((CharSequence)version.toString());
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_error_conflict_detected", (String[])new String[0]);
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", responseA.getVersion(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        try (Tx tx = this.tx();){
            String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
            Buffer buffer = TestUtils.randomBuffer((int)1000);
            VersionNumber version = (VersionNumber)this.tx(() -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
            ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        }
        NodeResponse firstResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        Assert.assertEquals((Object)"filename.txt", (Object)firstResponse.getFields().getBinaryField(FIELD_NAME).getFileName());
        String oldVersion = firstResponse.getVersion();
        BinaryField binaryField = firstResponse.getFields().getBinaryField(FIELD_NAME);
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)binaryField);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getBinaryField(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number should not be generated.", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        String filename = "filename.txt";
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), filename, "application/binary", new ParameterProvider[0]));
        NodeResponse firstResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getBinaryField(FIELD_NAME)).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx2 = this.tx();){
            ContentDao contentDao = tx2.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            MeshAssertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            MeshAssertions.assertThat((Object)latest.getBinary(FIELD_NAME)).isNull();
            MeshAssertions.assertThat((Object)latest.getPreviousVersion().getBinary(FIELD_NAME)).isNotNull();
            String oldFilename = latest.getPreviousVersion().getBinary(FIELD_NAME).getFileName();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)oldFilename).as("Old version filename should match the intitial version filename", new Object[0])).isEqualTo((Object)filename);
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Test
    public void testUpdateDelete() throws IOException {
        NodeResponse response = this.createNodeWithField();
        FileUtils.deleteDirectory((File)new File(this.options().getUploadOptions().getDirectory()));
        ClientHelper.call(() -> this.client().deleteNode("dummy", response.getUuid(), new ParameterProvider[0]));
    }

    @Test
    public void testDownloadBogusNames() {
        List<String> names = Arrays.asList("file", "file.", ".", "jpeg", "jpg", "JPG", "file.JPG", "file.PDF");
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        for (String name : names) {
            ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", "draft", FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), name, "application/pdf2", new ParameterProvider[0]));
            MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", FIELD_NAME, new ParameterProvider[0]));
            Assert.assertEquals((Object)"application/pdf2", (Object)response.getContentType());
            Assert.assertEquals((Object)name, (Object)response.getFilename());
        }
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        try (Tx tx = this.tx();){
            String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
            Buffer buffer = TestUtils.randomBuffer((int)1000);
            VersionNumber version = (VersionNumber)this.tx(() -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
            ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        }
        NodeResponse firstResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        Assert.assertEquals((Object)"filename.txt", (Object)firstResponse.getFields().getBinaryField(FIELD_NAME).getFileName());
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new BinaryFieldImpl());
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getBinaryField(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Test
    public void testUpdateSetEmptyFilename() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        NodeResponse firstResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().setVersion("draft")}));
        Assert.assertEquals((Object)"filename.txt", (Object)firstResponse.getFields().getBinaryField(FIELD_NAME).getFileName());
        this.updateNodeFailure(FIELD_NAME, (Field)new BinaryFieldImpl().setFileName(""), HttpResponseStatus.BAD_REQUEST, "field_binary_error_emptyfilename", FIELD_NAME);
        this.updateNodeFailure(FIELD_NAME, (Field)new BinaryFieldImpl().setMimeType(""), HttpResponseStatus.BAD_REQUEST, "field_binary_error_emptymimetype", FIELD_NAME);
    }

    @Test
    public void testBinaryDisplayField() throws Exception {
        String fileName = "blume.jpg";
        byte[] bytes = this.getBinary("/pictures/blume.jpg");
        NodeResponse nodeResponse1 = this.createBinaryNode();
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", nodeResponse1.getUuid(), "en", nodeResponse1.getVersion(), "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, fileName, "application/binary", new ParameterProvider[0]));
        SchemaResponse binarySchema = ((SchemaListResponse)ClientHelper.call(() -> this.client().findSchemas("dummy", new ParameterProvider[0]))).getData().stream().filter(s -> s.getName().equals("binary_content")).findFirst().get();
        SchemaUpdateRequest schemaUpdateRequest = (SchemaUpdateRequest)JsonUtil.readValue((String)binarySchema.toJson(), SchemaUpdateRequest.class);
        schemaUpdateRequest.setDisplayField("binary");
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().updateSchema(binarySchema.getUuid(), schemaUpdateRequest, new ParameterProvider[0])), JobStatus.COMPLETED, 1);
        NodeResponse nodeResponse3 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeResponse1.getUuid(), new ParameterProvider[0]));
        Assert.assertEquals((Object)nodeResponse3.getDisplayName(), (Object)fileName);
        String query = "query($uuid: String){node(uuid: $uuid){ displayName }}";
        JsonObject variables = new JsonObject().put("uuid", (Object)nodeResponse1.getUuid());
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", new GraphQLRequest().setQuery(query).setVariables(variables), new ParameterProvider[0]));
        Assert.assertEquals((Object)response.getData().getJsonObject("node").getString("displayName"), (Object)fileName);
    }

    @Test
    public void testSvgTransformation() throws Exception {
        String fileName = "laptop-2.svg";
        byte[] inputBytes = this.getBinary("/pictures/laptop-2.svg");
        NodeResponse nodeResponse1 = this.createBinaryNode();
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", nodeResponse1.getUuid(), "en", nodeResponse1.getVersion(), "binary", (InputStream)new ByteArrayInputStream(inputBytes), (long)inputBytes.length, fileName, "image/svg", new ParameterProvider[0]));
        MeshBinaryResponse download = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", nodeResponse1.getUuid(), "en", "binary", new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100))}));
        byte[] downloadBytes = IOUtils.toByteArray((InputStream)download.getStream());
        download.close();
        MeshAssertions.assertThat((byte[])downloadBytes).containsExactly(inputBytes);
    }

    @Test
    public void testSimilarManipulationParameters() throws IOException {
        String fileName = "blume.jpg";
        byte[] bytes = this.getBinary("/pictures/blume.jpg");
        NodeResponse nodeResponse = this.createBinaryNode();
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", nodeResponse.getUuid(), "en", nodeResponse.getVersion(), "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, fileName, "image/jpg", new ParameterProvider[0]));
        String hash = this.hashBinary((MeshRequest<MeshBinaryResponse>)this.client().downloadBinaryField("dummy", nodeResponse.getUuid(), "en", "binary", new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(300)).setHeight(Integer.valueOf(400)).setFocalPoint(0.46f, 0.35f).setCropMode(CropMode.FOCALPOINT).setFocalPointZoom(Float.valueOf(2.0f))}));
        String hash2 = this.hashBinary((MeshRequest<MeshBinaryResponse>)this.client().downloadBinaryField("dummy", nodeResponse.getUuid(), "en", "binary", new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(300)).setHeight(Integer.valueOf(400)).setFocalPoint(0.46f, 0.35f).setCropMode(CropMode.FOCALPOINT)}));
        Assert.assertNotEquals((String)"Downloaded binary must be different", (Object)hash, (Object)hash2);
    }

    private String hashBinary(MeshRequest<MeshBinaryResponse> downloadBinaryField) throws IOException {
        return DigestUtils.md5Hex((InputStream)((MeshBinaryResponse)downloadBinaryField.blockingGet()).getStream());
    }

    private NodeResponse createBinaryNode() {
        String parentUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        this.grantAdmin();
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en").setParentNodeUuid(parentUuid).setSchemaName("binary_content");
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]));
    }

    private byte[] getBinary(String name) throws IOException {
        InputStream ins = this.getClass().getResourceAsStream(name);
        return IOUtils.toByteArray((InputStream)ins);
    }

    @Override
    public void testCreateNodeWithField() {
    }

    @Override
    public void testCreateNodeWithNoField() {
    }

    @Override
    public NodeResponse createNodeWithField() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        return (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
    }

    @Test
    public void downloadDeletedBinary() throws IOException {
        String fileName = "blume.jpg";
        byte[] bytes = this.getBinary("/pictures/blume.jpg");
        NodeResponse createResponse = this.createBinaryNode();
        NodeResponse updatedResponse = (NodeResponse)this.client().updateNodeBinaryField("dummy", createResponse.getUuid(), "en", createResponse.getVersion(), "binary", (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, fileName, "image/jpg", new ParameterProvider[0]).blockingGet();
        FileUtils.deleteDirectory((File)new File(this.options().getUploadOptions().getDirectory()));
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", updatedResponse.getUuid(), updatedResponse.getLanguage(), "binary", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_binary_data_not_found", (String[])new String[0]);
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", updatedResponse.getUuid(), updatedResponse.getLanguage(), "binary", new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(200))}), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_binary_data_not_found", (String[])new String[0]);
        ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", updatedResponse.getUuid(), updatedResponse.getLanguage(), updatedResponse.getVersion(), "binary", new ImageManipulationParametersImpl().setWidth(Integer.valueOf(250))), (HttpResponseStatus)HttpResponseStatus.NOT_FOUND, (String)"node_error_binary_data_not_found", (String[])new String[0]);
    }

    @Test
    public void testUploadEmptyFile() {
        NodeResponse binaryNode = this.createBinaryNode();
        InputStream emptyStream = new InputStream(){

            @Override
            public int read() throws IOException {
                return -1;
            }
        };
        try {
            this.client().updateNodeBinaryField("dummy", binaryNode.getUuid(), binaryNode.getLanguage(), binaryNode.getVersion(), "binary", emptyStream, 0L, "emptyFile", "application/binary", new ParameterProvider[0]).blockingAwait();
            Assert.fail((String)"Empty file upload should not pass");
        }
        catch (Exception e) {
            Assert.assertTrue((e.getMessage().indexOf("Error:400 in POST") > -1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUploadAndDoNotPublish() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        NodeResponse updated = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("1.1").hasLanguageVariant("en", true);
    }

    @Test
    public void testUploadAndPublish() {
        String uuid = (String)this.tx(() -> this.folder("2015").getUuid());
        Buffer buffer = TestUtils.randomBuffer((int)1000);
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
        NodeResponse updated = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), FIELD_NAME, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "filename.txt", "application/binary", true, new ParameterProvider[0]));
        MeshAssertions.assertThat((NodeResponse)updated).hasVersion("2.0").hasLanguageVariant("en", true);
    }
}

