/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.binary.BinaryMetadata;
import com.gentics.mesh.core.rest.schema.BinaryExtractOptions;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.schema.impl.SchemaUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.junit.After;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, elasticsearch=ElasticsearchTestMode.TRACKING)
public class BinaryFieldExtractOptionTest
extends AbstractMeshTest {
    private NodeResponse nodeResponse;
    private BinaryField binaryField;
    private BinaryMetadata metadata;
    private JsonObject document;
    private String plainText;

    private void setUp(BinaryExtractOptions extract) throws Exception {
        this.setUp(extract, null);
    }

    private void setUp(BinaryExtractOptions extract, Set<String> whitelist) throws Exception {
        if (extract != null) {
            SchemaResponse oldSchema = this.getSchemaByName("binary_content");
            SchemaUpdateRequest binarySchema = oldSchema.toUpdateRequest();
            ((BinaryFieldSchemaImpl)binarySchema.getField("binary", BinaryFieldSchemaImpl.class)).setBinaryExtractOptions(extract);
            this.updateAndMigrateSchema(oldSchema, binarySchema);
        }
        if (whitelist != null) {
            this.mesh().options().getUploadOptions().setMetadataWhitelist(whitelist);
        }
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        Buffer buffer = this.getBuffer("/testfiles/test.docx");
        NodeResponse node = this.createBinaryNode(parentNodeUuid);
        this.nodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", new ParameterProvider[0]));
        this.binaryField = this.nodeResponse.getFields().getBinaryField("binary");
        this.waitForSearchIdleEvent();
        this.metadata = this.binaryField.getMetadata();
        this.plainText = this.binaryField.getPlainText();
        this.document = this.trackingSearchProvider().getLatestStoreEvent(this.nodeResponse.getUuid());
    }

    @After
    public void tearDown() throws Exception {
        this.mesh().options().getUploadOptions().setMetadataWhitelist(null);
    }

    @Test
    public void testDefault() throws Exception {
        this.setUp(null);
        MeshAssertions.assertThat((String)this.metadata.get("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((Map)this.metadata.getMap()).hasSize(49);
        MeshAssertions.assertThat((String)this.plainText).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata").getString("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file").getString("content")).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
    }

    @Test
    public void testNone() throws Exception {
        this.setUp(new BinaryExtractOptions().setMetadata(false).setContent(false));
        MeshAssertions.assertThat((BinaryMetadata)this.metadata).isEmpty();
        MeshAssertions.assertThat((String)this.plainText).isNull();
        MeshAssertions.assertThat((JsonObject)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata")).isNull();
        MeshAssertions.assertThat((JsonObject)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file")).isNull();
    }

    @Test
    public void testMetadata() throws Exception {
        this.setUp(new BinaryExtractOptions().setMetadata(true).setContent(false));
        MeshAssertions.assertThat((String)this.metadata.get("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((Map)this.metadata.getMap()).hasSize(49);
        MeshAssertions.assertThat((String)this.plainText).isNull();
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata").getString("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((JsonObject)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file")).isNull();
    }

    @Test
    public void testContent() throws Exception {
        this.setUp(new BinaryExtractOptions().setMetadata(false).setContent(true));
        MeshAssertions.assertThat((BinaryMetadata)this.metadata).isEmpty();
        MeshAssertions.assertThat((String)this.plainText).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
        MeshAssertions.assertThat((JsonObject)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata")).isNull();
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file").getString("content")).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
    }

    @Test
    public void testBoth() throws Exception {
        this.setUp(new BinaryExtractOptions().setMetadata(true).setContent(true));
        MeshAssertions.assertThat((String)this.metadata.get("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((Map)this.metadata.getMap()).hasSize(49);
        MeshAssertions.assertThat((String)this.plainText).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata").getString("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file").getString("content")).isEqualTo((Object)"Das ist ein Word Dokument f\u00fcr den Johannes");
    }

    @Test
    public void testWhitelist() throws Exception {
        this.setUp(new BinaryExtractOptions().setMetadata(true).setContent(false), Set.of("subject"));
        MeshAssertions.assertThat((String)this.metadata.get("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((String)this.plainText).isNull();
        MeshAssertions.assertThat((Object)this.metadata.getLocation()).isNull();
        MeshAssertions.assertThat((Map)this.metadata.getMap()).hasSize(1);
        MeshAssertions.assertThat((String)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("metadata").getString("subject")).isEqualTo((Object)"TestSubject");
        MeshAssertions.assertThat((JsonObject)this.document.getJsonObject("fields").getJsonObject("binary").getJsonObject("file")).isNull();
    }
}

