/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BinaryFieldFileHandleLeakTest
extends AbstractMeshTest {
    @Test
    public void testFileHandleLeakOnDownload() throws Exception {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            this.uploadImage(node, "en", fieldName, fileName, contentType);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertClosedFileHandleDifference(10, () -> {
            for (int i = 0; i < 100; ++i) {
                this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[0]).toSingle().blockingGet();
            }
        });
    }

    @Test
    public void testFileHandleLeakOnTransformation() throws Exception {
        NodeResponse initialResponse;
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            this.uploadImage(node, "en", fieldName, fileName, contentType);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        try (Tx tx = this.tx();){
            initialResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
            tx.success();
        }
        this.assertClosedFileHandleDifference(10, () -> {
            AtomicReference<NodeResponse> atomicResponse = new AtomicReference<NodeResponse>(initialResponse);
            NodeResponse response = atomicResponse.get();
            for (int i = 0; i < 100; ++i) {
                this.client().transformNodeBinaryField("dummy", response.getUuid(), response.getLanguage(), response.getVersion(), fieldName, new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100 + i))).toSingle().blockingGet();
            }
        });
    }

    @Test
    public void testFileHandleLeakOnImageManipulationNoCache() throws Exception {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            this.uploadImage(node, "en", fieldName, fileName, contentType);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertClosedFileHandleDifference(5, () -> {
            for (int i = 0; i < 10; ++i) {
                this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100 + i))}).toSingle().blockingGet();
            }
        });
    }

    @Test
    public void testFileHandleLeakOnImageManipulationCached() throws Exception {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            this.uploadImage(node, "en", fieldName, fileName, contentType);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertClosedFileHandleDifference(5, () -> {
            for (int i = 0; i < 10; ++i) {
                this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100))}).toSingle().blockingGet();
            }
        });
    }

    @Test
    public void testResizeBrokenImage() throws Exception {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            this.upload(node, Buffer.buffer((String)"broken"), "en", fieldName, fileName, contentType);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        this.assertClosedFileHandleDifference(5, () -> {
            for (int i = 0; i < 40; ++i) {
                ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100))}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"image_error_reading_failed", (String[])new String[0]);
            }
        });
    }

    @Test
    public void testFileHandleLeakOnUpload() throws Exception {
        NodeResponse initialResponse;
        String contentType = "text/plain";
        String fieldName = "image";
        String fileName = "somefile.txt";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        try (Tx tx = this.tx();){
            initialResponse = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
            tx.success();
        }
        this.assertClosedFileHandleDifference(10, () -> {
            AtomicReference<NodeResponse> atomicResponse = new AtomicReference<NodeResponse>(initialResponse);
            for (int i = 0; i < 100; ++i) {
                Buffer buffer = Buffer.buffer((String)("Testbuffer" + i));
                NodeResponse response = atomicResponse.get();
                atomicResponse.set((NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", response.getUuid(), response.getLanguage(), response.getVersion(), fieldName, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileName, contentType, new ParameterProvider[0])));
            }
        });
    }
}

