/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.endpoint.node.TransformationResult;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.binary.BinaryFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BinaryFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.FileUtils;
import com.gentics.mesh.util.UUIDUtil;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.core.buffer.Buffer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class BinaryFieldTest
extends AbstractFieldTest<BinaryFieldSchema> {
    private static final String BINARY_FIELD = "binaryField";
    private static final Base64.Decoder BASE64 = Base64.getDecoder();

    @Override
    protected BinaryFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(BINARY_FIELD, isRequired);
    }

    protected BinaryFieldSchema createFieldSchema(String key, boolean isRequired) {
        BinaryFieldSchemaImpl binaryFieldSchema = new BinaryFieldSchemaImpl();
        binaryFieldSchema.setName(key);
        binaryFieldSchema.setAllowedMimeTypes(new String[]{"image/jpg", "text/plain"});
        binaryFieldSchema.setRequired(isRequired);
        return binaryFieldSchema;
    }

    @Test
    public void testBinaryFieldBase64() {
        try (Tx tx = this.tx();){
            String input = "";
            while (input.length() < 32768) {
                input = input.concat("Hallo");
            }
            HibBinary binary = (HibBinary)tx.binaries().create("hashsum", 1L).runInExistingTx(tx);
            this.mesh().binaryStorage().store(Flowable.just((Object)Buffer.buffer((String)input)), binary.getUuid()).blockingAwait();
            String base64 = tx.binaryDao().getBase64ContentSync(binary);
            Assert.assertEquals((Object)input.toString(), (Object)new String(BASE64.decode(base64)));
        }
    }

    @Test
    public void testBinaryFieldBase641Char() {
        try (Tx tx = this.tx();){
            String input = " ";
            HibBinary binary = (HibBinary)tx.binaries().create("hashsum", 1L).runInExistingTx(tx);
            this.mesh().binaryStorage().store(Flowable.just((Object)Buffer.buffer((String)input)), binary.getUuid()).blockingAwait();
            String base64 = tx.binaryDao().getBase64ContentSync(binary);
            Assert.assertEquals((Object)input.toString(), (Object)new String(BASE64.decode(base64)));
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        String hash = "6a793cf1c7f6ef022ba9fff65ed43ddac9fb9c2131ffc4eaa3f49212244c0d4191ae5877b03bd50fd137bd9e5a16799da4a1f2846f0b26e3d956c4d8423004cc";
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            this.prepareTypedSchema(node, (FieldSchema)this.createFieldSchema(true), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibBinary binary = (HibBinary)tx.binaries().create(hash, 10L).runInExistingTx(tx);
            HibBinaryField field = container.createBinary(BINARY_FIELD, binary);
            field.setMimeType("image/jpg");
            binary.setImageHeight(Integer.valueOf(200));
            binary.setImageWidth(Integer.valueOf(300));
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            BinaryField deserializedNodeField = response.getFields().getBinaryField(BINARY_FIELD);
            Assert.assertNotNull((Object)deserializedNodeField);
            Assert.assertEquals((Object)hash, (Object)deserializedNodeField.getSha512sum());
            Assert.assertEquals((long)200L, (long)deserializedNodeField.getHeight().intValue());
            Assert.assertEquals((long)300L, (long)deserializedNodeField.getWidth().intValue());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBinary binary = (HibBinary)tx.binaries().create("6a793cf1c7f6ef022ba9fff65ed43ddac9fb9c2131ffc4eaa3f49212244c0d4191ae5877b03bd50fd137bd9e5a16799da4a1f2846f0b26e3d956c4d8423004cc", 0L).runInExistingTx(tx);
            HibBinaryField field = container.createBinary(BINARY_FIELD, binary);
            field.getBinary().setSize(220L);
            Assert.assertNotNull((Object)field);
            Assert.assertEquals((Object)BINARY_FIELD, (Object)field.getFieldKey());
            field.setFileName("blume.jpg");
            field.setMimeType("image/jpg");
            field.setImageDominantColor("#22A7F0");
            field.getBinary().setImageHeight(Integer.valueOf(133));
            field.getBinary().setImageWidth(Integer.valueOf(7));
            HibBinaryField loadedField = container.getBinary(BINARY_FIELD);
            HibBinary loadedBinary = loadedField.getBinary();
            Assert.assertNotNull((String)"The previously created field could not be found.", (Object)loadedField);
            Assert.assertEquals((long)220L, (long)loadedBinary.getSize());
            Assert.assertEquals((Object)"blume.jpg", (Object)loadedField.getFileName());
            Assert.assertEquals((Object)"image/jpg", (Object)loadedField.getMimeType());
            Assert.assertEquals((Object)"#22A7F0", (Object)loadedField.getImageDominantColor());
            Assert.assertEquals((long)133L, (long)loadedField.getBinary().getImageHeight().intValue());
            Assert.assertEquals((long)7L, (long)loadedField.getBinary().getImageWidth().intValue());
            Assert.assertEquals((Object)"6a793cf1c7f6ef022ba9fff65ed43ddac9fb9c2131ffc4eaa3f49212244c0d4191ae5877b03bd50fd137bd9e5a16799da4a1f2846f0b26e3d956c4d8423004cc", (Object)loadedBinary.getSHA512Sum());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBinary binary = (HibBinary)tx.binaries().create("6a793cf1c7f6ef022ba9fff65ed43ddac9fb9c2131ffc4eaa3f49212244c0d4191ae5877b03bd50fd137bd9e5a16799da4a1f2846f0b26e3d956c4d8423004cc", 0L).runInExistingTx(tx);
            HibBinaryField field = container.createBinary(BINARY_FIELD, binary);
            field.getBinary().setSize(220L);
            Assert.assertNotNull((Object)field);
            Assert.assertEquals((Object)BINARY_FIELD, (Object)field.getFieldKey());
            field.setFileName("blume.jpg");
            field.setMimeType("image/jpg");
            field.setImageDominantColor("#22A7F0");
            field.getBinary().setImageHeight(Integer.valueOf(133));
            field.getBinary().setImageWidth(Integer.valueOf(7));
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            field.cloneTo((HibFieldContainer)otherContainer);
            HibBinaryField clonedField = otherContainer.getBinary(BINARY_FIELD);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)clonedField).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)field, new String[]{"outV", "id", "uuid", "element", "contentUuid", "dbUuid", "value", "parentContainer"});
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)clonedField.getBinary()).as("referenced binary of cloned field", new Object[0])).isNotNull()).isEqualToComparingFieldByField((Object)field.getBinary());
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibBinary binary = (HibBinary)tx.binaries().create(UUIDUtil.randomUUID(), 1L).runInExistingTx(tx);
            HibBinaryField fieldA = container.createBinary("fieldA", binary);
            HibBinaryField fieldB = container.createBinary("fieldB", binary);
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.setFileName("someText");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.setFileName("someText");
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBinary binary = (HibBinary)tx.binaries().create(UUIDUtil.randomUUID(), 0L).runInExistingTx(tx);
            HibBinaryField fieldA = container.createBinary(BINARY_FIELD, binary);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBinary binary = (HibBinary)tx.binaries().create("hashsum", 1L).runInExistingTx(tx);
            HibBinaryField fieldA = container.createBinary(BINARY_FIELD, binary);
            Assert.assertTrue((String)"The field should be equal to the html rest field since both fields have no value.", (boolean)fieldA.equals(new BinaryFieldImpl()));
            fieldA.setFileName("someText");
            Assert.assertFalse((String)"The field should not be equal to a string rest field. Even if it has the same value", (boolean)fieldA.equals(new StringFieldImpl().setString("someText")));
            Assert.assertFalse((String)"The field should not be equal to the rest field since the rest field has a different value.", (boolean)fieldA.equals(new BinaryFieldImpl().setFileName("blub")));
            Assert.assertTrue((String)"The binary field filename value should be equal to a rest field with the same value", (boolean)fieldA.equals(new BinaryFieldImpl().setFileName("someText")));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(BINARY_FIELD, BinaryFieldTestHelper.FETCH, BinaryFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(BINARY_FIELD, BinaryFieldTestHelper.FETCH, false);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(BINARY_FIELD, BinaryFieldTestHelper.FETCH, BinaryFieldTestHelper.FILL_BASIC, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, BINARY_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(BINARY_FIELD, BinaryFieldTestHelper.FETCH, BinaryFieldTestHelper.FILL_BASIC, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, BINARY_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(BINARY_FIELD, BinaryFieldTestHelper.FILL_BASIC, container -> {
                BinaryFieldImpl field = new BinaryFieldImpl();
                field.setFileName("someFile.txt");
                this.updateContainer(ac, (HibNodeFieldContainer)container, BINARY_FIELD, (Field)field);
            }, container -> {
                HibBinaryField field = container.getBinary(BINARY_FIELD);
                Assert.assertNotNull((String)"The graph field {binaryField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The html of the field was not updated.", (Object)"someFile.txt", (Object)field.getFileName());
            });
        }
    }

    @Test
    public void testMultiStreamHandling() throws IOException {
        InputStream ins = this.getClass().getResourceAsStream("/pictures/blume.jpg");
        byte[] bytes = IOUtils.toByteArray((InputStream)ins);
        Flowable obs = Flowable.just((Object)Buffer.buffer((byte[])bytes)).publish().autoConnect(2);
        File file = new File("target", "file" + System.currentTimeMillis());
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.write((byte[])bytes, (OutputStream)fos);
            fos.flush();
        }
        Single info = this.mesh().imageManipulator().readImageInfo(file.getAbsolutePath());
        Single hash = FileUtils.hash((Flowable)obs);
        Single store = this.mesh().binaryStorage().store(obs, "bogus").toSingleDefault((Object)"null");
        TransformationResult result = (TransformationResult)Single.zip((SingleSource)hash, (SingleSource)info, (SingleSource)store, (hashV, infoV, storeV) -> new TransformationResult(hashV, 0L, infoV, "blume.jpg")).blockingGet();
        Assert.assertNotNull((Object)result.getHash());
        Assert.assertEquals((long)1376L, (long)result.getImageInfo().getHeight().intValue());
        Assert.assertEquals((long)1160L, (long)result.getImageInfo().getWidth().intValue());
    }
}

