/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.data.storage.BinaryStorage;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.DataProvider;
import com.gentics.mesh.core.field.FieldFetcher;
import com.gentics.mesh.util.FileUtils;
import com.gentics.mesh.util.UUIDUtil;
import io.reactivex.Flowable;
import io.vertx.core.buffer.Buffer;

public interface BinaryFieldTestHelper {
    public static final String FILECONTENTS = "This is the file contents";
    public static final String FILENAME = "test.txt";
    public static final String MIMETYPE = "text/plain";
    public static final FieldFetcher FETCH = (container, name) -> container.getBinary(name);
    public static final DataProvider CREATE_EMPTY = (container, name) -> {};
    public static final DataProvider FILL_BASIC = (container, name) -> {
        Buffer buffer = Buffer.buffer((String)FILECONTENTS);
        String sha512Sum = (String)FileUtils.hash((Buffer)buffer).blockingGet();
        HibBinary binary = (HibBinary)Tx.get().binaries().create(sha512Sum, Long.valueOf(buffer.length()).longValue()).runInExistingTx(Tx.get());
        String tmpId = UUIDUtil.randomUUID();
        BinaryStorage storage = CommonTx.get().data().mesh().binaryStorage();
        storage.storeInTemp(Flowable.just((Object)buffer), tmpId).blockingAwait();
        storage.moveInPlace(binary.getUuid(), tmpId).blockingAwait();
        HibBinaryField field = container.createBinary(name, binary);
        field.setFileName(FILENAME);
        field.setMimeType(MIMETYPE);
    };
}

