/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBinaryField;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.BinaryCheckStatus;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.binary.BinaryMetadata;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.DeleteParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.rest.client.MeshRestClientMessageException;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.assertj.MeshCoreAssertion;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Observable;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.test.core.TestUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mockserver.client.MockServerClient;
import org.mockserver.junit.MockServerRule;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.verify.VerificationTimes;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.SHORT_BINARY_CHECK_INTERVAL)
public class BinaryFieldUploadEndpointTest
extends AbstractMeshTest {
    @Rule
    public final MockServerRule mockServer = new MockServerRule((Object)this);
    private MockServerClient mockServerClient;

    @Test
    public void testUploadWithNoPerm() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            this.prepareSchema(node, "", "binary");
            roleDao.revokePermissions(this.role(), (HibBaseElement)node, new InternalPermission[]{InternalPermission.UPDATE_PERM});
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.FORBIDDEN, (String)"error_missing_perm", (String[])new String[]{uuid, InternalPermission.UPDATE_PERM.getRestPerm().getName()});
    }

    @Test
    @Ignore(value="mimetype whitelist is not yet implemented")
    public void testUploadWithInvalidMimetype() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 10000;
        String fileName = "somefile.dat";
        String whitelistRegex = "image/.*";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, whitelistRegex, "binary");
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_invalid_mimetype", (String[])new String[]{contentType, whitelistRegex});
    }

    @Test
    public void testUploadBogusName() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 10000;
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, "somefile.DAT"));
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, "application/pdf", "somefile.PDF"));
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, "application/pdf", "somefile."));
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, "application/pdf", "somefile"));
    }

    @Test
    public void testUploadMultipleToBinaryNode() throws IOException {
        this.disableAutoPurge();
        String contentType = "application/octet-stream";
        int binaryLen = 10000;
        HibNode node = this.folder("news");
        try (Tx tx2 = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx2.success();
        }
        for (int i = 0; i < 20; ++i) {
            String newFileName = "somefile" + i + ".dat";
            String oldFilename = null;
            HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
            try (Tx tx3 = this.tx();){
                HibBinaryField oldValue = container.getBinary("binary");
                if (oldValue != null) {
                    oldFilename = oldValue.getFileName();
                }
            }
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, newFileName));
            tx3 = this.tx();
            try {
                ContentDao contentDao = tx3.contentDao();
                HibNodeFieldContainer newContainer = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                Assert.assertNotNull((String)"No new version was created.", (Object)newContainer);
                Assert.assertEquals((Object)newContainer.getUuid(), (Object)contentDao.getLatestDraftFieldContainer(node, this.english()).getUuid());
            }
            finally {
                if (tx3 != null) {
                    tx3.close();
                }
            }
            NodeResponse response = this.readNode("dummy", node.getUuid());
            try (Tx tx4 = this.tx();){
                ContentDao contentDao = tx4.contentDao();
                HibNodeFieldContainer newContainer = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                Assert.assertEquals((String)"Check version number", (Object)newContainer.getVersion().toString(), (Object)response.getVersion());
                String value = container.getBinary("binary") == null ? null : container.getBinary("binary").getFileName();
                Assert.assertEquals((String)("Version {" + container.getVersion() + "} did not contain the old value"), (Object)oldFilename, (Object)value);
                Assert.assertNotNull((String)("Version {" + newContainer.getVersion() + "} did not contain the updated field."), (Object)newContainer.getBinary("binary"));
                Assert.assertEquals((String)("Version {" + newContainer.getVersion() + "} did not contain the updated value."), (Object)newFileName, (Object)newContainer.getBinary("binary").getFileName());
                container = newContainer;
                continue;
            }
        }
    }

    @Test
    public void testUploadToNonBinaryField() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 10000;
        String fileName = "somefile.dat";
        try (Tx tx = this.tx();){
            HibNode node = this.folder("news");
            this.prepareTypedSchema(node.getSchemaContainer(), List.of(new StringFieldSchemaImpl().setName("nonBinary").setLabel("No Binary content")), Optional.empty());
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(this.folder("news"), "en", "nonBinary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_found_field_is_not_binary", (String[])new String[]{"nonBinary"});
    }

    @Test
    public void testParallelImageUpload() throws IOException {
        String fileName = "blume.jpg";
        String contentType = "image/jpeg";
        List<String> fields = Arrays.asList("blume", "blume2", "dreamtime");
        try (Tx tx2 = this.tx();){
            this.prepareTypedSchema(this.folder("news"), fields.stream().map(FieldUtil::createBinaryFieldSchema).collect(Collectors.toList()), Optional.empty());
            tx2.success();
        }
        String uuid = (String)this.tx(() -> this.folder("news").getUuid());
        VersionNumber version = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("news"), "en").getVersion());
        HashMap<String, Buffer> data = new HashMap<String, Buffer>();
        for (String field : fields) {
            Buffer buffer = this.getBuffer("/pictures/" + field + ".jpg");
            data.put(field, buffer);
        }
        Observable.fromIterable(fields).flatMapSingle(fieldName -> {
            Buffer buffer = (Buffer)data.get(fieldName);
            return this.client().updateNodeBinaryField("dummy", uuid, "en", version.toString(), fieldName, (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileName, contentType, new ParameterProvider[0]).toSingle();
        }).lastOrError().ignoreElement().blockingAwait();
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        for (String field : fields) {
            BinaryField binaryField = response.getFields().getBinaryField(field);
            Assert.assertNotNull((Object)binaryField.getDominantColor());
            Assert.assertNotNull((Object)binaryField.getWidth());
            Assert.assertNotNull((Object)binaryField.getHeight());
            Assert.assertEquals((Object)"image/jpeg", (Object)binaryField.getMimeType());
        }
    }

    @Test
    public void testUploadBrokenImage() throws IOException {
        String contentType = "image/jpeg";
        int binaryLen = 10000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareTypedSchema(node, (FieldSchema)FieldUtil.createBinaryFieldSchema((String)"image"), false);
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "image", binaryLen, contentType, fileName));
        String uuid = (String)this.tx(() -> this.folder("news").getUuid());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[0]));
        BinaryField binaryField = response.getFields().getBinaryField("image");
        Assert.assertNull((Object)binaryField.getDominantColor());
        Assert.assertNull((Object)binaryField.getWidth());
        Assert.assertNull((Object)binaryField.getHeight());
        Assert.assertEquals((Object)"image/jpeg", (Object)binaryField.getMimeType());
    }

    @Test
    public void testUploadMultipleBrokenImages() throws IOException {
        String contentType = "image/jpeg";
        int binaryLen = 10000;
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareTypedSchema(node, (FieldSchema)FieldUtil.createBinaryFieldSchema((String)"image"), false);
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        for (int i = 0; i < 100; ++i) {
            String fileName = "somefile" + i + ".dat";
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "image", binaryLen, contentType, fileName));
        }
        MeshCoreAssertion.assertThat(testContext).hasUploadFiles(100L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testUploadExif() throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        Buffer buffer = this.getBuffer("/pictures/android-gps.jpg");
        NodeResponse node = this.createBinaryNode(parentNodeUuid);
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
        NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
        System.out.println(node2.toJson());
        BinaryField binaryField = node2.getFields().getBinaryField("binary");
        BinaryMetadata metadata2 = binaryField.getMetadata();
        Assert.assertEquals((double)13.920556, (double)metadata2.getLocation().getLon(), (double)0.01);
        Assert.assertEquals((double)47.6725, (double)metadata2.getLocation().getLat(), (double)0.01);
        Assert.assertEquals((long)1727L, (long)metadata2.getLocation().getAlt().intValue());
        Assert.assertEquals((Object)"4.2", (Object)metadata2.get("exif_FocalLength"));
        Assert.assertNull((String)"The jpeg should not have any extracted content.", (Object)binaryField.getPlainText());
        NodeUpdateRequest nodeUpdateRequest = node2.toRequest();
        BinaryField field = nodeUpdateRequest.getFields().getBinaryField("binary");
        field.getMetadata().clear();
        field.getMetadata().add("dummy", "value");
        nodeUpdateRequest.getFields().put("binary", (Field)field);
        NodeResponse node3 = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), nodeUpdateRequest, new ParameterProvider[0]));
        BinaryMetadata metadata3 = node3.getFields().getBinaryField("binary").getMetadata();
        Assert.assertEquals((Object)"value", (Object)metadata3.get("dummy"));
        NodeResponse node4 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", node3.getVersion(), "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
        BinaryMetadata metadata4 = node4.getFields().getBinaryField("binary").getMetadata();
        Assert.assertEquals((double)13.920556, (double)metadata4.getLocation().getLon(), (double)0.01);
    }

    @Test
    public void testUploadFilesForTika() throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        List<String> files = Arrays.asList("small.mp4", "small.ogv", "test.pdf", "test.docx");
        for (String file : files) {
            Buffer buffer = this.getBuffer("/testfiles/" + file);
            NodeResponse node = this.createBinaryNode(parentNodeUuid);
            NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), file, "application/pdf", new ParameterProvider[0]));
            Assert.assertFalse((String)("Metadata could not be found for file {" + file + "}"), (boolean)node2.getFields().getBinaryField("binary").getMetadata().getMap().isEmpty());
        }
    }

    @Test
    public void testPlainTextExtractionForDocuments() throws IOException {
        this.expectPlainText("test.pdf", "application/pdf", "Enemenemu");
        this.expectPlainText("test.docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "Das ist ein Word Dokument f\u00fcr den Johannes");
        this.expectPlainText("small.mp4", "application/pdf", "HandBrake 0.9.4 2009112300");
    }

    private void expectPlainText(String fileName, String mimeType, String plainText) throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        Buffer buffer = this.getBuffer("/testfiles/" + fileName);
        NodeResponse node = this.createBinaryNode(parentNodeUuid);
        NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileName, mimeType, new ParameterProvider[0]));
        BinaryField binaryField = node2.getFields().getBinaryField("binary");
        Assert.assertEquals((String)("The plain text of file {" + fileName + "} did not match"), (Object)plainText, (Object)binaryField.getPlainText());
    }

    @Test
    public void testUploadToNodeWithoutBinaryField() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 10000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.uploadRandomData(node, "en", "nonBinary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"error_schema_definition_not_found", (String[])new String[]{"nonBinary"});
        }
    }

    @Test
    public void testUpdateBinaryToImageAndNonImage() throws IOException {
        String mimeType = "image/png";
        String fieldKey = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldKey);
            tx.success();
        }
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        String originalVersion = response.getVersion();
        int size = this.uploadImage(node, "en", fieldKey, fileName, mimeType);
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotEquals((Object)originalVersion, (Object)response.getVersion());
        originalVersion = response.getVersion();
        fileName = "somefile.dat";
        mimeType = "application/octet-stream";
        response = (NodeResponse)ClientHelper.call(() -> this.uploadRandomData(node, "en", fieldKey, size, "application/octet-stream", "somefile.dat"));
        Assert.assertNotNull((Object)response);
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        Assert.assertNotEquals((Object)originalVersion, (Object)response.getVersion());
        BinaryField binaryField = response.getFields().getBinaryField(fieldKey);
        Assert.assertEquals((String)"The filename should be set in the response.", (Object)fileName, (Object)binaryField.getFileName());
        Assert.assertEquals((String)"The contentType was correctly set in the response.", (Object)mimeType, (Object)binaryField.getMimeType());
        Assert.assertEquals((String)"The binary length was not correctly set in the response.", (long)size, (long)binaryField.getFileSize());
        Assert.assertNotNull((String)"The hashsum was not found in the response.", (Object)binaryField.getSha512sum());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getWidth());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getHeight());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getDominantColor());
    }

    @Test
    public void testFileUploadLimit() throws IOException {
        int binaryLen = 10000;
        this.options().getUploadOptions().setByteLimit((long)(binaryLen - 1));
        String contentType = "application/octet-stream";
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"node_error_uploadlimit_reached", (String[])new String[]{"9 KB", "9 KB"});
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testSingleUpload() throws IOException {
        int binaryLen = 10000;
        String contentType = "application/octet-stream";
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testUploadWithoutCheck() throws Exception {
        this.doTestUpload(false);
    }

    @Test
    public void testUploadWithCheck() throws Exception {
        this.doTestUpload(true);
    }

    private void doTestUpload(boolean useBinaryCheck) throws Exception {
        String contentType = "application/blub";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary", useBinaryCheck ? "http://fake.check/url" : null);
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", uuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        BinaryField binaryField = response.getFields().getBinaryField("binary");
        Assert.assertEquals((String)"The filename should be set in the response.", (Object)fileName, (Object)binaryField.getFileName());
        Assert.assertEquals((String)"The contentType was correctly set in the response.", (Object)contentType, (Object)binaryField.getMimeType());
        Assert.assertEquals((String)"The binary length was not correctly set in the response.", (long)binaryLen, (long)binaryField.getFileSize());
        Assert.assertNotNull((String)"The hashsum was not found in the response.", (Object)binaryField.getSha512sum());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getDominantColor());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getWidth());
        Assert.assertNull((String)"The data did contain image information.", (Object)binaryField.getHeight());
        if (useBinaryCheck) {
            Assert.assertEquals((String)"The binary must be postponed initially", (Object)BinaryCheckStatus.POSTPONED, (Object)binaryField.getCheckStatus());
        } else {
            Assert.assertEquals((String)"The binary must be accepted immediately", (Object)BinaryCheckStatus.ACCEPTED, (Object)binaryField.getCheckStatus());
            MeshBinaryResponse downloadResponse = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "binary", new ParameterProvider[0]));
            Assert.assertNotNull((Object)downloadResponse);
            byte[] bytes = IOUtils.toByteArray((InputStream)downloadResponse.getStream());
            downloadResponse.close();
            Assert.assertNotNull((Object)bytes[0]);
            Assert.assertNotNull((Object)bytes[binaryLen - 1]);
            Assert.assertEquals((long)binaryLen, (long)bytes.length);
            Assert.assertEquals((Object)contentType, (Object)downloadResponse.getContentType());
            Assert.assertEquals((Object)fileName, (Object)downloadResponse.getFilename());
        }
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibBinaryField binaryGraphField = contentDao.getLatestDraftFieldContainer(node, this.english()).getBinary("binary");
            String binaryUuid = binaryGraphField.getBinary().getUuid();
            String path = this.localBinaryStorage().getFilePath(binaryUuid);
            File binaryFile = new File(path);
            Assert.assertTrue((String)"The binary file could not be found.", (boolean)binaryFile.exists());
            Assert.assertEquals((String)"The expected length of the file did not match.", (long)binaryLen, (long)binaryFile.length());
        }
    }

    @Test
    public void testRepairUpload() throws Exception {
        String contentType = "application/blub";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        Buffer data = TestUtils.randomBuffer((int)binaryLen);
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.uploadData(data, node, "en", "binary", contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        MeshBinaryResponse downloadResponse = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "binary", new ParameterProvider[0]));
        Assert.assertNotNull((Object)downloadResponse);
        byte[] bytes = IOUtils.toByteArray((InputStream)downloadResponse.getStream());
        downloadResponse.close();
        Assert.assertNotNull((Object)bytes[0]);
        Assert.assertNotNull((Object)bytes[binaryLen - 1]);
        Assert.assertEquals((long)binaryLen, (long)bytes.length);
        Assert.assertEquals((Object)contentType, (Object)downloadResponse.getContentType());
        Assert.assertEquals((Object)fileName, (Object)downloadResponse.getFilename());
        String dir = this.options().getUploadOptions().getDirectory();
        Files.walk(Paths.get(dir, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).findFirst().ifPresent(p -> {
            try {
                Files.delete(p);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "binary", new ParameterProvider[0]), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
        ClientHelper.call(() -> this.uploadData(data, node, "en", "binary", contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.client().downloadBinaryField("dummy", uuid, "en", "binary", new ParameterProvider[0]));
    }

    @Test
    public void testDeleteBinaryNode() throws IOException {
        String hash;
        File binaryFile;
        String contentType = "application/blub";
        int binaryLen = 8000;
        String fileName = "somefile.dat";
        HibNode node = this.folder("news");
        String uuid = (String)this.tx(() -> node.getUuid());
        try (Tx tx2 = this.tx();){
            this.prepareSchema(node, "", "binary");
            tx2.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.uploadRandomData(node, "en", "binary", binaryLen, contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        try (Tx tx3 = this.tx();){
            ContentDao contentDao = tx3.contentDao();
            HibBinaryField binaryGraphField = contentDao.getLatestDraftFieldContainer(node, this.english()).getBinary("binary");
            String binaryUuid = binaryGraphField.getBinary().getUuid();
            binaryFile = new File(this.localBinaryStorage().getFilePath(binaryUuid));
            Assert.assertTrue((String)"The binary file could not be found.", (boolean)binaryFile.exists());
            hash = binaryGraphField.getBinary().getSHA512Sum();
        }
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuid, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        HibBinary binary = (HibBinary)this.tx(tx -> (HibBinary)tx.binaries().findByHash(hash).runInExistingTx(tx));
        Assert.assertNull((String)"The binary for the hash should have also been removed since only one node used the binary.", (Object)binary);
        Assert.assertFalse((String)"The binary file should have been removed.", (boolean)binaryFile.exists());
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 1L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testUploadBinaryWithEmptyProperties() throws IOException {
        String binaryFieldName = "binary";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", binaryFieldName);
            tx.success();
        }
        ClientHelper.call(() -> this.uploadRandomData(node, "en", binaryFieldName, 8000, "application/octet-stream", ""), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"field_binary_error_emptyfilename", (String[])new String[]{binaryFieldName});
        try {
            this.uploadRandomData(node, "en", binaryFieldName, 8000, "", "filename.dat").blockingAwait();
            Assert.fail((String)"Uploading data without contentype should cause an exception");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void testDeleteBinaryNodeDeduplication() throws IOException, InterruptedException {
        String hashB;
        File binaryFileB;
        String hashA;
        File binaryFileA;
        String contentType = "application/blub";
        int binaryLen = 8000;
        Buffer buffer = TestUtils.randomBuffer((int)binaryLen);
        String fileNameA = "somefile-a.dat";
        String fileNameB = "somefile-b.dat";
        HibNode nodeA = this.folder("news");
        String uuidA = (String)this.tx(() -> nodeA.getUuid());
        String versionA = ((VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(nodeA, "en").getVersion())).toString();
        HibNode nodeB = this.folder("products");
        String uuidB = (String)this.tx(() -> nodeB.getUuid());
        String versionB = ((VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(nodeA, "en").getVersion())).toString();
        try (Tx tx2 = this.tx();){
            this.prepareSchema(nodeA, "", "binary");
            this.prepareSchema(nodeB, "", "binary");
            tx2.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuidA, "en", versionA, "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileNameA, contentType, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", uuidB, "en", versionB, "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), fileNameB, contentType, new ParameterProvider[0]));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        try (Tx tx3 = this.tx();){
            ContentDao contentDao = tx3.contentDao();
            HibBinaryField binaryGraphField = contentDao.getLatestDraftFieldContainer(nodeA, this.english()).getBinary("binary");
            String binaryUuid = binaryGraphField.getBinary().getUuid();
            binaryFileA = new File(this.localBinaryStorage().getFilePath(binaryUuid));
            Assert.assertTrue((String)"The binary file could not be found.", (boolean)binaryFileA.exists());
            hashA = binaryGraphField.getBinary().getSHA512Sum();
        }
        try (Tx tx4 = this.tx();){
            ContentDao contentDao = tx4.contentDao();
            HibBinaryField binaryGraphField = contentDao.getLatestDraftFieldContainer(nodeB, this.english()).getBinary("binary");
            String binaryUuid = binaryGraphField.getBinary().getUuid();
            binaryFileB = new File(this.localBinaryStorage().getFilePath(binaryUuid));
            Assert.assertTrue((String)"The binary file could not be found.", (boolean)binaryFileB.exists());
            hashB = binaryGraphField.getBinary().getSHA512Sum();
        }
        Assert.assertEquals((Object)hashA, (Object)hashB);
        Assert.assertEquals((Object)binaryFileA.getAbsolutePath(), (Object)binaryFileB.getAbsolutePath());
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuidA, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        HibBinary binaryA = (HibBinary)this.tx(tx -> (HibBinary)tx.binaries().findByHash(hashA).runInExistingTx(tx));
        Assert.assertNotNull((String)"The binary for the hash should not have been removed since it is still in use.", (Object)binaryA);
        Assert.assertTrue((String)"The binary file should not have been deleted since there is still one node which uses it.", (boolean)binaryFileA.exists());
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.client().deleteNode("dummy", uuidB, new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        binaryA = (HibBinary)this.tx(tx -> (HibBinary)tx.binaries().findByHash(hashA).runInExistingTx(tx));
        Assert.assertNull((String)"The binary for the hash should have also been removed since only one node used the binary.", (Object)binaryA);
        long start = System.currentTimeMillis();
        while (binaryFileA.exists() && System.currentTimeMillis() - start < 5000L) {
            Thread.sleep(200L);
        }
        Assert.assertFalse((String)"The binary file should have been removed.", (boolean)binaryFileA.exists());
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 1L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testUploadWithSegmentfieldConflict() throws IOException {
        String contentType = "application/octet-stream";
        int binaryLen = 10;
        String fileName = "somefile.dat";
        try (Tx tx = this.tx();){
            HibNode folder2014 = this.folder("2014");
            this.prepareSchema(folder2014, "", "binary");
            SchemaVersionModel schema = ((HibSchemaVersion)folder2014.getSchemaContainer().getLatestVersion()).getSchema();
            schema.setSegmentField("binary");
            ((HibSchemaVersion)folder2014.getSchemaContainer().getLatestVersion()).setSchema(schema);
            tx.success();
        }
        MeshCoreAssertion.assertThat(testContext).hasUploads(0L, 0L).hasTempFiles(0L).hasTempUploads(0L);
        HibNode folder2014 = this.folder("2014");
        ClientHelper.call(() -> this.uploadRandomData(folder2014, "en", "binary", binaryLen, contentType, fileName));
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", (String)this.db().tx(() -> this.folder("2014").getUuid()), new ParameterProvider[]{new NodeParametersImpl().setResolveLinks(LinkType.FULL)}));
        HibNode folder2015 = this.folder("2015");
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
        ClientHelper.call(() -> this.uploadRandomData(folder2015, "en", "binary", binaryLen, contentType, fileName), (HttpResponseStatus)HttpResponseStatus.CONFLICT, (String)"node_conflicting_segmentfield_upload", (String[])new String[]{"binary", fileName});
        MeshCoreAssertion.assertThat(testContext).hasUploads(1L, 1L).hasTempFiles(0L).hasTempUploads(0L);
    }

    @Test
    public void testUploadImage() throws IOException {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName);
            tx.success();
        }
        tx = this.tx();
        try {
            int size = this.uploadImage(node, "en", fieldName, fileName, contentType);
            NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new VersioningParametersImpl().draft()}));
            BinaryField binaryField = response.getFields().getBinaryField(fieldName);
            Assert.assertEquals((String)"The filename should be set in the response.", (Object)fileName, (Object)binaryField.getFileName());
            Assert.assertEquals((String)"The contentType was correctly set in the response.", (Object)contentType, (Object)binaryField.getMimeType());
            Assert.assertEquals((String)"The binary length was not correctly set in the response.", (long)size, (long)binaryField.getFileSize());
            Assert.assertNotNull((String)"The hashsum was not found in the response.", (Object)binaryField.getSha512sum());
            Assert.assertEquals((String)"The data did not contain correct image color information.", (Object)"#737042", (Object)binaryField.getDominantColor());
            Assert.assertEquals((String)"The data did not contain correct image width information.", (long)1160L, (long)binaryField.getWidth().intValue());
            Assert.assertEquals((String)"The data did not contain correct image height information.", (long)1376L, (long)binaryField.getHeight().intValue());
            MeshBinaryResponse downloadResponse = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[0]));
            Assert.assertNotNull((Object)downloadResponse);
            byte[] bytes = IOUtils.toByteArray((InputStream)downloadResponse.getStream());
            downloadResponse.close();
            Assert.assertEquals((long)size, (long)bytes.length);
            Assert.assertNotNull((String)"The first byte of the response could not be loaded.", (Object)bytes[0]);
            Assert.assertNotNull((String)"The last byte of the response could not be loaded.", (Object)bytes[size - 1]);
            Assert.assertEquals((Object)contentType, (Object)downloadResponse.getContentType());
            Assert.assertEquals((Object)fileName, (Object)downloadResponse.getFilename());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testFlowableDownloadWithoutCheckService() throws IOException {
        this.doTestFlowableDownload(false);
    }

    @Test
    public void testFlowableDownloadWithCheckServiceAccepted() throws IOException, InterruptedException {
        CountDownLatch checkRequestLatch = new CountDownLatch(1);
        AtomicBoolean success = this.prepareCheckServiceMock(true, checkRequestLatch);
        BinaryDownloadInfo downloadInfo = this.doTestFlowableDownload(true);
        checkRequestLatch.await(10L, TimeUnit.SECONDS);
        this.mockServerClient.verify(HttpRequest.request((String)"/check"), VerificationTimes.atLeast((int)1));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)success.get()).as("Check service success", new Object[0])).isTrue();
        MeshBinaryResponse downloadResponse = (MeshBinaryResponse)this.client().downloadBinaryField("dummy", downloadInfo.nodeUuid, "en", "image", new ParameterProvider[0]).blockingGet();
        Assert.assertNotNull((Object)downloadResponse);
        byte[] bytes = (byte[])downloadResponse.getFlowable().reduce(ArrayUtils::addAll).blockingGet();
        Assert.assertEquals((long)downloadInfo.size, (long)bytes.length);
        Assert.assertNotNull((String)"The first byte of the response could not be loaded.", (Object)bytes[0]);
        Assert.assertNotNull((String)"The last byte of the response could not be loaded.", (Object)bytes[downloadInfo.size - 1]);
        Assert.assertEquals((Object)downloadInfo.contentType, (Object)downloadResponse.getContentType());
        Assert.assertEquals((Object)downloadInfo.filename, (Object)downloadResponse.getFilename());
    }

    @Test(expected=RuntimeException.class)
    public void testFlowableDownloadWithCheckServiceDenied() throws IOException, InterruptedException {
        CountDownLatch checkRequestLatch = new CountDownLatch(1);
        AtomicBoolean success = this.prepareCheckServiceMock(false, checkRequestLatch);
        BinaryDownloadInfo downloadInfo = this.doTestFlowableDownload(true);
        checkRequestLatch.await(10L, TimeUnit.MINUTES);
        this.mockServerClient.verify(HttpRequest.request((String)"/check"), VerificationTimes.atLeast((int)1));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)success.get()).as("Check service success", new Object[0])).isTrue();
        this.client().downloadBinaryField("dummy", downloadInfo.nodeUuid, "en", "image", new ParameterProvider[0]).blockingGet();
        Assert.fail((String)"Download of denied binary must not succeed");
    }

    private AtomicBoolean prepareCheckServiceMock(boolean shouldSucceed, CountDownLatch checkRequestLatch) {
        AtomicBoolean result = new AtomicBoolean(false);
        String authHeader = String.format("Bearer %s", this.client().getAPIKey());
        this.mockServerClient.when(HttpRequest.request((String)"/check").withMethod("POST")).respond(rq -> {
            JsonObject body = new JsonObject(rq.getBodyAsString());
            OkHttpClient client = new OkHttpClient.Builder().build();
            String downloadUrl = body.getString("downloadUrl");
            Request request = new Request.Builder().url(downloadUrl).header("Authorization", authHeader).get().build();
            Response response = client.newCall(request).execute();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)response.isSuccessful()).as("Check service file download successful", new Object[0])).isTrue();
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)response.header("Content-Type", "")).as("Check service file download content type", new Object[0])).isEqualTo((Object)"image/png");
            ((AbstractIntegerAssert)Assertions.assertThat((int)Integer.parseInt(response.header("Content-Length", "0"))).as("Check service file download size", new Object[0])).isGreaterThan(0);
            JsonObject checkResult = new JsonObject().put("status", (Object)(shouldSucceed ? "ACCEPTED" : "DENIED"));
            request = new Request.Builder().url(body.getString("callbackUrl")).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)checkResult.encode())).header("Authorization", authHeader).build();
            response = client.newCall(request).execute();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)response.isSuccessful()).as("Check callback request is successful", new Object[0])).isTrue();
            result.set(true);
            checkRequestLatch.countDown();
            return HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code()));
        });
        return result;
    }

    public BinaryDownloadInfo doTestFlowableDownload(boolean useCheckService) throws IOException {
        String contentType = "image/png";
        String fieldName = "image";
        String fileName = "somefile.png";
        HibNode node = this.folder("news");
        try (Tx tx = this.tx();){
            this.prepareSchema(node, "", fieldName, useCheckService ? "http://localhost:" + this.mockServer.getPort() + "/check" : null);
            tx.success();
        }
        tx = this.tx();
        try {
            int size = this.uploadImage(node, "en", fieldName, fileName, contentType);
            MeshBinaryResponse downloadResponse = null;
            try {
                downloadResponse = (MeshBinaryResponse)this.client().downloadBinaryField("dummy", node.getUuid(), "en", fieldName, new ParameterProvider[0]).blockingGet();
                if (useCheckService) {
                    Assert.fail((String)"Download must not succeed when check service URL is given");
                }
            }
            catch (Exception e) {
                ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e.getCause()).as("Download exception", new Object[0])).matches(cause -> {
                    if (!(cause instanceof MeshRestClientMessageException)) {
                        return false;
                    }
                    MeshRestClientMessageException restClientException = (MeshRestClientMessageException)cause;
                    return restClientException.getStatusCode() == HttpResponseStatus.NOT_FOUND.code() && restClientException.getMessage().contains("was not accepted yet");
                }, "must be 404 because binary was not accepted yet");
            }
            if (useCheckService) {
                BinaryDownloadInfo e = new BinaryDownloadInfo(node.getUuid(), fileName, contentType, size);
                return e;
            }
            Assert.assertNotNull((Object)downloadResponse);
            byte[] bytes = (byte[])downloadResponse.getFlowable().reduce(ArrayUtils::addAll).blockingGet();
            Assert.assertEquals((long)size, (long)bytes.length);
            Assert.assertNotNull((String)"The first byte of the response could not be loaded.", (Object)bytes[0]);
            Assert.assertNotNull((String)"The last byte of the response could not be loaded.", (Object)bytes[size - 1]);
            Assert.assertEquals((Object)contentType, (Object)downloadResponse.getContentType());
            Assert.assertEquals((Object)fileName, (Object)downloadResponse.getFilename());
            BinaryDownloadInfo binaryDownloadInfo = new BinaryDownloadInfo(node.getUuid(), fileName, contentType, size);
            return binaryDownloadInfo;
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    private static class BinaryDownloadInfo {
        public final String nodeUuid;
        public final String filename;
        public final String contentType;
        public final int size;

        public BinaryDownloadInfo(String nodeUuid, String filename, String contentType, int size) {
            this.nodeUuid = nodeUuid;
            this.filename = filename;
            this.contentType = contentType;
            this.size = size;
        }
    }
}

