/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.binary;

import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.BinaryField;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.binary.BinaryMetadata;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshCoreOptionChanger;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true, optionChanger=MeshCoreOptionChanger.NO_UPLOAD_PARSER)
public class UploadNoParserTest
extends AbstractMeshTest {
    @Test
    public void testUploadFilesForTika() throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        List<String> files = Arrays.asList("small.mp4", "small.ogv", "test.pdf", "test.docx");
        for (String file : files) {
            Buffer buffer = this.getBuffer("/testfiles/" + file);
            NodeResponse node = this.createBinaryNode(parentNodeUuid);
            NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), file, "application/pdf", new ParameterProvider[0]));
            BinaryField binaryField = node2.getFields().getBinaryField("binary");
            Assert.assertNull((String)"No plain text should have been extracted", (Object)binaryField.getPlainText());
            Assert.assertTrue((String)("No metadata should be extracted {" + file + "}"), (boolean)binaryField.getMetadata().getMap().isEmpty());
        }
    }

    @Test
    @Ignore
    public void testUploadExif() throws IOException {
        String parentNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        Buffer buffer = this.getBuffer("/pictures/android-gps.jpg");
        NodeResponse node = this.createBinaryNode(parentNodeUuid);
        ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", "0.1", "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
        NodeResponse node2 = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
        BinaryField binaryField = node2.getFields().getBinaryField("binary");
        BinaryMetadata metadata2 = binaryField.getMetadata();
        Assert.assertTrue((String)"No metadata should be extracted", (boolean)metadata2.getMap().isEmpty());
        Assert.assertNull((String)"The no content should be extracted.", (Object)binaryField.getPlainText());
        NodeUpdateRequest nodeUpdateRequest = node2.toRequest();
        BinaryField field = nodeUpdateRequest.getFields().getBinaryField("binary");
        field.getMetadata().clear();
        field.getMetadata().add("dummy", "value");
        nodeUpdateRequest.getFields().put("binary", (Field)field);
        NodeResponse node3 = (NodeResponse)ClientHelper.call(() -> this.client().updateNode("dummy", node.getUuid(), nodeUpdateRequest, new ParameterProvider[0]));
        BinaryMetadata metadata3 = node3.getFields().getBinaryField("binary").getMetadata();
        Assert.assertTrue((String)"No metadata should be extracted", (boolean)metadata3.getMap().isEmpty());
        NodeResponse node4 = (NodeResponse)ClientHelper.call(() -> this.client().updateNodeBinaryField("dummy", node.getUuid(), "en", node3.getVersion(), "binary", (InputStream)new ByteArrayInputStream(buffer.getBytes()), (long)buffer.length(), "test.jpg", "image/jpeg", new ParameterProvider[0]));
        BinaryMetadata metadata4 = node4.getFields().getBinaryField("binary").getMetadata();
        Assert.assertTrue((String)"No metadata should be extracted", (boolean)metadata4.getMap().isEmpty());
    }
}

