/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.bool;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBooleanField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BooleanFieldImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.VersionNumber;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class BooleanFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "booleanField";

    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            BooleanFieldSchemaImpl booleanFieldSchema = new BooleanFieldSchemaImpl();
            booleanFieldSchema.setName(FIELD_NAME);
            booleanFieldSchema.setLabel("Some label");
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(booleanFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createBoolean(FIELD_NAME).setBoolean(Boolean.valueOf(true));
            tx.success();
        }
        HibNode node = this.folder("2015");
        NodeResponse response = this.readNode(node, new String[0]);
        BooleanFieldImpl deserializedBooleanField = response.getFields().getBooleanField(FIELD_NAME);
        Assert.assertNotNull((Object)deserializedBooleanField);
        Assert.assertTrue((boolean)deserializedBooleanField.getValue());
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        for (int i = 0; i < 20; ++i) {
            boolean flag = false;
            VersionNumber oldVersion = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getVersion());
            NodeResponse response = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(flag)));
            BooleanFieldImpl field = response.getFields().getBooleanField(FIELD_NAME);
            Assert.assertEquals((Object)flag, (Object)field.getValue());
            Assert.assertEquals((String)"The version within the response should be bumped by one minor version.", (Object)oldVersion.nextDraft().toString(), (Object)response.getVersion());
            response = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(!flag)));
            field = response.getFields().getBooleanField(FIELD_NAME);
            Assert.assertEquals((Object)(!flag ? 1 : 0), (Object)field.getValue());
            Assert.assertEquals((String)"Check version number", (Object)oldVersion.nextDraft().nextDraft().toString(), (Object)response.getVersion());
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(true)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(true)));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(true)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new BooleanFieldImpl());
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getBooleanField(FIELD_NAME)).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getBoolean(FIELD_NAME)).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getBoolean(FIELD_NAME)).isNotNull();
            Boolean oldValue = latest.getPreviousVersion().getBoolean(FIELD_NAME).getBoolean();
            Assertions.assertThat((Boolean)oldValue).isEqualTo(true);
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    @Ignore
    public void testUpdateSetEmpty() {
    }

    protected Boolean getBooleanValue(HibNodeFieldContainer container, String fieldName) {
        HibBooleanField field = container.getBoolean(fieldName);
        return field != null ? field.getBoolean() : null;
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(FIELD_NAME, null);
        BooleanFieldImpl field = response.getFields().getBooleanField(FIELD_NAME);
        Assert.assertNull((Object)field);
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        BooleanFieldImpl field = response.getFields().getBooleanField(FIELD_NAME);
        Assert.assertTrue((boolean)field.getValue());
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode(FIELD_NAME, (Field)new BooleanFieldImpl().setValue(Boolean.valueOf(true)));
    }
}

