/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.bool;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBooleanField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.bool.BooleanFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.BooleanFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.schema.BooleanFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class BooleanFieldTest
extends AbstractFieldTest<BooleanFieldSchema> {
    private static final String BOOLEAN_FIELD = "booleanField";

    @Override
    protected BooleanFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(BOOLEAN_FIELD, isRequired);
    }

    protected BooleanFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        BooleanFieldSchemaImpl schema = new BooleanFieldSchemaImpl();
        schema.setLabel("Some boolean field");
        schema.setRequired(isRequired);
        schema.setName(fieldKey);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            BooleanFieldSchemaImpl booleanFieldSchema = new BooleanFieldSchemaImpl();
            booleanFieldSchema.setName(BOOLEAN_FIELD);
            booleanFieldSchema.setLabel("Some boolean field");
            booleanFieldSchema.setRequired(true);
            this.prepareTypedSchema(node, (FieldSchema)booleanFieldSchema, true);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibBooleanField field = container.createBoolean(BOOLEAN_FIELD);
            field.setBoolean(Boolean.valueOf(true));
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertTrue((String)("The json should contain the boolean field but it did not.{" + json + "}"), (json.indexOf("booleanField\" : true") > 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            BooleanFieldImpl deserializedNodeField = response.getFields().getBooleanField(BOOLEAN_FIELD);
            Assert.assertNotNull((Object)deserializedNodeField);
            Assert.assertEquals((Object)true, (Object)deserializedNodeField.getValue());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("trueBooleanField", false), this.createFieldSchema("falseBooleanField", false)});
            HibBooleanField trueBooleanField = container.createBoolean("trueBooleanField");
            trueBooleanField.setBoolean(Boolean.valueOf(true));
            HibBooleanField falseBooleanField = container.createBoolean("falseBooleanField");
            falseBooleanField.setBoolean(Boolean.valueOf(false));
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("trueBooleanField", false), this.createFieldSchema("falseBooleanField", false)});
            trueBooleanField.cloneTo((HibFieldContainer)otherContainer);
            falseBooleanField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getBoolean("trueBooleanField")).as("cloned true field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)trueBooleanField, new String[]{"parentContainer"});
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getBoolean("falseBooleanField")).as("cloned false field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)falseBooleanField, new String[]{"parentContainer"});
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBooleanField booleanField = container.createBoolean(BOOLEAN_FIELD);
            Assert.assertEquals((Object)BOOLEAN_FIELD, (Object)booleanField.getFieldKey());
            booleanField.setBoolean(Boolean.valueOf(true));
            Assert.assertTrue((String)"The boolean field value was not changed to true", (boolean)booleanField.getBoolean());
            booleanField.setBoolean(Boolean.valueOf(false));
            Assert.assertFalse((String)"The boolean field value was not changed to false", (boolean)booleanField.getBoolean());
            booleanField.setBoolean(null);
            Assert.assertNull((String)"The boolean field value was not set to null.", (Object)booleanField.getBoolean());
            HibBooleanField bogusField2 = container.getBoolean("bogus");
            Assert.assertNull((String)"No field with the name bogus should have been found.", (Object)bogusField2);
            HibBooleanField reloadedBooleanField = container.getBoolean(BOOLEAN_FIELD);
            Assert.assertNull((String)"The boolean field value was set to null and thus the field should have been removed.", (Object)reloadedBooleanField);
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", false), this.createFieldSchema("fieldB", false)});
            HibBooleanField fieldA = container.createBoolean("fieldA");
            HibBooleanField fieldB = container.createBoolean("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.setBoolean(Boolean.valueOf(true));
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.setBoolean(Boolean.valueOf(true));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer();
            HibBooleanField fieldA = container.createBoolean("fieldA");
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true)});
            HibBooleanField fieldA = container.createBoolean("fieldA");
            Assert.assertTrue((String)"The field should be equal to the rest field since both fields have no value.", (boolean)fieldA.equals(new BooleanFieldImpl()));
            fieldA.setBoolean(Boolean.valueOf(true));
            Assert.assertFalse((String)"The field should not be equal to the rest field since the types do not match.", (boolean)fieldA.equals(new HtmlFieldImpl().setHTML("true")));
            Assert.assertFalse((String)"The field should not be equal to the rest field since the rest field has a different value.", (boolean)fieldA.equals(new BooleanFieldImpl().setValue(Boolean.valueOf(false))));
            Assert.assertTrue((String)"The field should be equal to a html rest field with the same value", (boolean)fieldA.equals(new BooleanFieldImpl().setValue(Boolean.valueOf(true))));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(BOOLEAN_FIELD, BooleanFieldTestHelper.FETCH, BooleanFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(BOOLEAN_FIELD, BooleanFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(BOOLEAN_FIELD, BooleanFieldTestHelper.FETCH, BooleanFieldTestHelper.FILLTRUE, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, BOOLEAN_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(BOOLEAN_FIELD, BooleanFieldTestHelper.FETCH, BooleanFieldTestHelper.FILLTRUE, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, BOOLEAN_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(BOOLEAN_FIELD, BooleanFieldTestHelper.FILLTRUE, container -> {
                BooleanFieldImpl field = new BooleanFieldImpl();
                field.setValue(Boolean.valueOf(false));
                this.updateContainer(ac, (HibNodeFieldContainer)container, BOOLEAN_FIELD, (Field)field);
            }, container -> {
                HibBooleanField field = container.getBoolean(BOOLEAN_FIELD);
                Assert.assertNotNull((String)"The graph field {booleanField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The boolean of the field was not updated.", (Object)false, (Object)field.getBoolean());
            });
        }
    }
}

