/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.bool;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.BooleanFieldListImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class BooleanListFieldEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "boolean";
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        BooleanFieldListImpl field = response.getFields().getBooleanFieldList("listField");
        Assertions.assertThat((List)field.getItems()).as("Only valid values (true,false) should be stored", new Object[0]).containsExactly((Object[])new Boolean[]{true, false});
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        BooleanFieldListImpl listField = new BooleanFieldListImpl();
        listField.add((Object)true);
        listField.add((Object)false);
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        BooleanFieldListImpl listField = new BooleanFieldListImpl();
        listField.add((Object)true);
        listField.add((Object)false);
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)response.getFields().getBooleanFieldList("listField")).as("List field in response should be null", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        BooleanFieldListImpl listField = new BooleanFieldListImpl();
        listField.add((Object)true);
        listField.add((Object)false);
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)listField);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        BooleanFieldListImpl listField = new BooleanFieldListImpl();
        listField.add((Object)true);
        listField.add((Object)false);
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        NodeResponse response = this.readNode("dummy", firstResponse.getUuid());
        BooleanFieldListImpl deserializedBooleanField = response.getFields().getBooleanFieldList("listField");
        Assert.assertNotNull((Object)deserializedBooleanField);
        Assertions.assertThat((List)deserializedBooleanField.getItems()).as("Only valid list field values should be listed", new Object[0]).containsExactly((Object[])new Boolean[]{true, false});
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() throws IOException {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        List<List> valueCombinations = Arrays.asList(Arrays.asList(true, false, false), Arrays.asList(false, false, true), Collections.emptyList(), Arrays.asList(true, false), Arrays.asList(false));
        for (int i = 0; i < 20; ++i) {
            List oldValue;
            HibNodeFieldContainer container;
            BooleanFieldListImpl list = new BooleanFieldListImpl();
            try (Tx tx = this.tx();){
                container = tx.contentDao().getFieldContainer(node, "en");
                oldValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getBooleanList(arg_0), "listField");
                List newValue = valueCombinations.get(i % valueCombinations.size());
                for (Boolean value : newValue) {
                    list.add((Object)value);
                }
            }
            NodeResponse response = this.updateNode("listField", (Field)list);
            BooleanFieldListImpl field = response.getFields().getBooleanFieldList("listField");
            Assertions.assertThat((List)field.getItems()).as("Updated field", new Object[0]).containsExactlyElementsOf((Iterable)list.getItems());
            try (Tx tx = this.tx();){
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getBooleanList(arg_0), "listField"));
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        BooleanFieldListImpl list = new BooleanFieldListImpl();
        list.add((Object)true);
        list.add((Object)false);
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getBooleanFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getBooleanList("listField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getBooleanList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getBooleanList("listField").getList().stream().map(item -> item.getBoolean()).collect(Collectors.toList());
            Assertions.assertThat(oldValueList).containsExactly((Object[])new Boolean[]{true, false});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        BooleanFieldListImpl list = new BooleanFieldListImpl();
        list.add((Object)true);
        list.add((Object)false);
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        BooleanFieldListImpl emptyField = new BooleanFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getBooleanFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        Assertions.assertThat((List)secondResponse.getFields().getBooleanFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Override
    public NodeResponse createNodeWithField() {
        BooleanFieldListImpl listField = new BooleanFieldListImpl();
        listField.add((Object)true);
        listField.add((Object)false);
        return this.createNode("listField", (Field)listField);
    }
}

