/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.bool;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibBooleanField;
import com.gentics.mesh.core.data.node.field.list.HibBooleanFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.bool.BooleanListFieldHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.BooleanFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class BooleanListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String BOOLEAN_LIST = "booleanList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("boolean");
        schema.setName(BOOLEAN_LIST);
        schema.setRequired(isRequired);
        return schema;
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("boolean");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareNode(node, BOOLEAN_LIST, "boolean");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibBooleanFieldList booleanList = container.createBooleanList(BOOLEAN_LIST);
            booleanList.createBoolean(Boolean.valueOf(true));
            booleanList.createBoolean(null);
            booleanList.createBoolean(Boolean.valueOf(false));
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, BOOLEAN_LIST, "boolean", response);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBooleanFieldList list = container.createBooleanList(BOOLEAN_LIST);
            list.createBoolean(Boolean.valueOf(true));
            list.createBoolean(Boolean.valueOf(false));
            list.createBoolean(null);
            Assert.assertEquals((String)"Only non-null values are persisted.", (long)2L, (long)list.getList().size());
            Assert.assertEquals((long)2L, (long)list.getSize());
            Assert.assertNotNull((Object)list.getBoolean(1));
            Assert.assertTrue((boolean)list.getBoolean(1).getBoolean());
            list.removeAll();
            Assert.assertEquals((long)0L, (long)list.getSize());
            Assert.assertEquals((long)0L, (long)list.getList().size());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("testField", true)});
            HibBooleanFieldList testField = container.createBooleanList("testField");
            testField.createBoolean(Boolean.valueOf(true));
            testField.createBoolean(Boolean.valueOf(false));
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("testField", true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assert.assertTrue((boolean)otherContainer.getBooleanList("testField").equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibBooleanFieldList fieldA = container.createBooleanList("fieldA");
            HibBooleanFieldList fieldB = container.createBooleanList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.addItem((HibListableField)fieldA.createBoolean(Boolean.valueOf(true)));
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.addItem((HibListableField)fieldB.createBoolean(Boolean.valueOf(true)));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibBooleanFieldList fieldA = container.createBooleanList(BOOLEAN_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            Boolean dummyValue = true;
            HibBooleanFieldList fieldA = container.createBooleanList(BOOLEAN_LIST);
            BooleanFieldListImpl restField = new BooleanFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.addItem((HibListableField)fieldA.createBoolean(dummyValue));
            restField.add((Object)false);
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            restField.add((Object)dummyValue);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            StringFieldListImpl otherTypeRestField = new StringFieldListImpl();
            otherTypeRestField.add((Object)"true");
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(BOOLEAN_LIST, BooleanListFieldHelper.FETCH, BooleanListFieldHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(BOOLEAN_LIST, BooleanListFieldHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(BOOLEAN_LIST, BooleanListFieldHelper.FETCH, BooleanListFieldHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, BOOLEAN_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(BOOLEAN_LIST, BooleanListFieldHelper.FETCH, BooleanListFieldHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, BOOLEAN_LIST, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(BOOLEAN_LIST, BooleanListFieldHelper.FILL, container -> {
                BooleanFieldListImpl field = new BooleanFieldListImpl();
                field.getItems().add(true);
                field.getItems().add(false);
                this.updateContainer(ac, (HibNodeFieldContainer)container, BOOLEAN_LIST, (Field)field);
            }, container -> {
                HibBooleanFieldList field = container.getBooleanList(BOOLEAN_LIST);
                Assert.assertNotNull((String)"The graph field {booleanList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)true, (Object)((HibBooleanField)field.getList().get(0)).getBoolean());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)false, (Object)((HibBooleanField)field.getList().get(1)).getBoolean());
            });
        }
    }
}

