/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.date;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibDateField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.DateFieldImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.DateUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class DateFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "dateField";

    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            DateFieldSchemaImpl dateFieldSchema = new DateFieldSchemaImpl();
            dateFieldSchema.setName(FIELD_NAME);
            dateFieldSchema.setLabel("Some label");
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(dateFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(FIELD_NAME, null);
        DateFieldImpl field = response.getFields().getDateField(FIELD_NAME);
        Assert.assertNull((Object)field);
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        for (int i = 0; i < 20; ++i) {
            Long oldValue;
            HibNodeFieldContainer container;
            Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)(System.currentTimeMillis() + (long)(i * 10000))));
            try (Tx tx = this.tx();){
                container = tx.contentDao().getFieldContainer(node, "en");
                oldValue = this.getDateValue(container, FIELD_NAME);
            }
            NodeResponse response = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
            DateFieldImpl field = response.getFields().getDateField(FIELD_NAME);
            Assert.assertEquals((String)"The timestamp did not match up.", (Object)DateUtils.toISO8601((long)nowEpoch), (Object)field.getDate());
            try (Tx tx = this.tx();){
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", (Object)oldValue, (Object)this.getDateValue(container, FIELD_NAME));
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getDateField(FIELD_NAME)).as("Field Value", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getDate(FIELD_NAME)).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getDate(FIELD_NAME)).isNotNull();
            Long oldValue = latest.getPreviousVersion().getDate(FIELD_NAME).getDate();
            Assertions.assertThat((Long)oldValue).isEqualTo((Object)nowEpoch);
        }
        tx = this.tx();
        try {
            NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
            Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new DateFieldImpl());
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getDateField(FIELD_NAME)).as("Field Value", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
    }

    @Test
    public void testDateFormat() {
        String invalidDate = "2017-08-21T10:46:26+0200";
        this.updateNodeFailure(FIELD_NAME, (Field)new DateFieldImpl().setDate(invalidDate), HttpResponseStatus.BAD_REQUEST, "error_date_format_invalid", invalidDate);
    }

    protected Long getDateValue(HibNodeFieldContainer container, String fieldName) {
        HibDateField field = container.getDate(fieldName);
        return field != null ? field.getDate() : null;
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
        NodeResponse response = this.createNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
        DateFieldImpl field = response.getFields().getDateField(FIELD_NAME);
        Assert.assertEquals((Object)DateUtils.toISO8601((long)nowEpoch), (Object)field.getDate());
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        Long nowEpoch;
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createDate(FIELD_NAME).setDate(nowEpoch);
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        DateFieldImpl deserializedDateField = response.getFields().getDateField(FIELD_NAME);
        Assert.assertNotNull((Object)deserializedDateField);
        Assert.assertEquals((Object)DateUtils.toISO8601((long)nowEpoch), (Object)deserializedDateField.getDate());
    }

    @Override
    public NodeResponse createNodeWithField() {
        Long nowEpoch = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
        return this.createNode(FIELD_NAME, (Field)new DateFieldImpl().setDate(DateUtils.toISO8601((long)nowEpoch)));
    }
}

