/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.date;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.DateUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class DateFieldListEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "date";
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        DateFieldListImpl listField = new DateFieldListImpl();
        String dateA = DateUtils.toISO8601((long)4200L);
        String dateB = DateUtils.toISO8601((long)4100L);
        listField.add((Object)dateA);
        listField.add((Object)dateB);
        NodeResponse response = this.createNode("listField", (Field)listField);
        DateFieldListImpl field = response.getFields().getDateFieldList("listField");
        Assertions.assertThat((List)field.getItems()).as("List with valid values", new Object[0]).containsExactly((Object[])new String[]{dateA, dateB});
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        DateFieldListImpl listField = new DateFieldListImpl();
        listField.add((Object)DateUtils.toISO8601((long)4200L));
        listField.add((Object)DateUtils.toISO8601((long)4100L));
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        DateFieldListImpl listField = new DateFieldListImpl();
        String dateA = DateUtils.toISO8601((long)4200L);
        String dateB = DateUtils.toISO8601((long)4100L);
        listField.add((Object)dateA);
        listField.add((Object)dateB);
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)response.getFields().getDateFieldList("listField")).as("List field in response should be null", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        DateFieldListImpl listField = new DateFieldListImpl();
        listField.add((Object)DateUtils.toISO8601((long)4200L));
        listField.add((Object)DateUtils.toISO8601((long)4100L));
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)listField);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        DateFieldListImpl listField = new DateFieldListImpl();
        listField.add((Object)DateUtils.toISO8601((long)4200L));
        listField.add((Object)DateUtils.toISO8601((long)4100L));
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        NodeResponse response = this.readNode("dummy", firstResponse.getUuid());
        DateFieldListImpl deserializedField = response.getFields().getDateFieldList("listField");
        Assert.assertNotNull((Object)deserializedField);
        Assertions.assertThat((List)deserializedField.getItems()).as("List field values from updated node", new Object[0]).containsExactly((Object[])new String[]{DateUtils.toISO8601((long)4200L), DateUtils.toISO8601((long)4100L)});
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() throws IOException {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        List<List> valueCombinations = Arrays.asList(Arrays.asList(DateUtils.toISO8601((long)1000L), DateUtils.toISO8601((long)2000L), DateUtils.toISO8601((long)3000L)), Arrays.asList(DateUtils.toISO8601((long)3000L), DateUtils.toISO8601((long)2000L), DateUtils.toISO8601((long)1000L)), Collections.emptyList(), Arrays.asList(DateUtils.toISO8601((long)471100L), DateUtils.toISO8601((long)81500L)), Arrays.asList(DateUtils.toISO8601((long)3000L)));
        for (int i = 0; i < 20; ++i) {
            List oldValue;
            HibNodeFieldContainer container;
            DateFieldListImpl list = new DateFieldListImpl();
            try (Tx tx = this.tx();){
                container = tx.contentDao().getFieldContainer(node, "en");
                oldValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getDateList(arg_0), "listField");
                List newValue = valueCombinations.get(i % valueCombinations.size());
                for (String value : newValue) {
                    list.add((Object)value);
                }
            }
            NodeResponse response = this.updateNode("listField", (Field)list);
            try (Tx tx = this.tx();){
                DateFieldListImpl field = response.getFields().getDateFieldList("listField");
                Assertions.assertThat((List)field.getItems()).as("Updated field", new Object[0]).containsExactlyElementsOf((Iterable)list.getItems());
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getDateList(arg_0), "listField"));
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        DateFieldListImpl list = new DateFieldListImpl();
        String dateA = DateUtils.toISO8601((long)42000L);
        String dateB = DateUtils.toISO8601((long)41000L);
        list.add((Object)dateA);
        list.add((Object)dateB);
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getDateFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getDateList("listField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getDateList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getDateList("listField").getList().stream().map(item -> item.getDate()).collect(Collectors.toList());
            Assertions.assertThat(oldValueList).containsExactly((Object[])new Number[]{42000L, 41000L});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        DateFieldListImpl list = new DateFieldListImpl();
        String dateA = DateUtils.toISO8601((long)4200L);
        String dateB = DateUtils.toISO8601((long)4100L);
        list.add((Object)dateA);
        list.add((Object)dateB);
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        DateFieldListImpl emptyField = new DateFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getDateFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        Assertions.assertThat((List)secondResponse.getFields().getDateFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Override
    public NodeResponse createNodeWithField() {
        DateFieldListImpl listField = new DateFieldListImpl();
        String dateA = DateUtils.toISO8601((long)4200L);
        String dateB = DateUtils.toISO8601((long)4100L);
        listField.add((Object)dateA);
        listField.add((Object)dateB);
        return this.createNode("listField", (Field)listField);
    }
}

