/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.date;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibDateField;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.date.DateFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.DateFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.DateFieldSchema;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.DateUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class DateFieldTest
extends AbstractFieldTest<DateFieldSchema> {
    private static final String DATE_FIELD = "dateField";

    @Override
    protected DateFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(DATE_FIELD, isRequired);
    }

    protected DateFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        DateFieldSchemaImpl dateFieldSchema = new DateFieldSchemaImpl();
        dateFieldSchema.setName(fieldKey);
        dateFieldSchema.setLabel("Some date field");
        dateFieldSchema.setRequired(isRequired);
        return dateFieldSchema;
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            Long nowEpoch = System.currentTimeMillis() / 1000L;
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateField dateField = container.createDate(DATE_FIELD);
            dateField.setDate(nowEpoch);
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            dateField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getDate(DATE_FIELD)).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)dateField, new String[]{"parentContainer"});
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            Long nowEpoch = System.currentTimeMillis() / 1000L;
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateField dateField = container.createDate(DATE_FIELD);
            Assert.assertEquals((Object)DATE_FIELD, (Object)dateField.getFieldKey());
            dateField.setDate(nowEpoch);
            Assert.assertEquals((Object)nowEpoch, (Object)dateField.getDate());
            HibStringField bogusField1 = container.getString("bogus");
            Assert.assertNull((Object)bogusField1);
            HibDateField reloadedDateField = container.getDate(DATE_FIELD);
            Assert.assertNotNull((Object)reloadedDateField);
            Assert.assertEquals((Object)DATE_FIELD, (Object)reloadedDateField.getFieldKey());
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        long date;
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            this.prepareTypedSchema(node, (FieldSchema)this.createFieldSchema(true), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibDateField field = container.createDate(DATE_FIELD);
            date = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
            field.setDate(Long.valueOf(date));
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            DateFieldImpl deserializedNodeField = response.getFields().getDateField(DATE_FIELD);
            Assert.assertNotNull((Object)deserializedNodeField);
            Assert.assertEquals((Object)date, (Object)DateUtils.fromISO8601((String)deserializedNodeField.getDate()));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true), this.createFieldSchema("dateField_2", true)});
            Long date = System.currentTimeMillis();
            HibDateField fieldA = container.createDate(DATE_FIELD);
            HibDateField fieldB = container.createDate("dateField_2");
            fieldA.setDate(date);
            fieldB.setDate(date);
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateField fieldA = container.createDate(DATE_FIELD);
            HibDateField fieldB = container.createDate("dateField_2");
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            Long date = System.currentTimeMillis();
            HibDateField fieldA = container.createDate(DATE_FIELD);
            DateFieldImpl restField = new DateFieldImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.setDate(DateUtils.fromISO8601((String)DateUtils.toISO8601((long)date)));
            restField.setDate(DateUtils.toISO8601((long)(date + 1000L)));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.setDate(DateUtils.toISO8601((long)date));
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(new StringFieldImpl().setString(String.valueOf(date))));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(DATE_FIELD, DateFieldTestHelper.FETCH, DateFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(DATE_FIELD, DateFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(DATE_FIELD, DateFieldTestHelper.FETCH, DateFieldTestHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, DATE_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(DATE_FIELD, DateFieldTestHelper.FETCH, DateFieldTestHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, DATE_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(DATE_FIELD, DateFieldTestHelper.FILL, container -> {
                DateFieldImpl field = new DateFieldImpl();
                field.setDate(DateUtils.toISO8601((Long)0L, (long)0L));
                this.updateContainer(ac, (HibNodeFieldContainer)container, DATE_FIELD, (Field)field);
            }, container -> {
                HibDateField field = container.getDate(DATE_FIELD);
                Assert.assertNotNull((String)"The graph field {dateField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The date of the field was not updated.", (long)0L, (long)field.getDate());
            });
        }
    }
}

