/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.date;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibDateField;
import com.gentics.mesh.core.data.node.field.list.HibDateFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.date.DateListFieldHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NumberFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.DateUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class DateListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String DATE_LIST = "dateList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(DATE_LIST, isRequired);
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("date");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareNode(node, DATE_LIST, "date");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibDateFieldList dateList = container.createDateList(DATE_LIST);
            dateList.createDate(Long.valueOf(1L));
            dateList.createDate(Long.valueOf(2L));
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, DATE_LIST, "date", response);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateFieldList list = container.createDateList(DATE_LIST);
            Assert.assertNotNull((Object)list);
            HibDateField dateField = list.createDate(Long.valueOf(1L));
            Assert.assertNotNull((Object)dateField);
            Assert.assertEquals((long)1L, (long)list.getSize());
            Assert.assertEquals((long)1L, (long)list.getList().size());
            list.removeAll();
            Assert.assertEquals((long)0L, (long)list.getSize());
            Assert.assertEquals((long)0L, (long)list.getList().size());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateFieldList testField = container.createDateList(DATE_LIST);
            testField.createDate(Long.valueOf(47L));
            testField.createDate(Long.valueOf(11L));
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assert.assertTrue((boolean)otherContainer.getDateList(DATE_LIST).equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibDateFieldList fieldA = container.createDateList("fieldA");
            HibDateFieldList fieldB = container.createDateList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.addItem((HibListableField)fieldA.createDate(Long.valueOf(42L)));
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.addItem((HibListableField)fieldB.createDate(Long.valueOf(42L)));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibDateFieldList fieldA = container.createDateList(DATE_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            Long dummyValue = 4200L;
            HibDateFieldList fieldA = container.createDateList(DATE_LIST);
            DateFieldListImpl restField = new DateFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.addItem((HibListableField)fieldA.createDate(dummyValue));
            restField.add((Object)DateUtils.toISO8601((long)(dummyValue + 1000L)));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            restField.add((Object)DateUtils.toISO8601((long)dummyValue));
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            NumberFieldListImpl otherTypeRestField = new NumberFieldListImpl();
            otherTypeRestField.add((Object)dummyValue);
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(DATE_LIST, DateListFieldHelper.FETCH, DateListFieldHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(DATE_LIST, DateListFieldHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(DATE_LIST, DateListFieldHelper.FETCH, DateListFieldHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, DATE_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(DATE_LIST, DateListFieldHelper.FETCH, DateListFieldHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, DATE_LIST, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(DATE_LIST, DateListFieldHelper.FILL, container -> {
                DateFieldListImpl field = new DateFieldListImpl();
                field.getItems().add(DateUtils.toISO8601((long)42000L));
                field.getItems().add(DateUtils.toISO8601((long)43000L));
                this.updateContainer(ac, (HibNodeFieldContainer)container, DATE_LIST, (Field)field);
            }, container -> {
                HibDateFieldList field = container.getDateList(DATE_LIST);
                Assert.assertNotNull((String)"The graph field {dateList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (long)42000L, (long)((HibDateField)field.getList().get(0)).getDate());
                Assert.assertEquals((String)"The list item of the field was not updated.", (long)43000L, (long)((HibDateField)field.getList().get(1)).getDate());
            });
        }
    }
}

