/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.html;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibHtmlField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.util.VersionNumber;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class HtmlFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "htmlField";

    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            HtmlFieldSchemaImpl htmlFieldSchema = new HtmlFieldSchemaImpl();
            htmlFieldSchema.setName(FIELD_NAME);
            htmlFieldSchema.setLabel("Some label");
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(htmlFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(null, null);
        HtmlFieldImpl htmlField = response.getFields().getHtmlField(FIELD_NAME);
        Assert.assertNull((String)"The response should not contain the field because it should still be null", (Object)htmlField);
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        HibNode node = this.folder("2015");
        for (int i = 0; i < 20; ++i) {
            VersionNumber oldVersion = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en").getVersion());
            String newValue = "some<b>html <i>" + i + "</i>";
            NodeResponse response = this.updateNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML(newValue));
            HtmlFieldImpl field = response.getFields().getHtmlField(FIELD_NAME);
            Assert.assertEquals((Object)newValue, (Object)field.getHTML());
            Assert.assertEquals((String)"Check version number", (Object)oldVersion.nextDraft().toString(), (Object)response.getVersion());
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML("bla"));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML("bla"));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML("bla"));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getHtmlField(FIELD_NAME)).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getHtml(FIELD_NAME)).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getHtml(FIELD_NAME)).isNotNull();
            String oldValue = latest.getPreviousVersion().getHtml(FIELD_NAME).getHTML();
            Assertions.assertThat((String)oldValue).isEqualTo((Object)"bla");
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    @Category(value={FailingTests.class})
    @Deprecated(forRemoval=true)
    public void testUpdateSetEmpty() {
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML("bla"));
        String oldVersion = firstResponse.getVersion();
        HtmlFieldImpl emptyField = new HtmlFieldImpl();
        emptyField.setHTML("");
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getHtmlField(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getFields().getHtmlField(FIELD_NAME).getHTML()).as("Updated Field Value", new Object[0])).isEqualTo((Object)"");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        HtmlFieldImpl htmlField = response.getFields().getHtmlField(FIELD_NAME);
        Assert.assertEquals((Object)"Some<b>html", (Object)htmlField.getHTML());
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createHTML(FIELD_NAME).setHtml("some<b>html");
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        HtmlFieldImpl deserializedHtmlField = response.getFields().getHtmlField(FIELD_NAME);
        Assert.assertNotNull((Object)deserializedHtmlField);
        Assert.assertEquals((Object)"some<b>html", (Object)deserializedHtmlField.getHTML());
    }

    protected String getHtmlValue(HibNodeFieldContainer container, String fieldName) {
        HibHtmlField field = container.getHtml(fieldName);
        return field != null ? field.getHTML() : null;
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode(FIELD_NAME, (Field)new HtmlFieldImpl().setHTML("Some<b>html"));
    }
}

