/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.html;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.DateFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class HtmlFieldListEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "html";
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        HtmlFieldListImpl field = response.getFields().getHtmlFieldList("listField");
        Assertions.assertThat((List)field.getItems()).containsExactly((Object[])new String[]{"A", "B", "C"});
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)response.getFields().getHtmlFieldList("listField")).as("List field in reponse should be null", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add((Object)"C");
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)listField);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add((Object)"C");
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        NodeResponse response = this.readNode("dummy", firstResponse.getUuid());
        HtmlFieldListImpl deserializedField = response.getFields().getHtmlFieldList("listField");
        Assert.assertNotNull((Object)deserializedField);
        Assertions.assertThat((List)deserializedField.getItems()).as("List field values from updated node", new Object[0]).containsExactly((Object[])new String[]{"A", "B", "C"});
    }

    @Test
    public void testHtmlList() throws IOException {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add((Object)"C");
        NodeResponse response = this.createNode("listField", (Field)listField);
        HtmlFieldListImpl listFromResponse = response.getFields().getHtmlFieldList("listField");
        Assert.assertEquals((long)3L, (long)listFromResponse.getItems().size());
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() throws IOException {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        List<List> valueCombinations = Arrays.asList(Arrays.asList("A", "B", "C"), Arrays.asList("C", "B", "A"), Collections.emptyList(), Arrays.asList("X", "Y"), Arrays.asList("C"));
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
        for (int i = 0; i < 20; ++i) {
            List newValue;
            try (Tx tx2 = this.tx();){
                List oldValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getHTMLList(arg_0), "listField");
                newValue = valueCombinations.get(i % valueCombinations.size());
            }
            HtmlFieldListImpl list = new HtmlFieldListImpl();
            for (String value : newValue) {
                list.add((Object)value);
            }
            System.out.println("Update to " + list);
            NodeResponse response = this.updateNode("listField", (Field)list);
            try (Tx tx3 = this.tx();){
                ContentDao contentDao = tx3.contentDao();
                HtmlFieldListImpl field = response.getFields().getHtmlFieldList("listField");
                Assertions.assertThat((List)field.getItems()).as("Updated field", new Object[0]).containsExactlyElementsOf((Iterable)list.getItems());
                HibNodeFieldContainer updatedContainer = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                Assert.assertEquals((String)"The container version number did not match up with the response version number.", (Object)updatedContainer.getVersion().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)("We expected container {" + container.getVersion().toString() + "} to contain the old value."), (Object)newValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)updatedContainer).getHTMLList(arg_0), "listField"));
                container = updatedContainer;
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        HtmlFieldListImpl list = new HtmlFieldListImpl();
        list.add((Object)"A");
        list.add((Object)"B");
        this.updateNode("listField", (Field)list);
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getHtmlFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getHTMLList("listField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getHTMLList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getHTMLList("listField").getList().stream().map(item -> item.getHTML()).collect(Collectors.toList());
            Assertions.assertThat(oldValueList).containsExactly((Object[])new String[]{"A", "B"});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        HtmlFieldListImpl list = new HtmlFieldListImpl();
        list.add((Object)"A");
        list.add((Object)"B");
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        DateFieldListImpl emptyField = new DateFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getHtmlFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        Assertions.assertThat((List)secondResponse.getFields().getHtmlFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Override
    public NodeResponse createNodeWithField() {
        HtmlFieldListImpl listField = new HtmlFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add((Object)"C");
        return this.createNode("listField", (Field)listField);
    }
}

