/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.html;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibHtmlField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.html.HtmlFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.HtmlFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class HtmlFieldTest
extends AbstractFieldTest<HtmlFieldSchema> {
    private static final String HTML_FIELD = "htmlField";

    @Override
    protected HtmlFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(HTML_FIELD, isRequired);
    }

    protected HtmlFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        HtmlFieldSchemaImpl schema = new HtmlFieldSchemaImpl();
        schema.setLabel("Some html field");
        schema.setRequired(isRequired);
        schema.setName(fieldKey);
        return schema;
    }

    @Override
    @Test
    public void testFieldUpdate() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlField htmlField = container.createHTML(HTML_FIELD);
            Assert.assertEquals((Object)HTML_FIELD, (Object)htmlField.getFieldKey());
            htmlField.setHtml("dummyHTML");
            Assert.assertEquals((Object)"dummyHTML", (Object)htmlField.getHTML());
            HibHtmlField bogusField1 = container.getHtml("bogus");
            Assert.assertNull((Object)bogusField1);
            HibHtmlField reloadedHTMLField = container.getHtml(HTML_FIELD);
            Assert.assertNotNull((Object)reloadedHTMLField);
            Assert.assertEquals((Object)HTML_FIELD, (Object)reloadedHTMLField.getFieldKey());
            Assert.assertEquals((Object)"dummyHTML", (Object)reloadedHTMLField.getHTML());
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HtmlFieldSchemaImpl htmlFieldSchema = new HtmlFieldSchemaImpl();
            htmlFieldSchema.setName(HTML_FIELD);
            htmlFieldSchema.setLabel("Some html field");
            htmlFieldSchema.setRequired(true);
            this.prepareTypedSchema(node, (FieldSchema)htmlFieldSchema, false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibHtmlField field = container.createHTML(HTML_FIELD);
            field.setHtml("Some<b>htmlABCDE");
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertTrue((String)("The json should contain the string but it did not.{" + json + "}"), (json.indexOf("ABCDE") > 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            HtmlFieldImpl deserializedNodeField = response.getFields().getHtmlField(HTML_FIELD);
            Assert.assertNotNull((Object)deserializedNodeField);
            Assert.assertEquals((Object)"Some<b>htmlABCDE", (Object)deserializedNodeField.getHTML());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibHtmlField fieldA = container.createHTML("fieldA");
            HibHtmlField fieldB = container.createHTML("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.setHtml("someText");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.setHtml("someText");
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlField fieldA = container.createHTML("htmlField1");
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlField fieldA = container.createHTML(HTML_FIELD);
            Assert.assertTrue((String)"The html field should be equal to the html rest field since both fields have no value.", (boolean)fieldA.equals(new HtmlFieldImpl()));
            fieldA.setHtml("someText");
            Assert.assertFalse((String)"The html field should not be equal to a string rest field. Even if it has the same value", (boolean)fieldA.equals(new StringFieldImpl().setString("someText")));
            Assert.assertFalse((String)"The html field should not be equal to the html rest field since the rest field has a different value.", (boolean)fieldA.equals(new HtmlFieldImpl().setHTML("someText2")));
            Assert.assertTrue((String)"The html field should be equal to a html rest field with the same value", (boolean)fieldA.equals(new HtmlFieldImpl().setHTML("someText")));
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlField htmlField = container.createHTML(HTML_FIELD);
            htmlField.setHtml("<i>HTML</i>");
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            htmlField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getHtml(HTML_FIELD)).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)htmlField, new String[]{"parentContainer"});
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(HTML_FIELD, HtmlFieldTestHelper.FETCH, HtmlFieldTestHelper.FILLTEXT, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, HTML_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(HTML_FIELD, HtmlFieldTestHelper.FETCH, HtmlFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(HTML_FIELD, HtmlFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(HTML_FIELD, HtmlFieldTestHelper.FETCH, HtmlFieldTestHelper.FILLTEXT, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, HTML_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(HTML_FIELD, HtmlFieldTestHelper.FILLTEXT, container -> {
                HtmlFieldImpl field = new HtmlFieldImpl();
                field.setHTML("someValue");
                this.updateContainer(ac, (HibNodeFieldContainer)container, HTML_FIELD, (Field)field);
            }, container -> {
                HibHtmlField field = container.getHtml(HTML_FIELD);
                Assert.assertNotNull((String)"The graph field {htmlField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The html of the field was not updated.", (Object)"someValue", (Object)field.getHTML());
            });
        }
    }
}

