/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.html;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibHtmlField;
import com.gentics.mesh.core.data.node.field.list.HibHtmlFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.html.HtmlListFieldHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class HtmlListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String HTML_LIST = "htmlList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(HTML_LIST, isRequired);
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("html");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            this.prepareNode(node, "nodeList", "node");
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            ListFieldSchemaImpl htmlListFieldSchema = new ListFieldSchemaImpl();
            htmlListFieldSchema.setName(HTML_LIST);
            htmlListFieldSchema.setListType("html");
            this.prepareTypedSchema(node, (FieldSchema)htmlListFieldSchema, true);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibHtmlFieldList htmlList = container.createHTMLList(HTML_LIST);
            htmlList.createHTML("some<b>html</b>");
            htmlList.createHTML("some<b>more html</b>");
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, HTML_LIST, "html", response);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlFieldList list = container.createHTMLList(HTML_LIST);
            Assert.assertNotNull((Object)list);
            HibHtmlField htmlField = list.createHTML("HTML 1");
            Assert.assertNotNull((Object)htmlField);
            Assert.assertEquals((long)1L, (long)list.getSize());
            Assert.assertEquals((long)1L, (long)list.getList().size());
            list.removeAll();
            Assert.assertEquals((long)0L, (long)list.getSize());
            Assert.assertEquals((long)0L, (long)list.getList().size());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlFieldList testField = container.createHTMLList(HTML_LIST);
            testField.createHTML("<b>One</b>");
            testField.createHTML("<i>Two</i>");
            testField.createHTML("<u>Three</u>");
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assertions.assertThat((boolean)otherContainer.getHTMLList(HTML_LIST).equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibHtmlFieldList fieldA = container.createHTMLList("fieldA");
            HibHtmlFieldList fieldB = container.createHTMLList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.addItem((HibListableField)fieldA.createHTML("testHtml"));
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.addItem((HibListableField)fieldB.createHTML("testHtml"));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibHtmlFieldList fieldA = container.createHTMLList(HTML_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            String dummyValue = "test123";
            HibHtmlFieldList fieldA = container.createHTMLList(HTML_LIST);
            HtmlFieldListImpl restField = new HtmlFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.addItem((HibListableField)fieldA.createHTML(dummyValue));
            restField.add((Object)(dummyValue + "1"));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            restField.add((Object)dummyValue);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            StringFieldListImpl otherTypeRestField = new StringFieldListImpl();
            otherTypeRestField.add((Object)dummyValue);
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(HTML_LIST, HtmlListFieldHelper.FETCH, HtmlListFieldHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(HTML_LIST, HtmlListFieldHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(HTML_LIST, HtmlListFieldHelper.FETCH, HtmlListFieldHelper.FILLTEXT, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, HTML_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(HTML_LIST, HtmlListFieldHelper.FETCH, HtmlListFieldHelper.FILLTEXT, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, HTML_LIST, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(HTML_LIST, HtmlListFieldHelper.FILLTEXT, container -> {
                HtmlFieldListImpl field = new HtmlFieldListImpl();
                field.getItems().add("someValue");
                field.getItems().add("someValue2");
                this.updateContainer(ac, (HibNodeFieldContainer)container, HTML_LIST, (Field)field);
            }, container -> {
                HibHtmlFieldList field = container.getHTMLList(HTML_LIST);
                Assert.assertNotNull((String)"The graph field {htmlList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"someValue", (Object)((HibHtmlField)field.getList().get(0)).getHTML());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"someValue2", (Object)((HibHtmlField)field.getList().get(1)).getHTML());
            });
        }
    }
}

