/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.micronode;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.MicronodeAssert;
import com.gentics.mesh.assertj.impl.MicronodeResponseAssert;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.AbstractFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.DateUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class MicronodeFieldEndpointTest
extends AbstractFieldEndpointTest {
    protected static final String FIELD_NAME = "micronodeField";

    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            MicronodeFieldSchemaImpl microschemaFieldSchema = new MicronodeFieldSchemaImpl();
            microschemaFieldSchema.setName(FIELD_NAME);
            microschemaFieldSchema.setLabel("Some label");
            microschemaFieldSchema.setAllowedMicroSchemas(new String[]{"vcard"});
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(microschemaFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(FIELD_NAME, null);
        MicronodeResponse field = response.getFields().getMicronodeField(FIELD_NAME);
        Assert.assertNull((Object)field);
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        this.updateNode(FIELD_NAME, (Field)field);
        for (int i = 0; i < 20; ++i) {
            String newLastName = "Moritz" + i;
            HibMicronode oldValue = null;
            HibNodeFieldContainer container = null;
            try (Tx tx = this.tx();){
                container = tx.contentDao().getFieldContainer(node, "en");
                oldValue = this.getMicronodeValue(container, FIELD_NAME);
                field = new MicronodeResponse();
                field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
                field.getFields().put("lastName", (Field)new StringFieldImpl().setString(newLastName));
            }
            NodeResponse response = this.updateNode(FIELD_NAME, (Field)field);
            try (Tx tx = this.tx();){
                ContentDao contentDao = tx.contentDao();
                MicronodeResponse fieldResponse = response.getFields().getMicronodeField(FIELD_NAME);
                MeshAssertions.assertThat((MicronodeResponse)fieldResponse).hasStringField("firstName", "Max").hasStringField("lastName", newLastName);
                contentDao.getNextVersions(container).iterator().next();
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                if (oldValue == null) {
                    ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)this.getMicronodeValue(container, FIELD_NAME)).as("old value", new Object[0])).isNull();
                    continue;
                }
                ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)oldValue.getString("lastName").getString()).as("old lastName", new Object[0])).isNotEqualTo((Object)newLastName);
                ((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)this.getMicronodeValue(container, FIELD_NAME)).as("old value", new Object[0])).isEqualToComparingFieldByField((Object)oldValue);
                ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)fieldResponse.getUuid()).as("New uuid", new Object[0])).isNotEqualTo((Object)oldValue.getUuid());
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)field);
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            MeshAssertions.assertThat((MicronodeResponse)secondResponse.getFields().getMicronodeField(FIELD_NAME)).isNull();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldNumber);
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            MeshAssertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            MeshAssertions.assertThat((Object)latest.getMicronode(FIELD_NAME)).isNull();
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)latest.getPreviousVersion().getMicronode(FIELD_NAME)).as("The old version micronode field could not be found.", new Object[0])).isNotNull();
            HibMicronode oldMicronode = latest.getPreviousVersion().getMicronode(FIELD_NAME).getMicronode();
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)oldMicronode.getString("firstName").getString()).as("Old version micronode firstname field value should not be modified", new Object[0])).isEqualTo((Object)"Max");
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldVersion = firstResponse.getVersion();
        this.createNodeAndExpectFailure(FIELD_NAME, (Field)new MicronodeResponse(), HttpResponseStatus.BAD_REQUEST, "micronode_error_missing_reference", FIELD_NAME);
        MicronodeResponse emptyField = new MicronodeResponse().setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        ((MicronodeResponseAssert)MeshAssertions.assertThat((MicronodeResponse)secondResponse.getFields().getMicronodeField(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        MeshAssertions.assertThat((String)secondResponse.getFields().getMicronodeField(FIELD_NAME).getFields().getStringField("firstName").getString()).isEqualTo((Object)"Max");
        MeshAssertions.assertThat((String)secondResponse.getFields().getMicronodeField(FIELD_NAME).getFields().getStringField("lastName").getString()).isEqualTo((Object)"Moritz");
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("No new version number should have been generated", new Object[0])).isEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        MicronodeResponse createdField = response.getFields().getMicronodeField(FIELD_NAME);
        Assert.assertNotNull((String)"Created field does not exist", (Object)createdField);
        Assert.assertNotNull((String)"Micronode has no uuid set", (Object)createdField.getUuid());
        Assert.assertEquals((String)"Check microschema name", (Object)"vcard", (Object)createdField.getMicroschema().getName());
        Assert.assertEquals((String)"Check microschema uuid", (Object)this.microschemaContainers().get("vcard").getUuid(), (Object)createdField.getMicroschema().getUuid());
        StringFieldImpl createdFirstnameField = createdField.getFields().getStringField("firstName");
        Assert.assertNotNull((String)"Micronode did not contain firstName field", (Object)createdFirstnameField);
        Assert.assertEquals((String)"Check micronode firstName", (Object)"Max", (Object)createdFirstnameField.getString());
    }

    @Test
    public void testReferenceUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        AbstractFieldSchema innerNodeField = new NodeFieldSchemaImpl().setName("node");
        String vcardUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        MicroschemaVersionModel vcard = (MicroschemaVersionModel)this.tx(() -> this.microschemaContainers().get("vcard").getLatestVersion().getSchema());
        vcard.addField((FieldSchema)innerNodeField);
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)vcard.toJson(), MicroschemaUpdateRequest.class);
        ClientHelper.call(() -> this.client().updateMicroschema(vcardUuid, request, new ParameterProvider[0]));
        this.tx(tx -> {
            this.prepareTypedMicroschema(this.microschemaContainers().get("vcard"), List.of(innerNodeField));
            tx.success();
        });
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        field.getFields().put("node", (Field)new NodeFieldImpl().setUuid(targetUuid));
        this.updateNode(FIELD_NAME, (Field)field);
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Test
    public void testReferenceListUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        FieldSchema innerNodeListField = new ListFieldSchemaImpl().setListType("node").setName("node");
        String vcardUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        MicroschemaVersionModel vcard = (MicroschemaVersionModel)this.tx(() -> this.microschemaContainers().get("vcard").getLatestVersion().getSchema());
        vcard.addField(innerNodeListField);
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)vcard.toJson(), MicroschemaUpdateRequest.class);
        ClientHelper.call(() -> this.client().updateMicroschema(vcardUuid, request, new ParameterProvider[0]));
        this.tx(tx -> {
            this.prepareTypedMicroschema(this.microschemaContainers().get("vcard"), List.of(innerNodeListField));
            tx.success();
        });
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        NodeFieldListImpl nodeList = new NodeFieldListImpl();
        nodeList.add((Object)new NodeFieldListItemImpl().setUuid(targetUuid));
        nodeList.add((Object)new NodeFieldListItemImpl().setUuid(targetUuid));
        field.getFields().put("node", (Field)nodeList);
        this.updateNode(FIELD_NAME, (Field)field);
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Test
    public void testCreateNodeWithInvalidMicroschema() {
        MicronodeResponse field = new MicronodeResponse();
        MicroschemaReferenceImpl microschema = new MicroschemaReferenceImpl();
        microschema.setName("notexisting");
        field.setMicroschema((MicroschemaReference)microschema);
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        this.createNodeAndExpectFailure(FIELD_NAME, (Field)field, HttpResponseStatus.BAD_REQUEST, "error_microschema_reference_not_found", "notexisting", "-", "-");
    }

    @Test
    public void testCreateNodeWithNotAllowedMicroschema() {
        MicronodeResponse field = new MicronodeResponse();
        MicroschemaReferenceImpl microschema = new MicroschemaReferenceImpl();
        microschema.setName("captionedImage");
        field.setMicroschema((MicroschemaReference)microschema);
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        this.createNodeAndExpectFailure(FIELD_NAME, (Field)field, HttpResponseStatus.BAD_REQUEST, "node_error_invalid_microschema_field_value", FIELD_NAME, "captionedImage");
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() throws IOException {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibMicroschemaVersion microschema = this.microschemaContainers().get("vcard").getLatestVersion();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibMicronodeField micronodeField = container.createMicronode(FIELD_NAME, microschema);
            micronodeField.getMicronode().createString("firstName").setString("Max");
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        MicronodeResponse deserializedMicronodeField = response.getFields().getMicronodeField(FIELD_NAME);
        Assert.assertNotNull((String)"Micronode field must not be null", (Object)deserializedMicronodeField);
        StringFieldImpl firstNameField = deserializedMicronodeField.getFields().getStringField("firstName");
        Assert.assertNotNull((String)"Micronode must contain firstName field", (Object)firstNameField);
        Assert.assertEquals((String)"Check firstName value", (Object)"Max", (Object)firstNameField.getString());
    }

    @Test
    public void testExpandAllCyclicMicronodeWithNodeReference() {
        HibNode node = this.folder("2015");
        MicroschemaModelImpl nodeMicroschema = new MicroschemaModelImpl();
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            nodeMicroschema.setName("noderef");
            for (int i = 0; i < 10; ++i) {
                nodeMicroschema.addField((FieldSchema)new NodeFieldSchemaImpl().setName("nodefield_" + i));
            }
            HibMicroschema microschemaContainer = microschemaDao.create((MicroschemaVersionModel)nodeMicroschema, this.getRequestUser(), this.createBatch());
            this.microschemaContainers().put("noderef", microschemaContainer);
            microschemaDao.assign((HibFieldSchemaElement)microschemaContainer, this.project(), this.user(), this.createBatch());
            SchemaVersionModel schema = ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getSchema();
            MicronodeFieldSchemaImpl microschemaFieldSchema = new MicronodeFieldSchemaImpl();
            microschemaFieldSchema.setName("noderef");
            microschemaFieldSchema.setLabel("Micronode field");
            microschemaFieldSchema.setAllowedMicroSchemas(new String[]{"noderef"});
            schema.addField((FieldSchema)microschemaFieldSchema);
            ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).setSchema(schema);
            tx.success();
        }
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("noderef"));
        for (int i = 0; i < 10; ++i) {
            field.getFields().put("nodefield_" + i, (Field)FieldUtil.createNodeField((String)node.getUuid()));
        }
        NodeResponse response = this.updateNode("noderef", (Field)field, true);
        MeshAssertions.assertThat((MicronodeResponse)response.getFields().getMicronodeField("noderef")).matches(field, (MicroschemaModel)nodeMicroschema);
    }

    @Test
    public void testUpdateFieldTypes() throws IOException {
        Long date = System.currentTimeMillis();
        HibNode newsOverview = this.content("news overview");
        HibNode newsFolder = this.folder("news");
        MicroschemaModelImpl fullMicroschema = new MicroschemaModelImpl();
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            fullMicroschema.setName("full");
            fullMicroschema.addField((FieldSchema)new BooleanFieldSchemaImpl().setName("booleanfield").setLabel("Boolean Field"));
            fullMicroschema.addField((FieldSchema)new DateFieldSchemaImpl().setName("datefield").setLabel("Date Field"));
            fullMicroschema.addField((FieldSchema)new HtmlFieldSchemaImpl().setName("htmlfield").setLabel("HTML Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("boolean").setName("listfield-boolean").setLabel("Boolean List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("date").setName("listfield-date").setLabel("Date List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("html").setName("listfield-html").setLabel("Html List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("node").setName("listfield-node").setLabel("Node List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("number").setName("listfield-number").setLabel("Number List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("string").setName("listfield-string").setLabel("String List Field"));
            fullMicroschema.addField((FieldSchema)new NodeFieldSchemaImpl().setName("nodefield").setLabel("Node Field"));
            fullMicroschema.addField((FieldSchema)new NumberFieldSchemaImpl().setName("numberfield").setLabel("Number Field"));
            fullMicroschema.addField((FieldSchema)new StringFieldSchemaImpl().setName("stringfield").setLabel("String Field"));
            HibMicroschema microschemaContainer = microschemaDao.create((MicroschemaVersionModel)fullMicroschema, this.getRequestUser(), this.createBatch());
            this.microschemaContainers().put("full", microschemaContainer);
            microschemaDao.assign((HibFieldSchemaElement)microschemaContainer, this.project(), this.user(), this.createBatch());
            SchemaVersionModel schema = ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getSchema();
            MicronodeFieldSchemaImpl microschemaFieldSchema = new MicronodeFieldSchemaImpl();
            microschemaFieldSchema.setName("full");
            microschemaFieldSchema.setLabel("Micronode field");
            microschemaFieldSchema.setAllowedMicroSchemas(new String[]{"full"});
            schema.addField((FieldSchema)microschemaFieldSchema);
            ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).setSchema(schema);
            tx.success();
        }
        MicronodeResponse field = new MicronodeResponse();
        field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("full"));
        field.getFields().put("booleanfield", (Field)FieldUtil.createBooleanField((Boolean)true));
        field.getFields().put("datefield", (Field)FieldUtil.createDateField((String)DateUtils.toISO8601((long)date)));
        field.getFields().put("htmlfield", (Field)FieldUtil.createHtmlField((String)"<b>HTML</b> value"));
        field.getFields().put("listfield-boolean", (Field)FieldUtil.createBooleanListField((Boolean[])new Boolean[]{true, false}));
        field.getFields().put("listfield-date", (Field)FieldUtil.createDateListField((String[])new String[]{DateUtils.toISO8601((long)date), DateUtils.toISO8601((long)0L)}));
        field.getFields().put("listfield-html", (Field)FieldUtil.createHtmlListField((String[])new String[]{"<b>first</b>", "<i>second</i>", "<u>third</u>"}));
        field.getFields().put("listfield-node", (Field)FieldUtil.createNodeListField((String[])new String[]{newsOverview.getUuid(), newsFolder.getUuid()}));
        field.getFields().put("listfield-number", (Field)FieldUtil.createNumberListField((Number[])new Number[]{47, 11}));
        field.getFields().put("listfield-string", (Field)FieldUtil.createStringListField((String[])new String[]{"first", "second", "third"}));
        field.getFields().put("nodefield", (Field)FieldUtil.createNodeField((String)newsOverview.getUuid()));
        field.getFields().put("numberfield", (Field)FieldUtil.createNumberField((Number)4711));
        field.getFields().put("stringfield", (Field)FieldUtil.createStringField((String)"String value"));
        NodeResponse response = this.updateNode("full", (Field)field);
        MeshAssertions.assertThat((MicronodeResponse)response.getFields().getMicronodeField("full")).matches(field, (MicroschemaModel)fullMicroschema);
    }

    protected HibMicronode getMicronodeValue(HibNodeFieldContainer container, String fieldName) {
        HibMicronodeField field = container.getMicronode(fieldName);
        return field != null ? field.getMicronode() : null;
    }

    @Override
    public NodeResponse createNodeWithField() {
        MicronodeResponse field = new MicronodeResponse();
        MicroschemaReferenceImpl microschema = new MicroschemaReferenceImpl();
        microschema.setName("vcard");
        field.setMicroschema((MicroschemaReference)microschema);
        field.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        field.getFields().put("lastName", (Field)new StringFieldImpl().setString("Mustermann"));
        return this.createNode(FIELD_NAME, (Field)field);
    }
}

