/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.micronode;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.assertj.impl.JsonArrayAssert;
import com.gentics.mesh.assertj.impl.JsonObjectAssert;
import com.gentics.mesh.assertj.impl.MicronodeAssert;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.data.node.field.list.HibBooleanFieldList;
import com.gentics.mesh.core.data.node.field.list.HibDateFieldList;
import com.gentics.mesh.core.data.node.field.list.HibHtmlFieldList;
import com.gentics.mesh.core.data.node.field.list.HibNodeFieldList;
import com.gentics.mesh.core.data.node.field.list.HibNumberFieldList;
import com.gentics.mesh.core.data.node.field.list.HibStringFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.schema.HibFieldSchemaElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.micronode.MicronodeFieldHelper;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicronodeFieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.MeshJsonException;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.DateUtils;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Calendar;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class MicronodeFieldTest
extends AbstractFieldTest<MicronodeFieldSchema> {
    private static final String MICRONODE_FIELD = "micronodeField";
    protected HibMicroschema dummyMicroschema;

    @Override
    protected MicronodeFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(MICRONODE_FIELD, isRequired);
    }

    protected MicronodeFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        MicronodeFieldSchemaImpl schema = new MicronodeFieldSchemaImpl();
        schema.setLabel("Some microschema label");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        schema.setAllowedMicroSchemas(new String[]{"vcard"});
        return schema;
    }

    protected HibMicroschema createDummyMicroschema() throws MeshJsonException {
        MicroschemaModelImpl dummyMicroschema = new MicroschemaModelImpl();
        dummyMicroschema.setName("dummymicroschema");
        StringFieldSchemaImpl stringFieldSchema = new StringFieldSchemaImpl();
        stringFieldSchema.setName("stringfield");
        stringFieldSchema.setLabel("String Field");
        dummyMicroschema.addField((FieldSchema)stringFieldSchema);
        return this.createMicroschema((MicroschemaVersionModel)dummyMicroschema);
    }

    @Before
    public void addDummySchema() throws Exception {
        try (Tx tx = this.tx();){
            this.dummyMicroschema = this.createDummyMicroschema();
            tx.success();
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode newOverview;
        HibNode node;
        Calendar date = Calendar.getInstance();
        date.set(2016, 1, 6, 3, 44);
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            newOverview = this.content("news overview");
            ContentDao contentDao = tx.contentDao();
            MicroschemaDao microschemaDao = tx.microschemaDao();
            MicroschemaModelImpl fullMicroschema = new MicroschemaModelImpl();
            fullMicroschema.setName("full");
            fullMicroschema.addField((FieldSchema)new BooleanFieldSchemaImpl().setName("booleanfield").setLabel("Boolean Field"));
            fullMicroschema.addField((FieldSchema)new DateFieldSchemaImpl().setName("datefield").setLabel("Date Field"));
            fullMicroschema.addField((FieldSchema)new HtmlFieldSchemaImpl().setName("htmlfield").setLabel("HTML Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("boolean").setName("listfield-boolean").setLabel("Boolean List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("date").setName("listfield-date").setLabel("Date List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("html").setName("listfield-html").setLabel("Html List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("node").setName("listfield-node").setLabel("Node List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("number").setName("listfield-number").setLabel("Number List Field"));
            fullMicroschema.addField(new ListFieldSchemaImpl().setListType("string").setName("listfield-string").setLabel("String List Field"));
            fullMicroschema.addField((FieldSchema)new NodeFieldSchemaImpl().setName("nodefield").setLabel("Node Field"));
            fullMicroschema.addField((FieldSchema)new NumberFieldSchemaImpl().setName("numberfield").setLabel("Number Field"));
            fullMicroschema.addField((FieldSchema)new StringFieldSchemaImpl().setName("stringfield").setLabel("String Field"));
            HibMicroschema microschema = microschemaDao.create((MicroschemaVersionModel)fullMicroschema, this.getRequestUser(), this.createBatch());
            this.prepareTypedSchema(node, (FieldSchema)new MicronodeFieldSchemaImpl().setName("micronodefield").setLabel("Micronode Field"), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibMicronodeField micronodeField = container.createMicronode("micronodefield", microschema.getLatestVersion());
            HibMicronode micronode = micronodeField.getMicronode();
            Assert.assertNotNull((String)"Micronode must not be null", (Object)micronode);
            micronode.createBoolean("booleanfield").setBoolean(Boolean.valueOf(true));
            micronode.createDate("datefield").setDate(Long.valueOf(date.getTimeInMillis()));
            micronode.createHTML("htmlfield").setHtml("<b>HTML</b> value");
            HibBooleanFieldList booleanList = micronode.createBooleanList("listfield-boolean");
            booleanList.createBoolean(Boolean.valueOf(true));
            booleanList.createBoolean(Boolean.valueOf(false));
            HibDateFieldList dateList = micronode.createDateList("listfield-date");
            dateList.createDate(Long.valueOf(date.getTimeInMillis()));
            dateList.createDate(Long.valueOf(0L));
            HibHtmlFieldList htmlList = micronode.createHTMLList("listfield-html");
            htmlList.createHTML("<b>first</b>");
            htmlList.createHTML("<i>second</i>");
            HibNodeFieldList nodeList = micronode.createNodeList("listfield-node");
            nodeList.createNode(0, node);
            nodeList.createNode(1, newOverview);
            HibNumberFieldList numberList = micronode.createNumberList("listfield-number");
            numberList.createNumber((Number)47);
            numberList.createNumber((Number)11);
            HibStringFieldList stringList = micronode.createStringList("listfield-string");
            stringList.createString("first");
            stringList.createString("second");
            stringList.createString("third");
            micronode.createNode("nodefield", newOverview);
            micronode.createNumber("numberfield").setNumber((Number)4711);
            micronode.createString("stringfield").setString("String Value");
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            newOverview = this.content("news overview");
            String json = this.getJson(node);
            System.out.println(json);
            JsonObject jsonObject = new JsonObject(json);
            JsonObject fields = jsonObject.getJsonObject("fields");
            Assert.assertNotNull((String)"JSON Object must contain fields", (Object)fields);
            JsonObject micronodeFieldObject = fields.getJsonObject("micronodefield");
            Assert.assertNotNull((String)"JSON Object must contain micronode field", (Object)micronodeFieldObject);
            JsonObject micronodeFields = micronodeFieldObject.getJsonObject("fields");
            Assert.assertNotNull((String)"Micronode must contain fields", (Object)micronodeFields);
            Assert.assertEquals((String)"Boolean Field", (Object)Boolean.TRUE, (Object)micronodeFields.getBoolean("booleanfield"));
            Assert.assertEquals((String)"Date Field", (Object)DateUtils.toISO8601((long)date.getTimeInMillis()), (Object)micronodeFields.getString("datefield"));
            Assert.assertEquals((String)"HTML Field", (Object)"<b>HTML</b> value", (Object)micronodeFields.getString("htmlfield"));
            ((JsonArrayAssert)MeshAssertions.assertThat((JsonArray)micronodeFields.getJsonArray("listfield-boolean")).as("Boolean List Field", new Object[0])).matches((Object[])new Boolean[]{true, false});
            ((JsonArrayAssert)MeshAssertions.assertThat((JsonArray)micronodeFields.getJsonArray("listfield-date")).as("Date List Field", new Object[0])).matches((Object[])new String[]{DateUtils.toISO8601((long)date.getTimeInMillis()), DateUtils.toISO8601((long)0L)});
            ((JsonArrayAssert)MeshAssertions.assertThat((JsonArray)micronodeFields.getJsonArray("listfield-html")).as("HTML List Field", new Object[0])).matches((Object[])new String[]{"<b>first</b>", "<i>second</i>"});
            ((JsonArrayAssert)MeshAssertions.assertThat((JsonArray)micronodeFields.getJsonArray("listfield-node")).as("Node List Field", new Object[0])).key("uuid").matches((Object[])new String[]{node.getUuid(), newOverview.getUuid()});
            MeshAssertions.assertThat(micronodeFields.getJsonArray("listfield-number").stream().map(Number.class::cast).map(Number::longValue).collect(Collectors.toList())).as("Number List Field", new Object[0]).containsExactly((Object[])new Long[]{47L, 11L});
            ((JsonArrayAssert)MeshAssertions.assertThat((JsonArray)micronodeFields.getJsonArray("listfield-string")).as("String List Field", new Object[0])).matches((Object[])new String[]{"first", "second", "third"});
            ((JsonObjectAssert)MeshAssertions.assertThat((JsonObject)micronodeFields.getJsonObject("nodefield")).as("Node Field", new Object[0])).key("uuid").matches((Object)newOverview.getUuid());
            Assert.assertEquals((String)"Number Field", (long)4711L, (long)micronodeFields.getInteger("numberfield").intValue());
            Assert.assertEquals((String)"String Field", (Object)"String Value", (Object)micronodeFields.getString("stringfield"));
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Test
    public void testCreateMicronodeField() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeField field = container.createMicronode(MICRONODE_FIELD, this.dummyMicroschema.getLatestVersion());
            Assert.assertNotNull((Object)field);
            HibMicronode micronode = field.getMicronode();
            Assert.assertNotNull((Object)micronode);
            Assert.assertTrue((String)"Micronode must have a uuid", (boolean)StringUtils.isNotEmpty((CharSequence)micronode.getUuid()));
            HibStringField micronodeStringField = micronode.createString("stringfield");
            Assert.assertNotNull((Object)micronodeStringField);
            micronodeStringField.setString("dummyString");
            HibMicronodeField reloadedField = container.getMicronode(MICRONODE_FIELD);
            Assert.assertNotNull((Object)reloadedField);
            HibMicronode reloadedMicronode = reloadedField.getMicronode();
            Assert.assertNotNull((Object)reloadedMicronode);
            Assert.assertEquals((Object)micronode.getUuid(), (Object)reloadedMicronode.getUuid());
            HibStringField reloadedMicronodeStringField = reloadedMicronode.getString("stringfield");
            Assert.assertNotNull((Object)reloadedMicronodeStringField);
            Assert.assertEquals((Object)micronodeStringField.getString(), (Object)reloadedMicronodeStringField.getString());
        }
    }

    @Test
    public void testMicronodeUpdateFromRest() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeField field = container.createMicronode(MICRONODE_FIELD, this.dummyMicroschema.getLatestVersion());
            HibMicronode micronode = field.getMicronode();
            MicroschemaVersionModel schema = micronode.getSchemaContainerVersion().getSchema();
            schema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"stringfield"));
            micronode.getSchemaContainerVersion().setSchema(schema);
            InternalActionContext ac = this.mockActionContext();
            this.mesh().serverSchemaStorage().clear();
            FieldMapImpl restFields = new FieldMapImpl();
            restFields.put("stringfield", (Field)new StringFieldImpl().setString("test"));
            field.getMicronode().updateFieldsFromRest(ac, (FieldMap)restFields);
            Assert.assertNotNull((String)"The field should have been created.", (Object)field.getMicronode().getString("stringfield"));
            Assert.assertEquals((String)"The field did not contain the expected value", (Object)"test", (Object)field.getMicronode().getString("stringfield").getString());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeField field = container.createMicronode(MICRONODE_FIELD, this.dummyMicroschema.getLatestVersion());
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            field.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)MeshAssertions.assertThat((Object)otherContainer.getMicronode(MICRONODE_FIELD)).as("cloned field", new Object[0])).isNotNull();
            ((MicronodeAssert)((MicronodeAssert)MeshAssertions.assertThat((HibMicronode)otherContainer.getMicronode(MICRONODE_FIELD).getMicronode()).as("cloned micronode", new Object[0])).isNotNull()).isEqualToComparingFieldByField((Object)field.getMicronode());
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeField field = container.createMicronode(MICRONODE_FIELD, this.dummyMicroschema.getLatestVersion());
            HibMicronode micronode = field.getMicronode();
            String originalUuid = micronode.getUuid();
            Stream existingMicronodes = ctx.contentDao().findAllMicronodes();
            existingMicronodes.forEach(foundMicronode -> Assert.assertEquals((Object)micronode.getUuid(), (Object)foundMicronode.getUuid()));
            HibMicronodeField updatedField = container.createMicronode(MICRONODE_FIELD, this.dummyMicroschema.getLatestVersion());
            HibMicronode updatedMicronode = updatedField.getMicronode();
            Assert.assertFalse((String)"Uuid of micronode must be different after update", (boolean)StringUtils.equalsIgnoreCase((CharSequence)originalUuid, (CharSequence)updatedMicronode.getUuid()));
            existingMicronodes = ctx.contentDao().findAllMicronodes();
            existingMicronodes.forEach(foundMicronode -> Assert.assertEquals((Object)updatedMicronode.getUuid(), (Object)foundMicronode.getUuid()));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibMicronodeField fieldA = container.createMicronode("fieldA", this.microschemaContainer("vcard").getLatestVersion());
            HibMicronodeField fieldB = container.createMicronode("fieldB", this.microschemaContainer("vcard").getLatestVersion());
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.getMicronode().createString("firstName").setString("someStringValue");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.getMicronode().createString("firstName").setString("someStringValue");
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeField fieldA = container.createMicronode(MICRONODE_FIELD, this.microschemaContainer("vcard").getLatestVersion());
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            MicroschemaModelImpl microschema = new MicroschemaModelImpl();
            microschema.setVersion("1.0");
            microschema.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"string"));
            microschema.addField((FieldSchema)FieldUtil.createDateFieldSchema((String)"date"));
            HibMicroschemaVersion containerVersion = (HibMicroschemaVersion)ctx.microschemaDao().createPersistedVersion((HibFieldSchemaElement)this.dummyMicroschema, arg_0 -> MicronodeFieldTest.lambda$testEqualsRestField$2((MicroschemaVersionModel)microschema, arg_0));
            tx.commit();
            HibMicronodeField fieldA = container.createMicronode(MICRONODE_FIELD, containerVersion);
            MicronodeResponse restField = new MicronodeResponse();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            Long date = DateUtils.fromISO8601((String)DateUtils.toISO8601((long)System.currentTimeMillis()));
            fieldA.getMicronode().createString("string").setString("someString");
            fieldA.getMicronode().createDate("date").setDate(date);
            restField.getFields().put("string", (Field)FieldUtil.createStringField((String)"someOtherString"));
            restField.getFields().put("date", (Field)FieldUtil.createDateField((String)DateUtils.toISO8601((long)date)));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getFields().getStringField("string").setString("someString");
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            restField.getFields().put("string", (Field)FieldUtil.createHtmlField((String)"someString"));
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(restField));
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(new StringFieldImpl().setString("blub")));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(MICRONODE_FIELD, MicronodeFieldHelper.FETCH, MicronodeFieldHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(MICRONODE_FIELD, MicronodeFieldHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(MICRONODE_FIELD, MicronodeFieldHelper.FETCH, MicronodeFieldHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, MICRONODE_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(MICRONODE_FIELD, MicronodeFieldHelper.FETCH, MicronodeFieldHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, MICRONODE_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(MICRONODE_FIELD, MicronodeFieldHelper.FILL, container -> {
                MicronodeResponse field = new MicronodeResponse();
                field.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
                field.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"vcard_firstname_value"));
                field.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"vcard_lastname_value"));
                this.updateContainer(ac, (HibNodeFieldContainer)container, MICRONODE_FIELD, (Field)field);
            }, container -> {
                HibMicronodeField field = container.getMicronode(MICRONODE_FIELD);
                Assert.assertNotNull((String)"The graph field {micronodeField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The micronode of the field was not updated.", (Object)"vcard_firstname_value", (Object)field.getMicronode().getString("firstName").getString());
                Assert.assertEquals((String)"The micronode of the field was not updated.", (Object)"vcard_lastname_value", (Object)field.getMicronode().getString("lastName").getString());
            });
        }
    }

    private static /* synthetic */ void lambda$testEqualsRestField$2(MicroschemaVersionModel microschema, HibMicroschemaVersion v) {
        v.setSchema(microschema);
    }
}

