/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.micronode;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaUpdateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.FieldList;
import com.gentics.mesh.core.rest.node.field.list.MicronodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.AbstractFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.result.TraversalResult;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class MicronodeListFieldEndpointTest
extends AbstractListFieldEndpointTest {
    protected static final String FIELD_NAME = "micronodeListField";

    @Override
    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            ListFieldSchemaImpl listFieldSchema = new ListFieldSchemaImpl();
            listFieldSchema.setName(FIELD_NAME);
            listFieldSchema.setLabel("Some label");
            listFieldSchema.setListType("micronode");
            listFieldSchema.setAllowedSchemas(new String[]{"vcard"});
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(listFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    public String getListFieldType() {
        return "micronode";
    }

    @Override
    @Test
    @Ignore(value="Not yet implemented")
    public void testReadNodeWithExistingField() throws IOException {
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        MicronodeFieldListImpl listField = new MicronodeFieldListImpl();
        listField.add((Object)this.createItem("Max", "B\u00f6se"));
        listField.add(null);
        this.createNodeAndExpectFailure(FIELD_NAME, (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", FIELD_NAME);
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        MicronodeFieldListImpl listField = new MicronodeFieldListImpl();
        listField.add((Object)this.createItem("Max", "B\u00f6se"));
        listField.add(null);
        this.updateNodeFailure(FIELD_NAME, (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", FIELD_NAME);
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
        for (int i = 0; i < 20; ++i) {
            Tx tx2;
            boolean bothEmpty;
            MicronodeFieldList updatedField;
            HibNodeFieldContainer currentContainer = container;
            List oldValue = (List)this.tx(() -> this.getListValues(arg_0 -> ((HibNodeFieldContainer)currentContainer).getMicronodeList(arg_0), FIELD_NAME));
            MicronodeFieldListImpl newValue = new MicronodeFieldListImpl();
            NodeResponse response = null;
            if (oldValue == null) {
                newValue.getItems().clear();
                newValue.add((Object)this.createItem("Max", "B\u00f6se"));
                newValue.add((Object)this.createItem("Moritz", "B\u00f6se"));
                response = this.updateNode(FIELD_NAME, (Field)newValue);
                MicronodeFieldList responseField = response.getFields().getMicronodeFieldList(FIELD_NAME);
                ArrayList<String> uuids = new ArrayList<String>();
                for (MicronodeField item : responseField.getItems()) {
                    uuids.add(item.getUuid());
                }
            } else if (i % 3 == 1) {
                NodeResponse readResponse = this.readNode(node, new String[0]);
                newValue = readResponse.getFields().getMicronodeFieldList(FIELD_NAME);
                Collections.reverse(newValue.getItems());
                response = this.updateNode(FIELD_NAME, (Field)newValue);
                updatedField = response.getFields().getMicronodeFieldList(FIELD_NAME);
                this.assertFieldEquals((FieldList<MicronodeField>)newValue, (FieldList<MicronodeField>)updatedField, false);
            } else if (i % 3 == 2) {
                NodeResponse readResponse = this.readNode(node, new String[0]);
                newValue = readResponse.getFields().getMicronodeFieldList(FIELD_NAME);
                for (MicronodeField field : newValue.getItems()) {
                    StringFieldImpl firstNameField = field.getFields().getStringField("firstName");
                    firstNameField.setString("Strammer " + firstNameField.getString());
                    field.getFields().put("firstName", (Field)firstNameField);
                }
                response = this.updateNode(FIELD_NAME, (Field)newValue);
                updatedField = response.getFields().getMicronodeFieldList(FIELD_NAME);
                this.assertFieldEquals((FieldList<MicronodeField>)newValue, (FieldList<MicronodeField>)updatedField, false);
            } else {
                response = this.updateNode(FIELD_NAME, (Field)new MicronodeFieldListImpl());
                MeshAssertions.assertThat((List)response.getFields().getMicronodeFieldList(FIELD_NAME).getItems()).isEmpty();
            }
            boolean bl = bothEmpty = oldValue != null && newValue.getItems().isEmpty() && oldValue.isEmpty();
            if (!bothEmpty) {
                tx2 = this.tx();
                try {
                    ContentDao contentDao = tx2.contentDao();
                    HibNodeFieldContainer newContainer = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                    Assert.assertNotNull((String)("No new container version was created. {" + i % 3 + "}"), (Object)newContainer);
                    Assert.assertEquals((String)"Check version number", (Object)newContainer.getVersion().toString(), (Object)response.getVersion());
                    Assert.assertEquals((String)("Check old value for run {" + i % 3 + "}"), (Object)oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getMicronodeList(arg_0), FIELD_NAME));
                    container = newContainer;
                    continue;
                }
                finally {
                    if (tx2 != null) {
                        tx2.close();
                    }
                }
            }
            tx2 = this.tx();
            try {
                Assert.assertEquals((String)("Check old value for run {" + i % 3 + "}"), (Object)oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getMicronodeList(arg_0), FIELD_NAME));
                Assert.assertEquals((String)"The version should not have been updated.", (Object)container.getVersion().toString(), (Object)response.getVersion());
                continue;
            }
            finally {
                if (tx2 != null) {
                    tx2.close();
                }
            }
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("Max", "B\u00f6se"));
        field.add((Object)this.createItem("Moritz", "B\u00f6se"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)field);
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("Max", "B\u00f6se"));
        field.add((Object)this.createItem("Moritz", "B\u00f6se"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getMicronodeFieldList(FIELD_NAME)).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            MeshAssertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            MeshAssertions.assertThat((Object)latest.getMicronodeList(FIELD_NAME)).isNull();
            MeshAssertions.assertThat((Object)latest.getPreviousVersion().getMicronodeList(FIELD_NAME)).isNotNull();
            List oldValueList = latest.getPreviousVersion().getMicronodeList(FIELD_NAME).getList().stream().map(item -> item.getMicronode().getString("firstName").getString()).collect(Collectors.toList());
            MeshAssertions.assertThat(oldValueList).containsExactly((Object[])new String[]{"Max", "Moritz"});
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("Max", "B\u00f6se"));
        field.add((Object)this.createItem("Moritz", "B\u00f6se"));
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)field);
        String oldVersion = firstResponse.getVersion();
        MicronodeFieldListImpl emptyField = new MicronodeFieldListImpl();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getMicronodeFieldList(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        MeshAssertions.assertThat((List)secondResponse.getFields().getMicronodeFieldList(FIELD_NAME).getItems()).as("Updated Field Value", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Test
    public void testReorder() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("One", "One"));
        field.add((Object)this.createItem("Two", "Two"));
        field.add((Object)this.createItem("Three", "Three"));
        NodeResponse initialResponse = this.updateNode(FIELD_NAME, (Field)field);
        MicronodeFieldList initialField = initialResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        MicronodeFieldListImpl reorderedField = new MicronodeFieldListImpl();
        initialField.getItems().stream().forEachOrdered(arg_0 -> MicronodeListFieldEndpointTest.lambda$testReorder$3((FieldList)reorderedField, arg_0));
        Collections.sort(reorderedField.getItems(), new Comparator<MicronodeField>(){

            @Override
            public int compare(MicronodeField o1, MicronodeField o2) {
                return o1.getFields().getStringField("firstName").getString().compareTo(o2.getFields().getStringField("firstName").getString());
            }
        });
        NodeResponse updateResponse = this.updateNode(FIELD_NAME, (Field)reorderedField);
        MicronodeFieldList updatedField = updateResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        this.assertFieldEquals((FieldList<MicronodeField>)reorderedField, (FieldList<MicronodeField>)updatedField, false);
        this.assertMicronodes((FieldList<MicronodeField>)updatedField);
    }

    @Test
    public void testAddMicronode() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("One", "One"));
        field.add((Object)this.createItem("Two", "Two"));
        field.add((Object)this.createItem("Three", "Three"));
        NodeResponse initialResponse = this.updateNode(FIELD_NAME, (Field)field);
        MicronodeFieldList initialField = initialResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        MicronodeFieldListImpl changedField = new MicronodeFieldListImpl();
        initialField.getItems().stream().forEachOrdered(arg_0 -> MicronodeListFieldEndpointTest.lambda$testAddMicronode$4((FieldList)changedField, arg_0));
        changedField.getItems().add(1, this.createItem("Four", "Four"));
        NodeResponse updateResponse = this.updateNode(FIELD_NAME, (Field)changedField);
        MicronodeFieldList updatedField = updateResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        this.assertFieldEquals((FieldList<MicronodeField>)changedField, (FieldList<MicronodeField>)updatedField, false);
        this.assertMicronodes((FieldList<MicronodeField>)updatedField);
    }

    @Test
    public void testRemoveMicronode() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("One", "One"));
        field.add((Object)this.createItem("Two", "Two"));
        field.add((Object)this.createItem("Three", "Three"));
        NodeResponse initialResponse = this.updateNode(FIELD_NAME, (Field)field);
        MicronodeFieldList initialField = initialResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        MicronodeFieldListImpl changedField = new MicronodeFieldListImpl();
        initialField.getItems().stream().forEachOrdered(arg_0 -> MicronodeListFieldEndpointTest.lambda$testRemoveMicronode$5((FieldList)changedField, arg_0));
        changedField.getItems().remove(1);
        NodeResponse updateResponse = this.updateNode(FIELD_NAME, (Field)changedField);
        MicronodeFieldList updatedField = updateResponse.getFields().getMicronodeFieldList(FIELD_NAME);
        this.assertFieldEquals((FieldList<MicronodeField>)changedField, (FieldList<MicronodeField>)updatedField, false);
        this.assertMicronodes((FieldList<MicronodeField>)updatedField);
    }

    @Test
    @Ignore
    public void testMultipleChanges() {
        try (Tx tx = this.tx();){
            MicronodeFieldListImpl field = new MicronodeFieldListImpl();
            field.add((Object)this.createItem("One", "One"));
            field.add((Object)this.createItem("Two", "Two"));
            field.add((Object)this.createItem("Three", "Three"));
            NodeResponse initialResponse = this.updateNode(FIELD_NAME, (Field)field);
            MicronodeFieldList initialField = initialResponse.getFields().getMicronodeFieldList(FIELD_NAME);
            MicronodeFieldListImpl changedField = new MicronodeFieldListImpl();
            initialField.getItems().stream().forEachOrdered(arg_0 -> MicronodeListFieldEndpointTest.lambda$testMultipleChanges$6((FieldList)changedField, arg_0));
            changedField.getItems().add(this.createItem("Four", "Four"));
            changedField.getItems().remove(1);
            Collections.sort(changedField.getItems(), new Comparator<MicronodeField>(){

                @Override
                public int compare(MicronodeField o1, MicronodeField o2) {
                    return o1.getFields().getStringField("firstName").getString().compareTo(o2.getFields().getStringField("firstName").getString());
                }
            });
            NodeResponse updateResponse = this.updateNode(FIELD_NAME, (Field)changedField);
            MicronodeFieldList updatedField = updateResponse.getFields().getMicronodeFieldList(FIELD_NAME);
            this.assertFieldEquals((FieldList<MicronodeField>)changedField, (FieldList<MicronodeField>)updatedField, true);
            this.assertMicronodes((FieldList<MicronodeField>)updatedField);
        }
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("Max", "B\u00f6se"));
        field.add((Object)this.createItem("Moritz", "B\u00f6se"));
        MeshAssertions.assertThat((List)field.getItems()).hasSize(2);
        NodeResponse response = this.createNode(FIELD_NAME, (Field)field);
        MicronodeFieldList responseField = response.getFields().getMicronodeFieldList(FIELD_NAME);
        Assert.assertNotNull((Object)responseField);
        this.assertFieldEquals((FieldList<MicronodeField>)field, (FieldList<MicronodeField>)responseField, true);
        this.assertMicronodes((FieldList<MicronodeField>)responseField);
    }

    @Test
    public void testReferenceUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        AbstractFieldSchema innerField = new NodeFieldSchemaImpl().setName("node");
        String vcardUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        MicroschemaVersionModel vcard = (MicroschemaVersionModel)this.tx(() -> this.microschemaContainers().get("vcard").getLatestVersion().getSchema());
        vcard.addField((FieldSchema)innerField);
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)vcard.toJson(), MicroschemaUpdateRequest.class);
        ClientHelper.call(() -> this.client().updateMicroschema(vcardUuid, request, new ParameterProvider[0]));
        this.tx(tx -> {
            this.prepareTypedMicroschema(this.microschemaContainers().get("vcard"), List.of(innerField));
            tx.success();
        });
        MicronodeResponse fieldItem = new MicronodeResponse();
        fieldItem.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        fieldItem.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        fieldItem.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        fieldItem.getFields().put("node", (Field)new NodeFieldImpl().setUuid(targetUuid));
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)fieldItem);
        field.add((Object)fieldItem);
        field.add((Object)fieldItem);
        this.updateNode(FIELD_NAME, (Field)field);
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Test
    public void testReferenceListUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        FieldSchema innerListField = new ListFieldSchemaImpl().setListType("node").setName("node");
        String vcardUuid = (String)this.tx(() -> this.microschemaContainers().get("vcard").getUuid());
        MicroschemaVersionModel vcard = (MicroschemaVersionModel)this.tx(() -> this.microschemaContainers().get("vcard").getLatestVersion().getSchema());
        vcard.addField(innerListField);
        MicroschemaUpdateRequest request = (MicroschemaUpdateRequest)JsonUtil.readValue((String)vcard.toJson(), MicroschemaUpdateRequest.class);
        ClientHelper.call(() -> this.client().updateMicroschema(vcardUuid, request, new ParameterProvider[0]));
        this.tx(tx -> {
            this.prepareTypedMicroschema(this.microschemaContainers().get("vcard"), List.of(innerListField));
            tx.success();
        });
        MicronodeResponse fieldItem = new MicronodeResponse();
        fieldItem.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        fieldItem.getFields().put("firstName", (Field)new StringFieldImpl().setString("Max"));
        fieldItem.getFields().put("lastName", (Field)new StringFieldImpl().setString("Moritz"));
        NodeFieldListImpl nodeList = new NodeFieldListImpl();
        nodeList.add((Object)new NodeFieldListItemImpl().setUuid(targetUuid));
        fieldItem.getFields().put("node", (Field)nodeList);
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)fieldItem);
        this.updateNode(FIELD_NAME, (Field)field);
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(FIELD_NAME, null);
        MicronodeFieldList field = response.getFields().getMicronodeFieldList(FIELD_NAME);
        Assert.assertNull((Object)field);
    }

    @Test
    public void testListOrder() {
        int nodeCount = 50;
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        Object[] expected = new String[nodeCount];
        for (int i = 0; i < nodeCount; ++i) {
            String name = "name" + i;
            field.add((Object)this.createItem(name, name));
            expected[i] = name;
        }
        NodeResponse node = this.updateNode(FIELD_NAME, (Field)field);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[0]));
        Stream<String> actual = response.getFields().getMicronodeFieldList(FIELD_NAME).getItems().stream().map(it -> it.getFields().getStringField("firstName").getString());
        MeshAssertions.assertThat(actual).containsExactly(expected);
    }

    protected void assertFieldEquals(FieldList<MicronodeField> expected, FieldList<MicronodeField> field, boolean assertUuid) {
        Assert.assertEquals((String)"Check # of micronode items", (long)expected.getItems().size(), (long)field.getItems().size());
        for (int i = 0; i < expected.getItems().size(); ++i) {
            MicronodeField expectedMicronode = (MicronodeField)expected.getItems().get(i);
            MicronodeField micronode = (MicronodeField)field.getItems().get(i);
            for (String fieldName : Arrays.asList("firstName", "lastName")) {
                Assert.assertEquals((String)("Check " + fieldName + " of item # " + (i + 1)), (Object)expectedMicronode.getFields().getStringField(fieldName).getString(), (Object)micronode.getFields().getStringField(fieldName).getString());
            }
        }
    }

    protected void assertMicronodes(FieldList<MicronodeField> field) {
        try (Tx tx = this.tx();){
            CommonTx ctx = (CommonTx)tx.unwrap();
            TraversalResult s = new TraversalResult(ctx.contentDao().findAllMicronodes());
            Set unboundMicronodes = s.stream().filter(micronode -> micronode.getContainer() == null).collect(Collectors.toSet());
            MeshAssertions.assertThat(unboundMicronodes).as("Unbound micronodes", new Object[0]).isEmpty();
        }
    }

    protected MicronodeResponse createItem(String firstName, String lastName) {
        MicronodeResponse item = new MicronodeResponse();
        item.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
        item.getFields().put("firstName", (Field)new StringFieldImpl().setString(firstName));
        item.getFields().put("lastName", (Field)new StringFieldImpl().setString(lastName));
        return item;
    }

    @Override
    public NodeResponse createNodeWithField() {
        MicronodeFieldListImpl field = new MicronodeFieldListImpl();
        field.add((Object)this.createItem("Max", "B\u00f6se"));
        field.add((Object)this.createItem("Moritz", "B\u00f6se"));
        MeshAssertions.assertThat((List)field.getItems()).hasSize(2);
        return this.createNode(FIELD_NAME, (Field)field);
    }

    private static /* synthetic */ void lambda$testMultipleChanges$6(FieldList changedField, MicronodeField item) {
        changedField.add((Object)item);
    }

    private static /* synthetic */ void lambda$testRemoveMicronode$5(FieldList changedField, MicronodeField item) {
        changedField.add((Object)item);
    }

    private static /* synthetic */ void lambda$testAddMicronode$4(FieldList changedField, MicronodeField item) {
        changedField.add((Object)item);
    }

    private static /* synthetic */ void lambda$testReorder$3(FieldList reorderedField, MicronodeField item) {
        reorderedField.add((Object)item);
    }
}

