/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.micronode;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibMicronodeFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.micronode.MicronodeListFieldHelper;
import com.gentics.mesh.core.rest.micronode.MicronodeResponse;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.MicronodeField;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.MicronodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.MicronodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicroschemaReferenceImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class MicronodeListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String MICRONODE_LIST = "micronodeList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(MICRONODE_LIST, isRequired);
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("micronode");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareNode(node, MICRONODE_LIST, "micronode");
            InternalActionContext ac = this.mockActionContext("");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            MicronodeFieldListImpl field = new MicronodeFieldListImpl();
            MicronodeResponse micronodeA = new MicronodeResponse();
            micronodeA.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            micronodeA.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"updatedFirstname1"));
            micronodeA.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"updatedLastname1"));
            field.getItems().add(micronodeA);
            MicronodeResponse micronodeB = new MicronodeResponse();
            micronodeB.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
            micronodeB.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"updatedFirstname2"));
            micronodeB.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"updatedLastname2"));
            field.getItems().add(micronodeB);
            this.updateContainer(ac, container, MICRONODE_LIST, (Field)field);
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, MICRONODE_LIST, "micronode", response);
            MicronodeFieldList micronodeRestList = response.getFields().getMicronodeFieldList(MICRONODE_LIST);
            StringFieldImpl firstnameAField = ((MicronodeField)micronodeRestList.getItems().get(0)).getFields().getStringField("firstName");
            Assert.assertNotNull((String)"The firstname string field for the first micronode could not be found. It should not be null.", (Object)firstnameAField);
            Assert.assertEquals((Object)"updatedFirstname1", (Object)firstnameAField.getString());
            StringFieldImpl lastnameAField = ((MicronodeField)micronodeRestList.getItems().get(0)).getFields().getStringField("lastName");
            Assert.assertNotNull((String)"The lastname string field for the first micronode could not be found. It should not be null.", (Object)lastnameAField);
            Assert.assertEquals((Object)"updatedLastname1", (Object)lastnameAField.getString());
            StringFieldImpl firstnameBField = ((MicronodeField)micronodeRestList.getItems().get(1)).getFields().getStringField("firstName");
            Assert.assertNotNull((String)"The string field for the second micronode could not be found. It should not be null.", (Object)firstnameBField);
            Assert.assertEquals((Object)"updatedFirstname2", (Object)firstnameBField.getString());
            StringFieldImpl lastnameBField = ((MicronodeField)micronodeRestList.getItems().get(1)).getFields().getStringField("lastName");
            Assert.assertNotNull((String)"The string field for the second micronode could not be found. It should not be null.", (Object)lastnameBField);
            Assert.assertEquals((Object)"updatedLastname2", (Object)lastnameBField.getString());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeFieldList list = container.createMicronodeList(MICRONODE_LIST);
            Assert.assertNotNull((Object)list);
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeFieldList testField = container.createMicronodeList(MICRONODE_LIST);
            HibMicronode micronode = testField.createMicronode(this.microschemaContainers().get("vcard").getLatestVersion());
            micronode.createString("firstName").setString("Donald");
            micronode.createString("lastName").setString("Duck");
            micronode = testField.createMicronode(this.microschemaContainers().get("vcard").getLatestVersion());
            micronode.createString("firstName").setString("Mickey");
            micronode.createString("lastName").setString("Mouse");
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assert.assertTrue((boolean)otherContainer.getMicronodeList(MICRONODE_LIST).equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibMicronodeFieldList fieldA = container.createMicronodeList("fieldA");
            HibMicronodeFieldList fieldB = container.createMicronodeList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            HibMicronode micronodeA = fieldA.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
            micronodeA.createString("firstName").setString("Donald");
            micronodeA.createString("lastName").setString("Duck");
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            HibMicronode micronodeB = fieldB.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
            micronodeB.createString("firstName").setString("Donald");
            micronodeB.createString("lastName").setString("Duck");
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
            HibMicronode micronodeC = fieldB.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
            micronodeC.createString("firstName").setString("Donald");
            micronodeC.createString("lastName").setString("Duck");
            Assert.assertFalse((String)"Field b contains more items compared to field a and thus both lists are not equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeFieldList fieldA = container.createMicronodeList(MICRONODE_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibMicronodeFieldList fieldA = container.createMicronodeList(MICRONODE_LIST);
            MicronodeFieldListImpl restField = new MicronodeFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            HibMicronode micronodeA = fieldA.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
            micronodeA.createString("firstName").setString("Donald");
            MicronodeResponse dummyValue2 = new MicronodeResponse();
            dummyValue2.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"Dagobert"));
            restField.add((Object)dummyValue2);
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            MicronodeResponse dummyValue = new MicronodeResponse();
            dummyValue.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"Donald"));
            restField.add((Object)dummyValue);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            StringFieldListImpl otherTypeRestField = new StringFieldListImpl();
            otherTypeRestField.add((Object)"test");
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(MICRONODE_LIST, MicronodeListFieldHelper.FETCH, MicronodeListFieldHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(MICRONODE_LIST, MicronodeListFieldHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(MICRONODE_LIST, MicronodeListFieldHelper.FETCH, MicronodeListFieldHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, MICRONODE_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(MICRONODE_LIST, MicronodeListFieldHelper.FETCH, MicronodeListFieldHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, MICRONODE_LIST, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(MICRONODE_LIST, MicronodeListFieldHelper.FILL, container -> {
                MicronodeFieldListImpl field = new MicronodeFieldListImpl();
                MicronodeResponse micronodeA = new MicronodeResponse();
                micronodeA.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
                micronodeA.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"updatedFirstname1"));
                micronodeA.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"updatedLastname1"));
                field.getItems().add(micronodeA);
                MicronodeResponse micronodeB = new MicronodeResponse();
                micronodeB.setMicroschema((MicroschemaReference)new MicroschemaReferenceImpl().setName("vcard"));
                micronodeB.getFields().put("firstName", (Field)FieldUtil.createStringField((String)"updatedFirstname2"));
                micronodeB.getFields().put("lastName", (Field)FieldUtil.createStringField((String)"updatedLastname2"));
                field.getItems().add(micronodeB);
                this.updateContainer(ac, (HibNodeFieldContainer)container, MICRONODE_LIST, (Field)field);
            }, container -> {
                HibMicronodeFieldList field = container.getMicronodeList(MICRONODE_LIST);
                Assert.assertNotNull((String)"The graph field {micronodeList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"updatedLastname1", (Object)((HibMicronodeField)field.getList().get(0)).getMicronode().getString("lastName").getString());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"updatedFirstname1", (Object)((HibMicronodeField)field.getList().get(0)).getMicronode().getString("firstName").getString());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"updatedLastname2", (Object)((HibMicronodeField)field.getList().get(1)).getMicronode().getString("lastName").getString());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"updatedFirstname2", (Object)((HibMicronodeField)field.getList().get(1)).getMicronode().getString("firstName").getString());
                field.removeAll();
            });
        }
    }
}

