/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.micronode;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.context.impl.InternalRoutingActionContextImpl;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.dao.PersistingMicroschemaDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.dao.UserDao;
import com.gentics.mesh.core.data.page.Page;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibMicroschemaVersion;
import com.gentics.mesh.core.data.schema.handler.MicroschemaComparatorImpl;
import com.gentics.mesh.core.data.service.BasicObjectTestcases;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.common.FieldTypes;
import com.gentics.mesh.core.rest.microschema.MicroschemaVersionModel;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaModelImpl;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.MicroschemaModel;
import com.gentics.mesh.core.rest.schema.MicroschemaReference;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.error.InvalidArgumentException;
import com.gentics.mesh.event.EventQueueBatch;
import com.gentics.mesh.json.MeshJsonException;
import com.gentics.mesh.parameter.PagingParameters;
import com.gentics.mesh.parameter.impl.PagingParametersImpl;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.CONTAINER_ES6, testSize=TestSize.FULL, startServer=true)
public class MicroschemaModelTest
extends AbstractMeshTest
implements BasicObjectTestcases {
    @Override
    @Test
    public void testTransformToReference() throws Exception {
        try (Tx tx = this.tx();){
            HibMicroschema vcard = this.microschemaContainer("vcard");
            MicroschemaReference reference = vcard.transformToReference();
            Assert.assertNotNull((Object)reference);
            Assert.assertEquals((Object)"vcard", (Object)reference.getName());
            Assert.assertEquals((Object)vcard.getUuid(), (Object)reference.getUuid());
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testFindAllVisible() throws InvalidArgumentException {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testFindAll() throws InvalidArgumentException {
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            int expectedMicroschemaContainers = this.microschemaContainers().size();
            for (long i = 1L; i <= (long)(expectedMicroschemaContainers + 1); ++i) {
                Page page = microschemaDao.findAll((InternalActionContext)ac, (PagingParameters)new PagingParametersImpl(1, Long.valueOf(i)));
                Assert.assertEquals((long)this.microschemaContainers().size(), (long)page.getTotalElements());
                Assert.assertEquals((long)Math.min((long)expectedMicroschemaContainers, i), (long)page.getSize());
            }
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testRootNode() {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testFindByName() {
        try (Tx tx = this.tx();){
            String invalidName = "thereIsNoMicroschemaWithThisName";
            for (String name : this.microschemaContainers().keySet()) {
                HibMicroschema container = (HibMicroschema)tx.microschemaDao().findByName(name);
                Assert.assertNotNull((String)("Could not find microschema container for name " + name), (Object)container);
                MicroschemaVersionModel microschemaModel = container.getLatestVersion().getSchema();
                Assert.assertNotNull((String)("Container for microschema " + name + " did not contain a microschema"), (Object)microschemaModel);
                Assert.assertEquals((String)"Check microschema name", (Object)name, (Object)microschemaModel.getName());
            }
            Assert.assertNull((String)("Must not find microschema with name " + invalidName), (Object)tx.microschemaDao().findByName(invalidName));
        }
    }

    @Override
    @Test
    public void testFindByUUID() {
        try (Tx tx = this.tx();){
            String invalidUUID = UUIDUtil.randomUUID();
            MicroschemaDao root = tx.microschemaDao();
            for (HibMicroschema container : this.microschemaContainers().values()) {
                String uuid = container.getUuid();
                Assert.assertNotNull((String)("Could not find microschema with uuid " + uuid), (Object)root.findByUuid(uuid));
            }
            Assert.assertNull((String)("Must not find microschema with uuid " + invalidUUID), (Object)root.findByUuid(invalidUUID));
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testRead() throws IOException {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testCreate() throws IOException {
        try (Tx tx = this.tx();){
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("test");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            Assert.assertNotNull((String)"The container was not created.", (Object)container);
            Assert.assertNotNull((String)"The container schema was not set", (Object)container.getLatestVersion().getSchema());
            Assert.assertEquals((String)"The creator was not set.", (Object)this.user().getUuid(), (Object)container.getCreator().getUuid());
        }
    }

    @Test
    public void testVersionSync() {
        try (Tx tx = this.tx();){
            Assert.assertNotNull((Object)this.microschemaContainer("vcard"));
            Assert.assertEquals((String)"The microschema container and schema rest model version must always be in sync", (Object)this.microschemaContainer("vcard").getLatestVersion().getVersion(), (Object)this.microschemaContainer("vcard").getLatestVersion().getSchema().getVersion());
        }
    }

    @Override
    @Test
    public void testDelete() throws MeshJsonException {
        try (Tx tx = this.tx();){
            MicroschemaDao microschemaDao = tx.microschemaDao();
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("test");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            tx.commit();
            Assert.assertNotNull((Object)microschemaDao.findByName("test"));
            BulkActionContext bac = this.createBulkContext();
            microschemaDao.delete((HibBaseElement)container, bac);
            Assert.assertNull((Object)microschemaDao.findByName("test"));
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testUpdate() {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testReadPermission() throws MeshJsonException {
        try (Tx tx = this.tx();){
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("someNewMicroschema");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            this.testPermission(InternalPermission.READ_PERM, (HibBaseElement)container);
        }
    }

    @Override
    @Test
    public void testDeletePermission() throws MeshJsonException {
        try (Tx tx = this.tx();){
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("someNewMicroschema");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            this.testPermission(InternalPermission.DELETE_PERM, (HibBaseElement)container);
        }
    }

    @Override
    @Test
    public void testUpdatePermission() throws MeshJsonException {
        try (Tx tx = this.tx();){
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("someNewMicroschema");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            this.testPermission(InternalPermission.UPDATE_PERM, (HibBaseElement)container);
        }
    }

    @Override
    @Test
    public void testCreatePermission() throws MeshJsonException {
        try (Tx tx = this.tx();){
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("someNewMicroschema");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            this.testPermission(InternalPermission.CREATE_PERM, (HibBaseElement)container);
        }
    }

    @Override
    @Test
    public void testTransformation() throws IOException {
        try (Tx tx = this.tx();){
            RoutingContext rc = this.mockRoutingContext();
            InternalRoutingActionContextImpl ac = new InternalRoutingActionContextImpl(rc);
            HibMicroschema vcard = this.microschemaContainer("vcard");
            MicroschemaResponse schema = (MicroschemaResponse)Tx.get().microschemaDao().transformToRestSync((Object)vcard, (InternalActionContext)ac, 0, new String[]{"en"});
            Assert.assertEquals((Object)vcard.getUuid(), (Object)schema.getUuid());
        }
    }

    @Override
    @Ignore(value="Not yet implemented")
    @Test
    public void testCreateDelete() {
        Assert.fail((String)"Not yet implemented");
    }

    @Override
    @Test
    public void testCRUDPermissions() throws MeshJsonException {
        try (Tx tx = this.tx();){
            RoleDao roleDao = tx.roleDao();
            UserDao userDao = tx.userDao();
            MicroschemaModelImpl schema = new MicroschemaModelImpl();
            schema.setName("someNewMicroschema");
            HibMicroschema container = this.createMicroschema((MicroschemaVersionModel)schema);
            Assert.assertFalse((boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)container));
            userDao.inheritRolePermissions(this.getRequestUser(), tx.data().permissionRoots().microschema(), (HibBaseElement)container);
            Assert.assertTrue((String)"The addCRUDPermissionOnRole method should add the needed permissions on the new microschema container.", (boolean)roleDao.hasPermission(this.role(), InternalPermission.CREATE_PERM, (HibBaseElement)container));
        }
    }

    @Test
    public void testGetContainerUsingMicroschemaVersion() throws IOException {
        HibMicroschemaVersion vcard = (HibMicroschemaVersion)this.tx(tx -> {
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx.unwrap()).microschemaDao();
            HibMicroschemaVersion vcard1 = this.microschemaContainer("vcard").getLatestVersion();
            MicroschemaVersionModel microschemaModel = vcard1.getSchema();
            MicroschemaModelImpl updatedMicroschemaModel = new MicroschemaModelImpl();
            updatedMicroschemaModel.setName(microschemaModel.getName());
            updatedMicroschemaModel.getFields().addAll(microschemaModel.getFields());
            updatedMicroschemaModel.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"newfield"));
            SchemaChangesListModel model = new SchemaChangesListModel();
            model.getChanges().addAll(new MicroschemaComparatorImpl().diff((MicroschemaModel)microschemaModel, (MicroschemaModel)updatedMicroschemaModel));
            InternalActionContext ac = this.mockActionContext();
            EventQueueBatch batch = this.createBatch();
            microschemaDao.applyChanges((HibFieldSchemaVersionElement)vcard1, ac, model, batch);
            this.prepareTypedSchema(this.folder("2015"), List.of(new MicronodeFieldSchemaImpl().setName("single"), new ListFieldSchemaImpl().setListType(FieldTypes.MICRONODE.toString()).setName("list")), Optional.empty());
            tx.success();
            return vcard1;
        });
        ArrayList<String> containerUuids = new ArrayList<String>();
        try (Tx tx2 = this.tx();){
            HibMicroschemaVersion newVCard = this.microschemaContainer("vcard").getLatestVersion();
            HibNodeFieldContainer containerWithBoth = tx2.contentDao().getFieldContainer(this.folder("2015"), "en");
            containerWithBoth.createMicronode("single", vcard);
            containerWithBoth.createMicronodeList("list").createMicronode(vcard);
            containerUuids.add(containerWithBoth.getUuid());
            HibNodeFieldContainer containerWithField = tx2.contentDao().getFieldContainer(this.folder("news"), "en");
            containerWithField.createMicronode("single", vcard);
            containerUuids.add(containerWithField.getUuid());
            HibNodeFieldContainer containerWithList = tx2.contentDao().getFieldContainer(this.folder("products"), "en");
            containerWithList.createMicronodeList("list").createMicronode(vcard);
            containerUuids.add(containerWithList.getUuid());
            HibNodeFieldContainer containerWithOtherVersion = tx2.contentDao().getFieldContainer(this.folder("deals"), "en");
            containerWithOtherVersion.createMicronode("single", newVCard);
            tx2.success();
        }
        tx2 = this.tx();
        try {
            PersistingMicroschemaDao microschemaDao = ((CommonTx)tx2.unwrap()).microschemaDao();
            List containers = microschemaDao.findDraftFieldContainers((HibFieldSchemaVersionElement)vcard, this.project().getLatestBranch().getUuid()).list();
            Assertions.assertThat(containers.stream().map(HibElement::getUuid)).containsOnlyElementsOf(containerUuids);
            tx2.success();
        }
        finally {
            if (tx2 != null) {
                tx2.close();
            }
        }
    }
}

