/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.node;

import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class BasicNodeFieldEndpointTest
extends AbstractMeshTest {
    @Test
    public void testUpdateNodeAndOmitRequiredField() throws IOException {
        try (Tx tx = this.tx();){
            HtmlFieldSchemaImpl htmlFieldSchema = new HtmlFieldSchemaImpl();
            htmlFieldSchema.setName("htmlField");
            htmlFieldSchema.setLabel("Some label");
            htmlFieldSchema.setRequired(true);
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(htmlFieldSchema), Optional.empty());
            tx.success();
        }
        HibNode parentNode = this.folder("2015");
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNodeUuid(parentNode.getUuid());
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.getFields().put("htmlField", (Field)new HtmlFieldImpl().setHTML("Some<b>html"));
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}));
        Assert.assertNotNull((String)"The response could not be found in the result of the future.", (Object)response);
        Assert.assertNotNull((String)"The field was not included in the response.", (Object)response.getFields().getHtmlField("htmlField"));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("0.1");
        NodeResponse updateResponse = (NodeResponse)this.client().updateNode("dummy", response.getUuid(), nodeUpdateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}).blockingGet();
        Assert.assertNotNull((String)"The response could not be found in the result of the future.", (Object)updateResponse);
    }
}

