/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.nesting.HibNodeField;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.NodeField;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.LinkType;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.DeleteParametersImpl;
import com.gentics.mesh.parameter.client.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeFieldEndpointTest
extends AbstractFieldEndpointTest {
    final String FIELD_NAME = "nodeField";

    @Before
    public void updateSchema() throws Exception {
        try (Tx tx = this.tx();){
            NodeFieldSchemaImpl nodeFieldSchema = new NodeFieldSchemaImpl();
            nodeFieldSchema.setName("nodeField");
            nodeFieldSchema.setLabel("Some label");
            nodeFieldSchema.setAllowedSchemas(new String[]{"folder", "content"});
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(nodeFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        HibNode node = this.folder("2015");
        List<HibNode> targetNodes = Arrays.asList(this.folder("news"), this.folder("deals"));
        for (int i = 0; i < 20; ++i) {
            HibNode newValue = targetNodes.get(i % 2);
            HibNode oldValue = null;
            HibNodeFieldContainer container = null;
            try (Tx tx = this.tx();){
                container = tx.contentDao().getFieldContainer(node, "en");
                oldValue = this.getNodeValue(container, "nodeField");
            }
            NodeResponse response = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(newValue.getUuid()));
            NodeResponse field = response.getFields().getNodeFieldExpanded("nodeField");
            ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)field.getUuid()).as("New Value", new Object[0])).isEqualTo((Object)newValue.getUuid());
            try (Tx tx = this.tx();){
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", (Object)oldValue, (Object)this.getNodeValue(container, "nodeField"));
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        HibNode target = this.folder("news");
        NodeResponse firstResponse = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(target.getUuid()));
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(target.getUuid()));
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode target = this.folder("news");
        NodeResponse firstResponse = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(target.getUuid()));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = (NodeResponse)this.tx(() -> this.updateNode("nodeField", null));
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getNodeField("nodeField")).as("Deleted Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            MeshAssertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            MeshAssertions.assertThat((Object)latest.getNode("nodeField")).isNull();
            MeshAssertions.assertThat((Object)latest.getPreviousVersion().getNode("nodeField")).isNotNull();
            String oldValue = latest.getPreviousVersion().getNode("nodeField").getNode().getUuid();
            MeshAssertions.assertThat((String)oldValue).isEqualTo((Object)target.getUuid());
        }
        NodeResponse thirdResponse = this.updateNode("nodeField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        String uuid = (String)this.tx(() -> this.folder("news").getUuid());
        this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(uuid));
        try (Tx tx = this.tx();){
            this.updateNodeFailure("nodeField", (Field)new NodeFieldImpl(), HttpResponseStatus.BAD_REQUEST, "node_error_field_property_missing", "uuid", "nodeField");
        }
    }

    @Override
    @Test
    public void testDeleteField() {
        HibNode target = this.folder("deals");
        String targetUuid = (String)this.tx(() -> target.getUuid());
        NodeResponse response = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(targetUuid));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", targetUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().deleteNode("dummy", response.getUuid(), new ParameterProvider[]{new DeleteParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().findNodeByUuid("dummy", targetUuid, new ParameterProvider[0]));
    }

    @Test
    public void testReferenceUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(targetUuid));
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Test
    public void testUpdateNodeFieldWithNodeResponseJson() {
        HibNode node = this.folder("news");
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        HibNode node2 = this.folder("deals");
        String node2Uuid = (String)this.tx(() -> node2.getUuid());
        HibNode updatedNode = this.folder("2015");
        String updatedNodeUuid = (String)this.tx(() -> updatedNode.getUuid());
        NodeResponse loadedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", nodeUuid, new ParameterProvider[]{new VersioningParametersImpl().draft()}));
        NodeResponse response = this.updateNode("nodeField", (Field)loadedNode);
        NodeResponse field = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)nodeUuid, (Object)field.getUuid());
        loadedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", updatedNodeUuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"}), new VersioningParametersImpl().draft()}));
        field = loadedNode.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)nodeUuid, (Object)field.getUuid());
        response = this.updateNode("nodeField", (Field)new NodeFieldImpl().setUuid(node2Uuid));
        field = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)node2Uuid, (Object)field.getUuid());
        loadedNode = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", updatedNodeUuid, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"}), new VersioningParametersImpl().draft()}));
        field = loadedNode.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)node2Uuid, (Object)field.getUuid());
    }

    @Test
    @Ignore(value="Field deletion is currently not implemented.")
    public void testCreateDeleteNodeField() {
        NodeResponse response = this.createNode("nodeField", (Field)new NodeFieldImpl().setUuid(this.folder("news").getUuid()));
        NodeResponse field = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)this.folder("news").getUuid(), (Object)field.getUuid());
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.getFields().put("nodeField", null);
        response = (NodeResponse)this.client().updateNode("dummy", response.getUuid(), nodeUpdateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}).blockingGet();
        Assert.assertNull((String)"The field should have been deleted", (Object)response.getFields().getNodeField("nodeField"));
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNode("nodeField", (Field)new NodeFieldImpl().setUuid(this.folder("news").getUuid()));
        NodeResponse field = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertEquals((Object)this.folder("news").getUuid(), (Object)field.getUuid());
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() throws IOException {
        HibNode newsNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createNode("nodeField", newsNode);
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        NodeField deserializedNodeField = response.getFields().getNodeField("nodeField");
        Assert.assertNotNull((Object)deserializedNodeField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)deserializedNodeField.getUuid());
    }

    @Test
    public void testReadNodeWithResolveLinks() throws IOException {
        HibNode newsNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createNode("nodeField", newsNode);
            tx.success();
        }
        NodeParametersImpl parameters = new NodeParametersImpl();
        parameters.setLanguages(new String[]{"en"});
        parameters.setResolveLinks(LinkType.FULL);
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{parameters, new VersioningParametersImpl().draft()}));
        NodeField deserializedNodeField = response.getFields().getNodeField("nodeField");
        Assert.assertNotNull((Object)deserializedNodeField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)deserializedNodeField.getUuid());
        Assert.assertNotNull((Object)deserializedNodeField.getPath());
        Assert.assertNotNull((Object)deserializedNodeField.getLanguagePaths());
        MeshAssertions.assertThat((Map)deserializedNodeField.getLanguagePaths()).containsKeys((Object[])new String[]{"en", "de"});
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("nodeField", null);
        NodeResponse field = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertNull((String)"The expanded node field within the response should be null since we created the node without providing any field information.", (Object)field);
    }

    @Test
    public void testReadNodeExpandAll() throws IOException {
        HibNode referencedNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createNode("nodeField", referencedNode);
            tx.success();
        }
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", this.folder("2015").getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true), new VersioningParametersImpl().draft()}));
        NodeResponse deserializedExpandedNodeField = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertNotNull((String)"The referenced field should not be null", (Object)deserializedExpandedNodeField);
        NodeResponse expandedField = deserializedExpandedNodeField;
        Assert.assertEquals((Object)referencedNode.getUuid(), (Object)expandedField.getUuid());
        Assert.assertNotNull((Object)expandedField.getCreator());
    }

    @Test
    public void testReadNodeExpandAllNoPerm() throws IOException {
        HibNode node = (HibNode)this.tx(tx -> {
            ContentDao contentDao = tx.contentDao();
            RoleDao roleDao = tx.roleDao();
            HibNode referencedNode = this.folder("news");
            roleDao.revokePermissions(this.role(), (HibBaseElement)referencedNode, new InternalPermission[]{InternalPermission.READ_PERM});
            HibNode node1 = this.folder("2015");
            this.prepareTypedSchema(node1, (FieldSchema)FieldUtil.createNodeFieldSchema((String)"nodeField"), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.getLatestDraftFieldContainer(node1, this.english());
            container.createNode("nodeField", referencedNode);
            tx.success();
            return node1;
        });
        NodeResponse response = (NodeResponse)ClientHelper.call(() -> this.client().findNodeByUuid("dummy", node.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setExpandAll(true), new VersioningParametersImpl().draft()}));
        NodeResponse deserializedExpandedNodeField = response.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertNull((String)"The referenced field should be null", (Object)deserializedExpandedNodeField);
    }

    @Test
    public void testReadExpandedNodeWithExistingField() throws IOException {
        HibNode newsNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createNode("nodeField", newsNode);
            tx.success();
        }
        NodeResponse responseCollapsed = this.readNode(this.folder("2015"), new String[0]);
        NodeField deserializedNodeField = responseCollapsed.getFields().getNodeField("nodeField");
        Assert.assertNotNull((Object)deserializedNodeField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)deserializedNodeField.getUuid());
        NodeResponse deserializedExpandedNodeField = responseCollapsed.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertNotNull((Object)deserializedExpandedNodeField);
        NodeResponse responseExpanded = this.readNode(this.folder("2015"), "nodeField", "bogus");
        deserializedNodeField = responseExpanded.getFields().getNodeField("nodeField");
        Assert.assertNotNull((Object)deserializedNodeField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)deserializedNodeField.getUuid());
        NodeResponse expandedField = deserializedExpandedNodeField = responseExpanded.getFields().getNodeFieldExpanded("nodeField");
        Assert.assertNotNull((Object)expandedField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)expandedField.getUuid());
        Assert.assertNotNull((Object)expandedField.getCreator());
    }

    @Test
    public void testReadExpandedNodeWithLanguageFallback() throws IOException {
        HibNode folder = this.folder("2015");
        try (Tx tx = this.tx();){
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(FieldUtil.createNodeFieldSchema((String)"nodeField")), Optional.empty());
            tx.success();
        }
        NodeCreateRequest createGermanNode = new NodeCreateRequest();
        createGermanNode.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        createGermanNode.setParentNodeUuid(folder.getUuid());
        createGermanNode.setLanguage("de");
        createGermanNode.getFields().put("name", (Field)FieldUtil.createStringField((String)"German Target"));
        NodeResponse germanTarget = (NodeResponse)this.client().createNode("dummy", createGermanNode, new ParameterProvider[0]).blockingGet();
        NodeUpdateRequest createEnglishNode = new NodeUpdateRequest();
        createEnglishNode.setLanguage("en");
        createEnglishNode.getFields().put("name", (Field)FieldUtil.createStringField((String)"English Target"));
        NodeResponse updateEnglishNode = (NodeResponse)this.client().updateNode("dummy", germanTarget.getUuid(), createEnglishNode, new ParameterProvider[0]).blockingGet();
        NodeCreateRequest createSourceNode = new NodeCreateRequest();
        createSourceNode.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        createSourceNode.setParentNodeUuid(folder.getUuid());
        createSourceNode.setLanguage("de");
        createSourceNode.getFields().put("name", (Field)FieldUtil.createStringField((String)"German Source"));
        createSourceNode.getFields().put("nodeField", (Field)FieldUtil.createNodeField((String)germanTarget.getUuid()));
        NodeResponse source = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", createSourceNode, new ParameterProvider[0]));
        try (Tx tx = this.tx();){
            for (String[] requestedLangs : Arrays.asList({"de"}, {"de", "en"}, {"en", "de"})) {
                NodeResponse response = (NodeResponse)this.client().findNodeByUuid("dummy", source.getUuid(), new ParameterProvider[]{new NodeParametersImpl().setLanguages(requestedLangs).setExpandAll(true), new VersioningParametersImpl().draft()}).blockingGet();
                Assert.assertEquals((String)"Check node language", (Object)"de", (Object)response.getLanguage());
                NodeResponse nodeField = response.getFields().getNodeFieldExpanded("nodeField");
                Assert.assertNotNull((String)"Field must be present", (Object)nodeField);
                Assert.assertEquals((String)"Check target node language", (Object)"de", (Object)nodeField.getLanguage());
            }
        }
    }

    protected HibNode getNodeValue(HibNodeFieldContainer container, String fieldName) {
        HibNodeField field = container.getNode(fieldName);
        return field != null ? field.getNode() : null;
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode("nodeField", (Field)new NodeFieldImpl().setUuid(this.folder("news").getUuid()));
    }
}

