/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.node;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.nesting.HibNodeField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.node.NodeFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.NodeField;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.NodeFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class NodeFieldTest
extends AbstractFieldTest<NodeFieldSchema> {
    final String NODE_FIELD = "nodeField";

    @Override
    protected NodeFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema("nodeField", isRequired);
    }

    protected NodeFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        NodeFieldSchemaImpl nodeFieldSchema = new NodeFieldSchemaImpl();
        nodeFieldSchema.setName(fieldKey);
        nodeFieldSchema.setAllowedSchemas(new String[]{"folder", "content"});
        nodeFieldSchema.setRequired(isRequired);
        return nodeFieldSchema;
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeField testField = container.createNode("nodeField", node);
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getNode("nodeField")).as("cloned field", new Object[0])).isNotNull();
            Assert.assertTrue((boolean)otherContainer.getNode("nodeField").getNode().getUuid().equals(node.getUuid()));
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeField field = container.createNode("nodeField", node);
            Assert.assertNotNull((Object)field);
            Assert.assertEquals((Object)"nodeField", (Object)field.getFieldKey());
            HibNode loadedNode = field.getNode();
            Assert.assertNotNull((Object)loadedNode);
            Assert.assertEquals((Object)node.getUuid(), (Object)loadedNode.getUuid());
            HibNodeField loadedField = container.getNode("nodeField");
            Assert.assertNotNull((Object)loadedField);
            Assert.assertNotNull((Object)loadedField.getNode());
            Assert.assertEquals((Object)node.getUuid(), (Object)loadedField.getNode().getUuid());
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode newsNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareTypedSchema(node, (FieldSchema)this.createFieldSchema(true), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            container.createNode("nodeField", newsNode);
            tx.success();
        }
        tx = this.tx();
        try {
            String json = this.getJson(this.folder("2015"));
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            NodeField deserializedNodeField = response.getFields().getNodeField("nodeField");
            Assert.assertNotNull((String)("The field {nodeField} should not be null. Json: {" + json + "}"), (Object)deserializedNodeField);
            Assert.assertEquals((Object)newsNode.getUuid(), (Object)deserializedNodeField.getUuid());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true), this.createFieldSchema("fieldC", true)});
            HibNodeField fieldA = container.createNode("fieldA", this.folder("2015"));
            HibNodeField fieldB = container.createNode("fieldB", this.folder("2014"));
            HibNodeField fieldC = container.createNode("fieldC", this.folder("2015"));
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldC));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeField fieldA = container.createNode("nodeField", this.content());
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeField fieldA = container.createNode("nodeField", this.content());
            Assert.assertFalse((String)"The field should not be equal to a string rest field. Even if it has the same value", (boolean)fieldA.equals(new StringFieldImpl().setString("someText")));
            Assert.assertFalse((String)"The field should not be equal to the rest field since the rest field has a different value.", (boolean)fieldA.equals(new NodeFieldImpl().setUuid(this.folder("2015").getUuid())));
            Assert.assertTrue((String)"The field should be equal to a rest field with the same value", (boolean)fieldA.equals(new NodeFieldImpl().setUuid(this.content().getUuid())));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase("nodeField", NodeFieldTestHelper.FETCH, NodeFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase("nodeField", NodeFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase("nodeField", NodeFieldTestHelper.FETCH, NodeFieldTestHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, "nodeField", null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase("nodeField", NodeFieldTestHelper.FETCH, NodeFieldTestHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, "nodeField", null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase("nodeField", NodeFieldTestHelper.FILL, container -> {
                NodeFieldImpl field = new NodeFieldImpl();
                field.setUuid(this.content().getUuid());
                this.updateContainer(ac, (HibNodeFieldContainer)container, "nodeField", (Field)field);
            }, container -> {
                HibNodeField field = container.getNode("nodeField");
                Assert.assertNotNull((String)"The graph field {nodeField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The node reference of the field was not updated.", (Object)this.content().getUuid(), (Object)field.getNode().getUuid());
            });
        }
    }
}

