/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.node;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.dao.RoleDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibNodeFieldList;
import com.gentics.mesh.core.data.perm.InternalPermission;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.MeshEvent;
import com.gentics.mesh.core.rest.common.ContainerType;
import com.gentics.mesh.core.rest.event.node.NodeMeshEventModel;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.NodeFieldListItem;
import com.gentics.mesh.core.rest.node.field.list.NodeFieldList;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.util.CompareUtils;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(elasticsearch=ElasticsearchTestMode.TRACKING, testSize=TestSize.FULL, startServer=true)
public class NodeListFieldEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "node";
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(null, null);
        NodeFieldList nodeField = response.getFields().getNodeFieldList("listField");
        Assert.assertNull((Object)nodeField);
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Test
    public void testBogusNodeList() throws IOException {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        listField.add((Object)new NodeFieldListItemImpl("bogus"));
        ClientHelper.call(() -> this.createNodeAsync("listField", (Field)listField), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST);
    }

    @Test
    public void testValidNodeList() throws IOException {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        listField.add((Object)new NodeFieldListItemImpl(this.content().getUuid()));
        listField.add((Object)new NodeFieldListItemImpl(this.folder("news").getUuid()));
        NodeResponse response = this.createNode("listField", (Field)listField);
        NodeFieldList listFromResponse = response.getFields().getNodeFieldList("listField");
        Assert.assertEquals((long)2L, (long)listFromResponse.getItems().size());
        Assert.assertEquals((Object)this.content().getUuid(), (Object)((NodeFieldListItem)listFromResponse.getItems().get(0)).getUuid());
        Assert.assertEquals((Object)this.folder("news").getUuid(), (Object)((NodeFieldListItem)listFromResponse.getItems().get(1)).getUuid());
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        HibNode targetNode = this.folder("news");
        HibNode targetNode2 = this.folder("deals");
        List<List> valueCombinations = Arrays.asList(Arrays.asList(targetNode), Arrays.asList(targetNode2, targetNode), Collections.emptyList(), Arrays.asList(targetNode, targetNode2), Arrays.asList(targetNode2));
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
        for (int i = 0; i < 20; ++i) {
            List newValue;
            List oldValue;
            NodeFieldListImpl list = new NodeFieldListImpl();
            try (Tx tx2 = this.tx();){
                oldValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getNodeList(arg_0), "listField");
                newValue = valueCombinations.get(i % valueCombinations.size());
                for (HibNode value : newValue) {
                    list.add((Object)new NodeFieldListItemImpl(value.getUuid()));
                }
            }
            NodeResponse response = this.updateNode("listField", (Field)list);
            NodeFieldList field = response.getFields().getNodeFieldList("listField");
            ((AbstractListAssert)MeshAssertions.assertThat((List)field.getItems()).as("Updated field", new Object[0]).usingElementComparatorOnFields(new String[]{"uuid"})).containsExactlyElementsOf((Iterable)list.getItems());
            try (Tx tx3 = this.tx();){
                ContentDao contentDao = tx3.contentDao();
                HibNodeFieldContainer newContainerVersion = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                newValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getNodeList(arg_0), "listField");
                Assert.assertEquals((String)"Check version number", (Object)newContainerVersion.getVersion().toString(), (Object)response.getVersion());
                Assert.assertTrue((String)"Check old value", (boolean)CompareUtils.equals(oldValue, newValue));
                container = newContainerVersion;
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        HibNode targetNode = this.folder("news");
        HibNode targetNode2 = this.folder("deals");
        NodeFieldListImpl list = new NodeFieldListImpl();
        list.add((Object)new NodeFieldListItemImpl(targetNode.getUuid()));
        list.add((Object)new NodeFieldListItemImpl(targetNode2.getUuid()));
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)list);
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode targetNode = this.folder("news");
        HibNode targetNode2 = this.folder("deals");
        NodeFieldListImpl list = new NodeFieldListImpl();
        list.add((Object)new NodeFieldListItemImpl((String)this.tx(() -> targetNode.getUuid())));
        list.add((Object)new NodeFieldListItemImpl((String)this.tx(() -> targetNode2.getUuid())));
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getNodeFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            MeshAssertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            MeshAssertions.assertThat((Object)latest.getNodeList("listField")).isNull();
            MeshAssertions.assertThat((Object)latest.getPreviousVersion().getNodeList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getNodeList("listField").getList().stream().map(item -> item.getNode().getUuid()).collect(Collectors.toList());
            MeshAssertions.assertThat(oldValueList).containsExactly((Object[])new String[]{targetNode.getUuid(), targetNode2.getUuid()});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        HibNode targetNode = this.folder("news");
        HibNode targetNode2 = this.folder("deals");
        NodeFieldListImpl list = new NodeFieldListImpl();
        list.add((Object)new NodeFieldListItemImpl((String)this.tx(() -> targetNode.getUuid())));
        list.add((Object)new NodeFieldListItemImpl((String)this.tx(() -> targetNode2.getUuid())));
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeFieldListImpl emptyField = new NodeFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)MeshAssertions.assertThat((Object)secondResponse.getFields().getNodeFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        MeshAssertions.assertThat((List)secondResponse.getFields().getNodeFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        NodeFieldListItemImpl item = new NodeFieldListItemImpl().setUuid(this.folderUuid());
        listField.add((Object)item);
        NodeResponse response = this.createNode("listField", (Field)listField);
        NodeFieldList listFromResponse = response.getFields().getNodeFieldList("listField");
        Assert.assertEquals((long)1L, (long)listFromResponse.getItems().size());
    }

    @Test
    public void testReferenceListUpdateOnDelete() {
        String sourceUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        String targetUuid = this.contentUuid();
        NodeFieldListImpl listField = new NodeFieldListImpl();
        NodeFieldListItemImpl item = new NodeFieldListItemImpl().setUuid(targetUuid);
        listField.add((Object)item);
        listField.add((Object)item);
        listField.add((Object)item);
        this.updateNode("listField", (Field)listField);
        ClientHelper.call(() -> this.client().publishNode("dummy", sourceUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("en");
        nodeUpdateRequest.setVersion("draft");
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"blub123"));
        ClientHelper.call(() -> this.client().updateNode("dummy", sourceUuid, nodeUpdateRequest, new ParameterProvider[0]));
        this.expect(MeshEvent.NODE_DELETED).one();
        this.expect(MeshEvent.NODE_REFERENCE_UPDATED).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.DRAFT).hasSchemaName("folder").hasUuid(sourceUuid)).match(1, NodeMeshEventModel.class, event -> MeshAssertions.assertThat((NodeMeshEventModel)event).hasBranchUuid(this.initialBranchUuid()).hasLanguage("en").hasType(ContainerType.PUBLISHED).hasSchemaName("folder").hasUuid(sourceUuid)).two();
        ClientHelper.call(() -> this.client().deleteNode("dummy", targetUuid, new ParameterProvider[0]));
        this.awaitEvents();
        this.waitForSearchIdleEvent();
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNodeFieldList nodeList = container.createNodeList("listField");
            nodeList.createNode(this.folder("news"));
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        NodeFieldList deserializedListField = response.getFields().getNodeFieldList("listField");
        Assert.assertNotNull((Object)deserializedListField);
        Assert.assertEquals((long)1L, (long)deserializedListField.getItems().size());
    }

    @Test
    public void testReadExpandedListWithNoPermOnItem() throws IOException {
        HibNode referencedNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            RoleDao roleDao = tx.roleDao();
            roleDao.revokePermissions(this.role(), (HibBaseElement)referencedNode, new InternalPermission[]{InternalPermission.READ_PERM});
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNodeFieldList nodeList = container.createNodeList("listField");
            nodeList.createNode(referencedNode);
            tx.success();
        }
        NodeResponse responseCollapsed = this.readNode(this.folder("2015"), new String[0]);
        NodeFieldList deserializedNodeListField = responseCollapsed.getFields().getNodeFieldList("listField");
        Assert.assertNotNull((Object)deserializedNodeListField);
        Assert.assertEquals((String)"The newsNode should not be within in the list thus the list should be empty.", (long)0L, (long)deserializedNodeListField.getItems().size());
        NodeResponse responseExpanded = this.readNode(this.folder("2015"), "listField", "bogus");
        deserializedNodeListField = responseExpanded.getFields().getNodeFieldList("listField");
        Assert.assertNotNull((Object)deserializedNodeListField);
        Assert.assertEquals((String)"The item should also not be included in the list even if we request an expanded node.", (long)0L, (long)deserializedNodeListField.getItems().size());
    }

    @Test
    public void testReadExpandedNodeListWithExistingField() throws IOException {
        HibNode newsNode = this.folder("news");
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNodeFieldList nodeList = container.createNodeList("listField");
            nodeList.createNode(newsNode);
            tx.success();
        }
        NodeResponse responseCollapsed = this.readNode(this.folder("2015"), new String[0]);
        NodeFieldList deserializedNodeListField = responseCollapsed.getFields().getNodeFieldList("listField");
        Assert.assertNotNull((Object)deserializedNodeListField);
        Assert.assertEquals((String)"The newsNode should be the first item in the list.", (Object)newsNode.getUuid(), (Object)((NodeFieldListItem)deserializedNodeListField.getItems().get(0)).getUuid());
        NodeResponse nodeListItem = (NodeResponse)deserializedNodeListField.getItems().get(0);
        Assert.assertNotNull((Object)nodeListItem);
        NodeResponse responseExpanded = this.readNode(this.folder("2015"), "listField", "bogus");
        deserializedNodeListField = responseExpanded.getFields().getNodeFieldList("listField");
        Assert.assertNotNull((Object)deserializedNodeListField);
        Assert.assertEquals((Object)newsNode.getUuid(), (Object)((NodeFieldListItem)deserializedNodeListField.getItems().get(0)).getUuid());
        NodeFieldListItem deserializedExpandedItem = (NodeFieldListItem)deserializedNodeListField.getItems().get(0);
        if (deserializedExpandedItem instanceof NodeResponse) {
            NodeResponse expandedField = (NodeResponse)deserializedExpandedItem;
            Assert.assertNotNull((Object)expandedField);
            Assert.assertEquals((Object)newsNode.getUuid(), (Object)expandedField.getUuid());
            Assert.assertNotNull((Object)expandedField.getCreator());
        } else {
            Assert.fail((String)"The returned item should be a NodeResponse object");
        }
    }

    @Override
    public NodeResponse createNodeWithField() {
        NodeFieldListImpl listField = new NodeFieldListImpl();
        NodeFieldListItemImpl item = new NodeFieldListItemImpl().setUuid(this.folderUuid());
        listField.add((Object)item);
        return this.createNode("listField", (Field)listField);
    }
}

