/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.node;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibCoreElement;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibNodeFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.data.node.field.nesting.HibNodeField;
import com.gentics.mesh.core.db.CommonTx;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.node.NodeListFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListItemImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.UUIDUtil;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=false)
public class NodeListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String NODE_LIST = "nodeList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(NODE_LIST, isRequired);
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("node");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNode newsNode = this.folder("news");
            this.prepareNode(node, NODE_LIST, "node");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNodeFieldList nodeList = container.createNodeList(NODE_LIST);
            nodeList.createNode(0, newsNode);
            nodeList.createNode(1, newsNode);
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, NODE_LIST, "node", response);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = (HibNode)((CommonTx)tx.unwrap()).nodeDao().createPersisted((HibCoreElement)this.project(), null);
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeFieldList list = container.createNodeList(NODE_LIST);
            Assert.assertEquals((long)0L, (long)list.getList().size());
            list.createNode(0, node);
            Assert.assertEquals((long)1L, (long)list.getList().size());
            HibNodeField foundNodeField = (HibNodeField)list.getList().get(0);
            Assert.assertNotNull((Object)foundNodeField.getNode());
            Assert.assertEquals((Object)node.getUuid(), (Object)foundNodeField.getNode().getUuid());
            HibNodeFieldList loadedList = container.getNodeList(NODE_LIST);
            Assert.assertNotNull((Object)loadedList);
            Assert.assertEquals((long)1L, (long)loadedList.getSize());
            Assert.assertEquals((Object)node.getUuid(), (Object)((HibNodeField)loadedList.getList().get(0)).getNode().getUuid());
            Assert.assertEquals((long)1L, (long)list.getList().size());
            list.createNode(1, node);
            Assert.assertEquals((long)2L, (long)list.getList().size());
            list.removeAll();
            Assert.assertEquals((long)0L, (long)list.getSize());
            Assert.assertEquals((long)0L, (long)list.getList().size());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeFieldList testField = container.createNodeList(NODE_LIST);
            testField.createNode(0, node);
            testField.createNode(1, node);
            testField.createNode(2, node);
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assert.assertTrue((boolean)otherContainer.getNodeList(NODE_LIST).equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibNodeFieldList fieldA = container.createNodeList("fieldA");
            HibNodeFieldList fieldB = container.createNodeList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.addItem((HibListableField)fieldA.createNode(0, this.content()));
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.addItem((HibListableField)fieldB.createNode(0, this.content()));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNodeFieldList fieldA = container.createNodeList(NODE_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            String dummyKey = "test123";
            HibNodeFieldList fieldA = container.createNodeList(NODE_LIST);
            NodeFieldListImpl restField = new NodeFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.addItem((HibListableField)fieldA.createNode(this.content()));
            restField.add((Object)new NodeFieldListItemImpl(UUIDUtil.randomUUID()));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            restField.add((Object)new NodeFieldListItemImpl(this.content().getUuid()));
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            HtmlFieldListImpl otherTypeRestField = new HtmlFieldListImpl();
            otherTypeRestField.add((Object)dummyKey);
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(NODE_LIST, NodeListFieldTestHelper.FETCH, NodeListFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(NODE_LIST, NodeListFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(NODE_LIST, NodeListFieldTestHelper.FETCH, NodeListFieldTestHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, NODE_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(NODE_LIST, NodeListFieldTestHelper.FETCH, NodeListFieldTestHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, NODE_LIST, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(NODE_LIST, NodeListFieldTestHelper.FILL, container -> {
                NodeFieldListImpl field = new NodeFieldListImpl();
                field.getItems().add(new NodeFieldListItemImpl(this.content().getUuid()));
                field.getItems().add(new NodeFieldListItemImpl(this.folder("2015").getUuid()));
                this.updateContainer(ac, (HibNodeFieldContainer)container, NODE_LIST, (Field)field);
            }, container -> {
                HibNodeFieldList field = container.getNodeList(NODE_LIST);
                Assert.assertNotNull((String)"The graph field {nodeList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)this.content().getUuid(), (Object)((HibNodeField)field.getList().get(0)).getNode().getUuid());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)this.folder("2015").getUuid(), (Object)((HibNodeField)field.getList().get(1)).getNode().getUuid());
            });
        }
    }
}

