/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.number;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibNumberField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.number.AbstractNumberFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class NumberFieldEndpointParameterizedTest
extends AbstractNumberFieldEndpointTest {
    @Parameterized.Parameter
    public Number num;
    @Parameterized.Parameter(value=1)
    public String testName;

    @Parameterized.Parameters(name="{index}: {1}")
    public static Collection<Object> paramData() {
        return Arrays.asList((Object[])new Object[][]{{1.0, "Float with 0 decimal places"}, {Integer.MIN_VALUE, "Int min"}, {Integer.MAX_VALUE, "Int max"}, {Long.MIN_VALUE, "Long min"}, {Long.MAX_VALUE, "Long max"}, {-2147483649L, "Int min -1"}, {0x80000000L, "Int max +1"}, {42L, "Small Long"}, {42, "Small Int"}, {Float.valueOf(Float.MIN_VALUE), "Float min"}, {Float.valueOf(Float.MAX_VALUE), "Float max"}, {-0.1, "Float min +0.1"}, {3.4028234663852886E38, "Float max +0.1"}, {Float.valueOf(1.34256f), "Float >3 decimal places"}, {Float.valueOf(100.9f), "Small Float"}, {Double.MIN_VALUE, "Double min"}, {Double.MAX_VALUE, "Double max"}, {234.4353453456536, "Double small"}, {241212.34235243543, "Double >3 decimal places"}});
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        try (Tx tx = this.tx();){
            NodeResponse firstResponse = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber(this.num));
            String oldNumber = firstResponse.getVersion();
            NodeResponse secondResponse = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber(this.num));
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
        }
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        try (Tx tx = this.tx();){
            NodeResponse response = this.createNodeWithField();
            NumberFieldImpl numberField = response.getFields().getNumberField("numberField");
            com.gentics.mesh.core.rest.test.Assert.assertNumberValueEquals((Number)this.num, (Number)numberField.getNumber());
        }
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() throws IOException {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNumberField numberField = container.createNumber("numberField");
            numberField.setNumber(this.num);
            tx.success();
        }
        tx = this.tx();
        try {
            NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
            NumberFieldImpl deserializedNumberField = response.getFields().getNumberField("numberField");
            Assert.assertNotNull((Object)deserializedNumberField);
            com.gentics.mesh.core.rest.test.Assert.assertNumberValueEquals((Number)this.num, (Number)deserializedNumberField.getNumber());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Ignore
    public void testUpdateNodeFieldWithField() throws IOException {
    }

    @Override
    @Ignore
    public void testUpdateSetNull() {
    }

    @Override
    @Ignore
    public void testUpdateSetEmpty() {
    }

    @Override
    @Ignore
    public void testCreateNodeWithNoField() {
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode("numberField", (Field)new NumberFieldImpl().setNumber(this.num));
    }
}

