/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.number;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibNumberField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.number.AbstractNumberFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.NodeParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class NumberFieldEndpointTest
extends AbstractNumberFieldEndpointTest {
    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("numberField", null);
        NumberFieldImpl field = response.getFields().getNumberField("numberField");
        Assert.assertNull((String)"The field should be null since we did not specify a field when executing the creation call", (Object)field);
    }

    @Test
    public void testCreateNodeWithWrongFieldType() {
        String fieldKey = "numberField";
        StringField field = new StringFieldImpl().setString("text");
        HibNode node = this.folder("2015");
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setParentNodeUuid(node.getUuid());
        nodeCreateRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        nodeCreateRequest.setLanguage("en");
        nodeCreateRequest.getFields().put(fieldKey, (Field)field);
        ClientHelper.call(() -> this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[]{new NodeParametersImpl().setLanguages(new String[]{"en"})}), (HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (String)"field_number_error_invalid_type", (String[])new String[]{fieldKey, "text"});
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        for (int i = 0; i < 20; ++i) {
            Integer newValue;
            Number oldValue;
            HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
            try (Tx tx2 = this.tx();){
                oldValue = this.getNumberValue(container, "numberField");
                newValue = i + 42;
            }
            NodeResponse response = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)newValue));
            NumberFieldImpl field = response.getFields().getNumberField("numberField");
            Assert.assertEquals((double)((Number)newValue).doubleValue(), (double)field.getNumber().doubleValue(), (double)0.0);
            try (Tx tx3 = this.tx();){
                Assert.assertEquals((String)"Check version number", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", (Object)oldValue, (Object)this.getNumberValue(container, "numberField"));
                continue;
            }
        }
    }

    @Test
    public void testPreciseFloatValue() {
        double value = 0.123456f;
        NodeResponse firstResponse = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)value));
        Number storedNumber = firstResponse.getFields().getNumberField("numberField").getNumber();
        Assert.assertEquals((double)value, (double)storedNumber.doubleValue(), (double)1.0E-7);
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        NodeResponse firstResponse = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)42));
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)42));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        NodeResponse firstResponse = (NodeResponse)this.tx(() -> this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)42)));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = (NodeResponse)this.tx(() -> this.updateNode("numberField", null));
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getNumberField("numberField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getNumber("numberField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getNumber("numberField")).isNotNull();
            Number oldValue = latest.getPreviousVersion().getNumber("numberField").getNumber();
            Assertions.assertThat((double)oldValue.doubleValue()).isEqualTo((Object)42.0);
        }
        NodeResponse thirdResponse = this.updateNode("numberField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        this.updateNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)42));
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        NodeResponse firstResponse = this.updateNode("numberField", (Field)new NumberFieldImpl());
        ((AbstractObjectAssert)Assertions.assertThat((Object)firstResponse.getFields().getNumberField("numberField")).as("Updated Field", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)1.214353));
        NumberFieldImpl numberField = response.getFields().getNumberField("numberField");
        Assert.assertEquals((double)1.214353, (double)numberField.getNumber().doubleValue(), (double)1.0E-8);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() throws IOException {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNumberField numberField = container.createNumber("numberField");
            numberField.setNumber((Number)Float.valueOf(100.9f));
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        NumberFieldImpl deserializedNumberField = response.getFields().getNumberField("numberField");
        Assert.assertNotNull((Object)deserializedNumberField);
        Assert.assertEquals((double)100.9, (double)deserializedNumberField.getNumber().doubleValue(), (double)0.001);
    }

    protected Number getNumberValue(HibNodeFieldContainer container, String fieldName) {
        HibNumberField field = container.getNumber(fieldName);
        return field != null ? (Number)field.getNumber() : (Number)null;
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode("numberField", (Field)new NumberFieldImpl().setNumber((Number)1.214353));
    }
}

