/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.number;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.NumberFieldListImpl;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.Completable;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class NumberFieldListEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "number";
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        NumberFieldListImpl field = response.getFields().getNumberFieldList("listField");
        Assertions.assertThat(field.getItems().stream().map(Number::doubleValue).collect(Collectors.toList())).as("Only valid values should be stored", new Object[0]).containsExactly((Object[])new Double[]{new BigDecimal(42).doubleValue(), new BigDecimal(41).doubleValue(), new BigDecimal(0.1).doubleValue(), new BigDecimal(Long.MAX_VALUE).doubleValue()});
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        NumberFieldListImpl listField = new NumberFieldListImpl();
        listField.add((Object)42);
        listField.add((Object)41);
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        NumberFieldListImpl listField = new NumberFieldListImpl();
        listField.add((Object)42);
        listField.add((Object)41);
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)response.getFields().getNumberFieldList("listField")).as("List field in reponse should be null", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        NumberFieldListImpl listField = new NumberFieldListImpl();
        listField.add((Object)41L);
        listField.add((Object)42L);
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)listField);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        NumberFieldListImpl listField = new NumberFieldListImpl();
        listField.add((Object)41L);
        listField.add((Object)42L);
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        NodeResponse response = this.readNode("dummy", firstResponse.getUuid());
        NumberFieldListImpl deserializedField = response.getFields().getNumberFieldList("listField");
        Assert.assertNotNull((Object)deserializedField);
        Assertions.assertThat(deserializedField.getItems().stream().map(Number::intValue).collect(Collectors.toList())).as("List field values from updated node (null values are omitted)", new Object[0]).containsExactly((Object[])new Integer[]{41, 42});
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() throws IOException {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        List<List> valueCombinations = Arrays.asList(Arrays.asList(1.1, 2, 3), Arrays.asList(3, 2, 1.1), Collections.emptyList(), Arrays.asList(47.11, 8.15), Arrays.asList(3));
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
        for (int i = 0; i < 20; ++i) {
            HibNodeFieldContainer currentContainer = container;
            List oldValue = (List)this.tx(() -> this.getListValues(arg_0 -> ((HibNodeFieldContainer)currentContainer).getNumberList(arg_0), "listField"));
            List newValue = valueCombinations.get(i % valueCombinations.size());
            NumberFieldListImpl list = new NumberFieldListImpl();
            for (Number value : newValue) {
                list.add((Object)value);
            }
            NodeResponse response = this.updateNode("listField", (Field)list);
            NumberFieldListImpl field = response.getFields().getNumberFieldList("listField");
            Assertions.assertThat(field.getItems().stream().map(Number::doubleValue).collect(Collectors.toList())).as("Updated field", new Object[0]).containsExactlyElementsOf((Iterable)list.getItems().stream().map(Number::doubleValue).collect(Collectors.toList()));
            try (Tx tx2 = this.tx();){
                ContentDao contentDao = tx2.contentDao();
                HibNodeFieldContainer newContainerVersion = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                Assert.assertEquals((String)"Check version number", (Object)newContainerVersion.getVersion().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", (Object)oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getNumberList(arg_0), "listField"));
                container = newContainerVersion;
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        NumberFieldListImpl list = new NumberFieldListImpl();
        list.add((Object)42);
        list.add((Object)Float.valueOf(41.1f));
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getNumberFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getNumberList("listField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getNumberList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getNumberList("listField").getList().stream().map(item -> item.getNumber().doubleValue()).collect(Collectors.toList());
            Assertions.assertThat(oldValueList).containsExactly((Object[])new Number[]{42.0, 41.1});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        NumberFieldListImpl list = new NumberFieldListImpl();
        list.add((Object)42);
        list.add((Object)Float.valueOf(41.1f));
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NumberFieldListImpl emptyField = new NumberFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getNumberFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        Assertions.assertThat((List)secondResponse.getFields().getNumberFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Test
    public void testListOrder() throws Exception {
        int elementCount = 50;
        NumberFieldListImpl listField = new NumberFieldListImpl();
        NodeResponse response = this.createNode("listField", (Field)listField);
        this.addNumbers(response, 50).blockingAwait();
        response = (NodeResponse)this.client().findNodeByUuid("dummy", response.getUuid(), new ParameterProvider[0]).toSingle().blockingGet();
        Object[] expected = (Integer[])IntStream.range(0, 50).boxed().toArray(Integer[]::new);
        List actual = response.getFields().getNumberFieldList("listField").getItems().stream().map(Number::intValue).collect(Collectors.toList());
        Assertions.assertThat(actual).containsExactly(expected);
    }

    private Completable addNumbers(NodeResponse node, int count) {
        FieldMap fields = node.getFields();
        NumberFieldListImpl numbers = fields.getNumberFieldList("listField");
        if (numbers.getItems().size() < count) {
            int nr = numbers.getItems().size() == 0 ? 0 : ((Number)numbers.getItems().get(numbers.getItems().size() - 1)).intValue() + 1;
            numbers.add((Object)nr);
            fields.put("listField", (Field)numbers);
            NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest().setFields(fields).setLanguage(node.getLanguage()).setVersion(node.getVersion());
            return this.client().updateNode("dummy", node.getUuid(), nodeUpdateRequest, new ParameterProvider[0]).toSingle().flatMapCompletable(nodeRes -> this.addNumbers((NodeResponse)nodeRes, count));
        }
        return Completable.complete();
    }

    @Override
    public NodeResponse createNodeWithField() {
        NumberFieldListImpl listField = new NumberFieldListImpl();
        listField.add((Object)42L);
        listField.add((Object)41L);
        listField.add((Object)Float.valueOf(0.1f));
        listField.add((Object)Long.MAX_VALUE);
        return this.createNode("listField", (Field)listField);
    }
}

