/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.number;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibNumberField;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.number.NumberFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.NumberFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.NumberFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class NumberFieldTest
extends AbstractFieldTest<NumberFieldSchema> {
    private static final String NUMBER_FIELD = "numberField";

    @Override
    protected NumberFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(NUMBER_FIELD, isRequired);
    }

    protected NumberFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        NumberFieldSchemaImpl numberFieldSchema = new NumberFieldSchemaImpl();
        numberFieldSchema.setName(fieldKey);
        numberFieldSchema.setLabel("Some number field");
        numberFieldSchema.setRequired(isRequired);
        return numberFieldSchema;
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNumberField testField = container.createNumber(NUMBER_FIELD);
            testField.setNumber((Number)4711);
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getNumber(NUMBER_FIELD)).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)testField, new String[]{"parentContainer", "value"});
            Assert.assertEquals((double)otherContainer.getNumber(NUMBER_FIELD).getNumber().doubleValue(), (double)testField.getNumber().doubleValue(), (double)1.0E-4);
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibNumberField numberField = container.createNumber(NUMBER_FIELD);
            Assert.assertEquals((Object)NUMBER_FIELD, (Object)numberField.getFieldKey());
            numberField.setNumber((Number)42);
            Assert.assertEquals((long)42L, (long)numberField.getNumber().intValue());
            HibStringField bogusField1 = container.getString("bogus");
            Assert.assertNull((Object)bogusField1);
            HibNumberField reloadedNumberField = container.getNumber(NUMBER_FIELD);
            Assert.assertNotNull((Object)reloadedNumberField);
            Assert.assertEquals((Object)NUMBER_FIELD, (Object)reloadedNumberField.getFieldKey());
        }
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            NumberFieldSchemaImpl numberFieldSchema = new NumberFieldSchemaImpl();
            numberFieldSchema.setName(NUMBER_FIELD);
            numberFieldSchema.setRequired(true);
            this.prepareTypedSchema(node, (FieldSchema)numberFieldSchema, false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibNumberField numberField = container.createNumber(NUMBER_FIELD);
            numberField.setNumber((Number)Float.valueOf(100.9f));
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertTrue((String)("Could not find number within json. Json {" + json + "}"), (json.indexOf("100.9") > 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            NumberFieldImpl deserializedNumberField = response.getFields().getNumberField(NUMBER_FIELD);
            Assert.assertEquals((double)100.9, (double)deserializedNumberField.getNumber().doubleValue(), (double)0.01);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true), this.createFieldSchema("numberField_2", true)});
            Long number = System.currentTimeMillis();
            HibNumberField fieldA = container.createNumber(NUMBER_FIELD);
            HibNumberField fieldB = container.createNumber("numberField_2");
            fieldA.setNumber((Number)number);
            fieldB.setNumber((Number)number);
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true), this.createFieldSchema("numberField_2", true)});
            HibNumberField fieldA = container.createNumber(NUMBER_FIELD);
            HibNumberField fieldB = container.createNumber("numberField_2");
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            Long number = System.currentTimeMillis();
            HibNumberField fieldA = container.createNumber(NUMBER_FIELD);
            NumberFieldImpl restField = new NumberFieldImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.setNumber((Number)number);
            restField.setNumber((Number)(number + 1L));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.setNumber((Number)number);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(new StringFieldImpl().setString(String.valueOf(number))));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(NUMBER_FIELD, NumberFieldTestHelper.FETCH, NumberFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(NUMBER_FIELD, NumberFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(NUMBER_FIELD, NumberFieldTestHelper.FETCH, NumberFieldTestHelper.FILL, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, NUMBER_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(NUMBER_FIELD, NumberFieldTestHelper.FETCH, NumberFieldTestHelper.FILL, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, NUMBER_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(NUMBER_FIELD, NumberFieldTestHelper.FILL, container -> {
                NumberFieldImpl field = new NumberFieldImpl();
                field.setNumber((Number)42L);
                this.updateContainer(ac, (HibNodeFieldContainer)container, NUMBER_FIELD, (Field)field);
            }, container -> {
                HibNumberField field = container.getNumber(NUMBER_FIELD);
                Assert.assertNotNull((String)"The graph field {numberField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The html of the field was not updated.", (long)42L, (long)field.getNumber().longValue());
            });
        }
    }
}

