/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.s3binary;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.common.GenericMessageResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.s3binary.S3BinaryMetadataRequest;
import com.gentics.mesh.core.rest.node.field.s3binary.S3BinaryUploadRequest;
import com.gentics.mesh.core.rest.node.field.s3binary.S3RestResponse;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangeModel;
import com.gentics.mesh.core.rest.schema.change.impl.SchemaChangesListModel;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.ImageManipulationParametersImpl;
import com.gentics.mesh.rest.client.MeshBinaryResponse;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.ElasticsearchTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import io.vertx.core.json.JsonObject;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, startServer=true, elasticsearch=ElasticsearchTestMode.CONTAINER_ES7)
public class S3BinaryFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "s3";
    private static final S3BinaryUploadRequest UPLOAD_REQUEST = new S3BinaryUploadRequest().setFilename("test.jpg").setLanguage("en").setVersion("1.0");
    private static final S3BinaryMetadataRequest METADATA_REQUEST = new S3BinaryMetadataRequest().setLanguage("en").setVersion("1.1");

    @Before
    public void updateSchema() throws IOException {
        HibSchema schemaContainer = this.schemaContainer("content");
        String schemaUuid = (String)this.tx(() -> schemaContainer.getUuid());
        HibSchemaVersion currentVersion = (HibSchemaVersion)this.tx(() -> (HibSchemaVersion)schemaContainer.getLatestVersion());
        Assert.assertNull((String)"The schema should not yet have any changes", this.tx(() -> currentVersion.getNextChange()));
        SchemaChangesListModel listOfChanges = new SchemaChangesListModel();
        JsonObject elasticSearch = new JsonObject().put("test", (Object)"test");
        SchemaChangeModel change = SchemaChangeModel.createAddFieldChange((String)FIELD_NAME, (String)"s3binary", (String)"Some label", (JsonObject)elasticSearch);
        listOfChanges.getChanges().add(change);
        GenericMessageResponse status = (GenericMessageResponse)ClientHelper.call(() -> this.client().applyChangesToSchema(schemaUuid, listOfChanges));
        MeshAssertions.assertThat((GenericMessageResponse)status).matches("schema_changes_applied", new String[]{"content"});
        SchemaResponse updatedSchema = (SchemaResponse)ClientHelper.call(() -> this.client().findSchemaByUuid(schemaUuid, new ParameterProvider[0]));
        this.waitForJobs(() -> ClientHelper.call(() -> this.client().assignBranchSchemaVersions("dummy", this.initialBranchUuid(), new SchemaReference[]{((SchemaReference)new SchemaReferenceImpl().setName("content")).setVersion(updatedSchema.getVersion())})), JobStatus.COMPLETED, 1);
    }

    @Override
    public void testReadNodeWithExistingField() throws IOException {
    }

    @Override
    public void testUpdateNodeFieldWithField() throws IOException {
    }

    @Override
    public void testUpdateSameValue() {
    }

    @Override
    public void testUpdateSetNull() {
    }

    @Override
    public void testUpdateSetEmpty() {
    }

    @Override
    public void testCreateNodeWithField() {
    }

    @Override
    public void testCreateNodeWithNoField() {
    }

    @Override
    public NodeResponse createNodeWithField() {
        String parentUuid = (String)this.tx(() -> this.folder("2015").getUuid());
        this.grantAdmin();
        NodeCreateRequest nodeCreateRequest = new NodeCreateRequest();
        nodeCreateRequest.setLanguage("en").setParentNodeUuid(parentUuid).setSchemaName("content");
        nodeCreateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"folder1"));
        nodeCreateRequest.getFields().put("title", (Field)FieldUtil.createStringField((String)"folder2"));
        nodeCreateRequest.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"folder2"));
        NodeResponse nodeResponse = (NodeResponse)this.client().createNode("dummy", nodeCreateRequest, new ParameterProvider[0]).blockingGet();
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeResponse.getUuid(), new ParameterProvider[0]));
        return nodeResponse;
    }

    @Test
    public void testDownloadBinary() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
        File tempFile = this.createTempFile();
        this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
        this.s3BinaryStorage().uploadFile("test-bucket", s3binaryNode.getUuid() + "/s3", tempFile, false).blockingGet();
        this.s3BinaryStorage().exists("test-bucket", s3binaryNode.getUuid() + "/s3").blockingGet();
        MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", s3binaryNode.getUuid(), "en", FIELD_NAME, new ParameterProvider[0]));
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"image/jpeg", (Object)response.getContentType());
        response.close();
    }

    @Test
    public void testExtractMetadataSuccessful() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
        File tempFile = this.createTempFile();
        this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
        this.s3BinaryStorage().createBucket("test-cache-bucket").blockingGet();
        this.s3BinaryStorage().uploadFile("test-bucket", s3binaryNode.getUuid() + "/s3", tempFile, false).blockingGet();
        NodeResponse s3 = (NodeResponse)ClientHelper.call(() -> this.client().extractMetadataNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, METADATA_REQUEST, new ParameterProvider[0]));
        Assert.assertEquals((Object)"test.jpg", (Object)s3.getFields().getS3BinaryField(FIELD_NAME).getFileName());
        Assert.assertEquals((Object)"image/jpeg", (Object)s3.getFields().getS3BinaryField(FIELD_NAME).getMimeType());
        Assert.assertEquals((long)1376L, (long)s3.getFields().getS3BinaryField(FIELD_NAME).getHeight().intValue());
    }

    @Test
    public void testExtractMetadataNoFileUploadedShouldFail() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
        this.createTempFile();
        this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
        this.s3BinaryStorage().createBucket("test-cache-bucket").blockingGet();
        try {
            this.client().extractMetadataNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, METADATA_REQUEST, new ParameterProvider[0]).blockingGet();
            Assert.fail((String)"This test muste fail because of no file provided for an upload.");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof RuntimeException));
        }
    }

    @Test
    public void testDownloadBinaryWithParams() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        BufferedImage buf = null;
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
        File tempFile = this.createTempFile();
        this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
        this.s3BinaryStorage().createBucket("test-cache-bucket").blockingGet();
        this.s3BinaryStorage().uploadFile("test-bucket", s3binaryNode.getUuid() + "/s3", tempFile, false).blockingGet();
        this.s3BinaryStorage().exists("test-bucket", s3binaryNode.getUuid() + "/s3").blockingGet();
        ClientHelper.call(() -> this.client().extractMetadataNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, METADATA_REQUEST, new ParameterProvider[0]));
        MeshBinaryResponse response = (MeshBinaryResponse)ClientHelper.call(() -> this.client().downloadBinaryField("dummy", s3binaryNode.getUuid(), "en", FIELD_NAME, new ParameterProvider[]{new ImageManipulationParametersImpl().setWidth(Integer.valueOf(100))}));
        Assert.assertNotNull((Object)response);
        try {
            byte[] downloadBytes = IOUtils.toByteArray((InputStream)response.getStream());
            ByteArrayInputStream in = new ByteArrayInputStream(downloadBytes);
            buf = ImageIO.read(in);
        }
        catch (IOException ioException) {
            Assert.fail();
        }
        Assert.assertEquals((Object)"image/jpeg", (Object)response.getContentType());
        Assert.assertEquals((long)100L, (long)buf.getWidth());
        response.close();
    }

    @Test
    public void testTransformS3BinarySuccessful() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
        File tempFile = this.createTempFile();
        this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
        this.s3BinaryStorage().createBucket("test-cache-bucket").blockingGet();
        this.s3BinaryStorage().uploadFile("test-bucket", s3binaryNode.getUuid() + "/s3", tempFile, false).blockingGet();
        this.client().extractMetadataNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, METADATA_REQUEST, new ParameterProvider[0]).blockingGet();
        NodeResponse call = (NodeResponse)ClientHelper.call(() -> this.client().transformNodeBinaryField("dummy", s3binaryNode.getUuid(), "en", "1.0", FIELD_NAME, new ImageManipulationParametersImpl().setWidth(Integer.valueOf(250))));
        Assert.assertNotNull((Object)call);
        Assert.assertEquals((long)250L, (long)call.getFields().getS3BinaryField(FIELD_NAME).getWidth().intValue());
    }

    @Test
    public void testUploadWorking() {
        S3RestResponse s3RestResponse = new S3RestResponse();
        s3RestResponse.setVersion("1");
        NodeResponse s3binaryNode = this.createNodeWithField();
        S3RestResponse s3RestResponse1 = null;
        try (Tx tx = this.tx();){
            ClientHelper.call(() -> this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, UPLOAD_REQUEST, new ParameterProvider[0]));
            File tempFile = this.createTempFile();
            this.s3BinaryStorage().createBucket("test-bucket").blockingGet();
            s3RestResponse1 = (S3RestResponse)this.s3BinaryStorage().uploadFile("test-bucket", s3binaryNode.getUuid() + "/s3", tempFile, false).blockingGet();
        }
        Boolean doesObjectExists = (Boolean)this.s3BinaryStorage().exists("test-bucket", s3binaryNode.getUuid() + "/s3").blockingGet();
        Assert.assertTrue((boolean)doesObjectExists);
        Assert.assertNotNull((Object)s3RestResponse1);
    }

    @Test
    public void testUploadEmptyFilename() {
        NodeResponse s3binaryNode = this.createNodeWithField();
        S3BinaryUploadRequest request = new S3BinaryUploadRequest().setFilename("").setLanguage("en").setVersion("1.0");
        try {
            this.client().updateNodeS3BinaryField("dummy", s3binaryNode.getUuid(), FIELD_NAME, request, new ParameterProvider[0]).blockingAwait();
            Assert.fail((String)"Empty file name should not pass");
        }
        catch (Exception e) {
            Assert.assertTrue((e.getMessage().indexOf("Error:400 in POST") > -1 ? 1 : 0) != 0);
        }
    }
}

