/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.s3binary;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.s3binary.S3HibBinary;
import com.gentics.mesh.core.data.s3binary.S3HibBinaryField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.binary.BinaryFieldTestHelper;
import com.gentics.mesh.core.field.s3binary.S3BinaryFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.S3BinaryField;
import com.gentics.mesh.core.rest.node.field.impl.S3BinaryFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.S3BinaryFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.AWSTestMode;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import com.gentics.mesh.util.UUIDUtil;
import com.gentics.mesh.util.VersionNumber;
import java.util.UUID;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(awsContainer=AWSTestMode.MINIO, testSize=TestSize.PROJECT_AND_NODE)
public class S3BinaryFieldTest
extends AbstractFieldTest<S3BinaryFieldSchema> {
    private static final String S3_BINARY_FIELD = "s3binaryField";

    @Override
    protected S3BinaryFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(S3_BINARY_FIELD, isRequired);
    }

    protected S3BinaryFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        S3BinaryFieldSchemaImpl s3binaryFieldSchema = new S3BinaryFieldSchemaImpl();
        s3binaryFieldSchema.setName(fieldKey);
        s3binaryFieldSchema.setRequired(isRequired);
        return s3binaryFieldSchema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareTypedSchema(node, (FieldSchema)this.createFieldSchema(true), false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUIDUtil.randomUUID(), node.getUuid() + "/s3", "test.jpg").runInExistingTx(tx);
            S3HibBinaryField field = container.createS3Binary(S3_BINARY_FIELD, s3binary);
            field.setMimeType("image/jpg");
            s3binary.setImageHeight(Integer.valueOf(200));
            s3binary.setImageWidth(Integer.valueOf(300));
            tx.success();
        }
        String json = (String)this.tx(() -> this.getJson(this.folder("2015")));
        Assert.assertNotNull((Object)json);
        NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
        Assert.assertNotNull((Object)response);
        S3BinaryField deserializedNodeField = response.getFields().getS3BinaryField(S3_BINARY_FIELD);
        Assert.assertNotNull((Object)deserializedNodeField);
        Assert.assertEquals((Object)"test.jpg", (Object)deserializedNodeField.getFileName());
        Assert.assertEquals((long)200L, (long)deserializedNodeField.getHeight().intValue());
        Assert.assertEquals((long)300L, (long)deserializedNodeField.getWidth().intValue());
    }

    @Override
    @Test
    public void testFieldUpdate() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUID.randomUUID().toString(), "1234/s3", "img.jpg").runInExistingTx(tx);
            S3HibBinaryField field = container.createS3Binary(S3_BINARY_FIELD, s3binary);
            field.getBinary().setSize(220L);
            Assert.assertNotNull((Object)field);
            Assert.assertEquals((Object)S3_BINARY_FIELD, (Object)field.getFieldKey());
            field.setFileName("blume.jpg");
            field.setMimeType("image/jpg");
            field.setImageDominantColor("#22A7F0");
            field.getBinary().setImageHeight(Integer.valueOf(133));
            field.getBinary().setImageWidth(Integer.valueOf(7));
            S3HibBinaryField loadedField = container.getS3Binary(S3_BINARY_FIELD);
            S3HibBinary loadedS3Binary = loadedField.getBinary();
            Assert.assertNotNull((String)"The previously created field could not be found.", (Object)loadedField);
            Assert.assertEquals((long)220L, (long)loadedS3Binary.getSize());
            Assert.assertEquals((Object)"blume.jpg", (Object)loadedField.getFileName());
            Assert.assertEquals((Object)"image/jpg", (Object)loadedField.getMimeType());
            Assert.assertEquals((Object)"#22A7F0", (Object)loadedField.getImageDominantColor());
            Assert.assertEquals((long)133L, (long)loadedField.getBinary().getImageHeight().intValue());
            Assert.assertEquals((long)7L, (long)loadedField.getBinary().getImageWidth().intValue());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUID.randomUUID().toString(), "1234/s3", "img.jg").runInExistingTx(tx);
            S3HibBinaryField field = container.createS3Binary(S3_BINARY_FIELD, s3binary);
            field.getBinary().setSize(220L);
            Assert.assertNotNull((Object)field);
            Assert.assertEquals((Object)S3_BINARY_FIELD, (Object)field.getFieldKey());
            field.setFileName("blume.jpg");
            field.setMimeType("image/jpg");
            field.setImageDominantColor("#22A7F0");
            field.getBinary().setImageHeight(Integer.valueOf(133));
            field.getBinary().setImageWidth(Integer.valueOf(7));
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            field.cloneTo((HibFieldContainer)otherContainer);
            S3HibBinaryField clonedField = otherContainer.getS3Binary(S3_BINARY_FIELD);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)clonedField).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)field, new String[]{"outV", "id", "uuid", "element", "contentUuid", "dbUuid", "value", "parentContainer"});
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)clonedField.getBinary()).as("referenced binary of cloned field", new Object[0])).isNotNull()).isEqualToComparingFieldByField((Object)field.getBinary());
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            S3HibBinary s3binaryA = (S3HibBinary)tx.s3binaries().create(UUID.randomUUID().toString(), "1234/s3", "img.jg").runInExistingTx(tx);
            S3HibBinary s3binaryB = (S3HibBinary)tx.s3binaries().create(UUID.randomUUID().toString(), "1234/s3", "img.jg").runInExistingTx(tx);
            S3HibBinaryField fieldA = container.createS3Binary("fieldA", s3binaryA);
            S3HibBinaryField fieldB = container.createS3Binary("fieldB", s3binaryB);
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.setFileName("someText");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.setFileName("someText");
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUIDUtil.randomUUID(), "/s3", "img.jpg").runInExistingTx(tx);
            S3HibBinaryField fieldA = container.createS3Binary(S3_BINARY_FIELD, s3binary);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            tx.contentDao().setVersion(container, new VersionNumber(2, 1));
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUID.randomUUID().toString(), container.getUuid() + "/s3", "img.jpg").runInExistingTx(tx);
            S3HibBinaryField fieldA = container.createS3Binary(S3_BINARY_FIELD, s3binary);
            Assert.assertTrue((String)"The field should be equal to the html rest field since both fields have no value.", (boolean)fieldA.equals(new S3BinaryFieldImpl()));
            fieldA.setFileName("someText");
            Assert.assertFalse((String)"The field should not be equal to a string rest field. Even if it has the same value", (boolean)fieldA.equals(new StringFieldImpl().setString("someText")));
            Assert.assertFalse((String)"The field should not be equal to the rest field since the rest field has a different value.", (boolean)fieldA.equals(new S3BinaryFieldImpl().setFileName("blub")));
            Assert.assertTrue((String)"The binary field filename value should be equal to a rest field with the same value", (boolean)fieldA.equals(new S3BinaryFieldImpl().setFileName("someText")));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(S3_BINARY_FIELD, S3BinaryFieldTestHelper.FETCH, BinaryFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(S3_BINARY_FIELD, S3BinaryFieldTestHelper.FETCH, false);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(S3_BINARY_FIELD, S3BinaryFieldTestHelper.FETCH, S3BinaryFieldTestHelper.FILL_BASIC, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, S3_BINARY_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(S3_BINARY_FIELD, S3BinaryFieldTestHelper.FETCH, S3BinaryFieldTestHelper.FILL_BASIC, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, S3_BINARY_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(S3_BINARY_FIELD, S3BinaryFieldTestHelper.FILL_BASIC, container -> {
                S3BinaryFieldImpl field = new S3BinaryFieldImpl();
                field.setFileName("someFile.txt");
                this.updateContainer(ac, (HibNodeFieldContainer)container, S3_BINARY_FIELD, (Field)field);
            }, container -> {
                S3HibBinaryField field = container.getS3Binary(S3_BINARY_FIELD);
                Assert.assertNotNull((String)"The graph field {s3binaryField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The html of the field was not updated.", (Object)"someFile.txt", (Object)field.getFileName());
            });
        }
    }
}

