/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.string;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.category.FailingTests;
import com.gentics.mesh.util.VersionNumber;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class StringFieldEndpointTest
extends AbstractFieldEndpointTest {
    private static final String FIELD_NAME = "stringField";

    @Before
    public void updateSchema() throws IOException {
        try (Tx tx = this.tx();){
            StringFieldSchemaImpl stringFieldSchema = new StringFieldSchemaImpl();
            stringFieldSchema.setName(FIELD_NAME);
            stringFieldSchema.setLabel("Some label");
            StringFieldSchemaImpl restrictedStringFieldSchema = new StringFieldSchemaImpl();
            restrictedStringFieldSchema.setName("restrictedstringField");
            restrictedStringFieldSchema.setLabel("Some label");
            restrictedStringFieldSchema.setAllowedValues(new String[]{"one", "two", "three"});
            this.prepareTypedSchema(this.schemaContainer("folder"), List.of(stringFieldSchema, restrictedStringFieldSchema), Optional.empty());
            tx.success();
        }
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode(null, null);
        StringFieldImpl stringField = response.getFields().getStringField(FIELD_NAME);
        Assert.assertNull((Object)stringField);
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() {
        for (int i = 0; i < 20; ++i) {
            VersionNumber oldVersion = (VersionNumber)this.tx(tx -> tx.contentDao().getFieldContainer(this.folder("2015"), "en").getVersion());
            String newValue = "content " + i;
            NodeResponse response = this.updateNode(FIELD_NAME, (Field)new StringFieldImpl().setString(newValue));
            StringFieldImpl field = response.getFields().getStringField(FIELD_NAME);
            Assert.assertEquals((Object)newValue, (Object)field.getString());
            Assert.assertEquals((String)"Check version number", (Object)oldVersion.nextDraft().toString(), (Object)response.getVersion());
        }
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new StringFieldImpl().setString("bla"));
        String oldNumber = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)new StringFieldImpl().setString("bla"));
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldNumber);
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new StringFieldImpl().setString("bla"));
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getStringField(FIELD_NAME)).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getString(FIELD_NAME)).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getString(FIELD_NAME)).isNotNull();
            String oldValue = latest.getPreviousVersion().getString(FIELD_NAME).getString();
            Assertions.assertThat((String)oldValue).isEqualTo((Object)"bla");
        }
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    @Category(value={FailingTests.class})
    @Deprecated(forRemoval=true)
    public void testUpdateSetEmpty() {
        NodeResponse firstResponse = this.updateNode(FIELD_NAME, (Field)new StringFieldImpl().setString("bla"));
        StringFieldImpl emptyField = new StringFieldImpl();
        emptyField.setString("");
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getStringField(FIELD_NAME)).as("Updated Field", new Object[0])).isNotNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getFields().getStringField(FIELD_NAME).getString()).as("Updated Field Value", new Object[0])).isEqualTo((Object)"");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode(FIELD_NAME, (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    protected String getStringValue(HibNodeFieldContainer container, String fieldName) {
        HibStringField field = container.getString(fieldName);
        return field != null ? field.getString() : null;
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        StringFieldImpl field = response.getFields().getStringField(FIELD_NAME);
        Assert.assertEquals((Object)"someString", (Object)field.getString());
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        try (Tx tx = this.tx();){
            HibNode node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibStringField stringField = container.createString(FIELD_NAME);
            stringField.setString("someString");
            tx.success();
        }
        NodeResponse response = this.readNode(this.folder("2015"), new String[0]);
        StringFieldImpl deserializedStringField = response.getFields().getStringField(FIELD_NAME);
        Assert.assertNotNull((Object)deserializedStringField);
        Assert.assertEquals((Object)"someString", (Object)deserializedStringField.getString());
    }

    @Test
    public void testValueRestrictionValidValue() {
        NodeResponse response = this.updateNode("restrictedstringField", (Field)new StringFieldImpl().setString("two"));
        StringFieldImpl field = response.getFields().getStringField("restrictedstringField");
        Assert.assertEquals((Object)"two", (Object)field.getString());
    }

    @Test
    public void testValueRestrictionInvalidValue() {
        this.updateNodeFailure("restrictedstringField", (Field)new StringFieldImpl().setString("invalid"), HttpResponseStatus.BAD_REQUEST, "node_error_invalid_string_field_value", "restrictedstringField", "invalid");
    }

    @Test
    public void testValueRemoveValueRestrictions() {
        try (Tx tx = this.tx();){
            SchemaVersionModel schema = ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).getSchema();
            StringFieldSchema restrictedStringFieldSchema = (StringFieldSchema)schema.getField("restrictedstringField", StringFieldSchema.class);
            restrictedStringFieldSchema.setAllowedValues(new String[0]);
            ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).setSchema(schema);
            tx.success();
        }
        NodeResponse response = this.updateNode("restrictedstringField", (Field)new StringFieldImpl().setString("million"));
        StringFieldImpl field = response.getFields().getStringField("restrictedstringField");
        Assert.assertEquals((Object)"million", (Object)field.getString());
    }

    @Override
    public NodeResponse createNodeWithField() {
        return this.createNode(FIELD_NAME, (Field)new StringFieldImpl().setString("someString"));
    }
}

