/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.string;

import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractListFieldEndpointTest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=true)
public class StringFieldListEndpointTest
extends AbstractListFieldEndpointTest {
    @Override
    public String getListFieldType() {
        return "string";
    }

    @Override
    @Test
    public void testCreateNodeWithField() {
        NodeResponse response = this.createNodeWithField();
        StringFieldListImpl field = response.getFields().getStringFieldList("listField");
        Assertions.assertThat((List)field.getItems()).as("Only valid values should be stored", new Object[0]).containsExactly((Object[])new String[]{"A", "B"});
    }

    @Override
    @Test
    public void testNullValueInListOnCreate() {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add(null);
        this.createNodeAndExpectFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testNullValueInListOnUpdate() {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add(null);
        this.updateNodeFailure("listField", (Field)listField, HttpResponseStatus.BAD_REQUEST, "field_list_error_null_not_allowed", "listField");
    }

    @Override
    @Test
    public void testCreateNodeWithNoField() {
        NodeResponse response = this.createNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)response.getFields().getStringFieldList("listField")).as("List field in reponse should be null", new Object[0])).isNull();
    }

    @Override
    @Test
    public void testUpdateSameValue() {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", (Field)listField);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number", new Object[0])).isEqualTo((Object)oldVersion);
    }

    @Override
    @Test
    public void testReadNodeWithExistingField() {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        NodeResponse firstResponse = this.updateNode("listField", (Field)listField);
        NodeResponse response = this.readNode("dummy", firstResponse.getUuid());
        StringFieldListImpl deserializedField = response.getFields().getStringFieldList("listField");
        Assert.assertNotNull((Object)deserializedField);
        Assertions.assertThat((List)deserializedField.getItems()).as("List field values from updated node", new Object[0]).containsExactly((Object[])new String[]{"A", "B"});
    }

    @Test
    public void testCreateNodeWithNullFieldValue() throws IOException {
        NodeResponse response = this.createNode("listField", null);
        StringFieldListImpl nodeField = response.getFields().getStringFieldList("listField");
        Assert.assertNull((String)"No string field should have been created.", (Object)nodeField);
    }

    @Test
    public void testCreateEmptyStringList() throws IOException {
        StringFieldListImpl listField = new StringFieldListImpl();
        NodeResponse response = this.createNode("listField", (Field)listField);
        StringFieldListImpl listFromResponse = response.getFields().getStringFieldList("listField");
        Assert.assertEquals((long)0L, (long)listFromResponse.getItems().size());
    }

    @Test
    public void testCreateNullStringList() throws IOException {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.setItems(null);
        NodeResponse response = this.createNode("listField", (Field)listField);
        StringFieldListImpl listFromResponse = response.getFields().getStringFieldList("listField");
        Assert.assertNull((String)"The string list should be null since the request was sending null instead of an array.", (Object)listFromResponse);
    }

    @Test
    public void testStringList() throws IOException {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        listField.add((Object)"C");
        NodeResponse response = this.createNode("listField", (Field)listField);
        StringFieldListImpl listFromResponse = response.getFields().getStringFieldList("listField");
        Assert.assertEquals((long)3L, (long)listFromResponse.getItems().size());
        Assert.assertEquals((Object)Arrays.asList("A", "B", "C").toString(), (Object)listFromResponse.getItems().toString());
    }

    @Override
    @Test
    public void testUpdateNodeFieldWithField() throws IOException {
        this.disableAutoPurge();
        HibNode node = this.folder("2015");
        List<List> valueCombinations = Arrays.asList(Arrays.asList("A", "B", "C"), Arrays.asList("C", "B", "A"), Collections.emptyList(), Arrays.asList("X", "Y"), Arrays.asList("C"));
        HibNodeFieldContainer container = (HibNodeFieldContainer)this.tx(tx -> tx.contentDao().getFieldContainer(node, "en"));
        for (int i = 0; i < 20; ++i) {
            List newValue;
            List oldValue;
            StringFieldListImpl list = new StringFieldListImpl();
            try (Tx tx2 = this.tx();){
                oldValue = this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getStringList(arg_0), "listField");
                newValue = valueCombinations.get(i % valueCombinations.size());
                for (String value : newValue) {
                    list.add((Object)value);
                }
            }
            NodeResponse response = this.updateNode("listField", (Field)list);
            StringFieldListImpl field = response.getFields().getStringFieldList("listField");
            Assertions.assertThat((List)field.getItems()).as("Updated field", new Object[0]).containsExactlyElementsOf((Iterable)list.getItems());
            try (Tx tx3 = this.tx();){
                ContentDao contentDao = tx3.contentDao();
                HibNodeFieldContainer newContainerVersion = (HibNodeFieldContainer)contentDao.getNextVersions(container).iterator().next();
                Assert.assertEquals((String)"The old container version did not match", (Object)container.getVersion().nextDraft().toString(), (Object)response.getVersion().toString());
                Assert.assertEquals((String)"Check version number", (Object)newContainerVersion.getVersion().toString(), (Object)response.getVersion());
                Assert.assertEquals((String)"Check old value", oldValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)container).getStringList(arg_0), "listField"));
                Assert.assertEquals((String)"Check new value", (Object)newValue, this.getListValues(arg_0 -> ((HibNodeFieldContainer)newContainerVersion).getStringList(arg_0), "listField"));
                container = newContainerVersion;
                continue;
            }
        }
    }

    @Override
    @Test
    public void testUpdateSetNull() {
        this.disableAutoPurge();
        StringFieldListImpl list = new StringFieldListImpl();
        list.add((Object)"A");
        list.add((Object)"B");
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        NodeResponse secondResponse = this.updateNode("listField", null);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getStringFieldList("listField")).as("Updated Field", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)oldVersion).as("Version should be updated", new Object[0])).isNotEqualTo((Object)secondResponse.getVersion());
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            HibNodeFieldContainer latest = contentDao.getLatestDraftFieldContainer(node, this.english());
            Assertions.assertThat((String)latest.getVersion().toString()).isEqualTo((Object)secondResponse.getVersion());
            Assertions.assertThat((Object)latest.getStringList("listField")).isNull();
            Assertions.assertThat((Object)latest.getPreviousVersion().getStringList("listField")).isNotNull();
            List oldValueList = latest.getPreviousVersion().getStringList("listField").getList().stream().map(item -> item.getString()).collect(Collectors.toList());
            Assertions.assertThat(oldValueList).containsExactly((Object[])new String[]{"A", "B"});
        }
        NodeResponse thirdResponse = this.updateNode("listField", null);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
    }

    @Override
    @Test
    public void testUpdateSetEmpty() {
        StringFieldListImpl list = new StringFieldListImpl();
        list.add((Object)"A");
        list.add((Object)"B");
        NodeResponse firstResponse = this.updateNode("listField", (Field)list);
        String oldVersion = firstResponse.getVersion();
        StringFieldListImpl emptyField = new StringFieldListImpl();
        NodeResponse secondResponse = this.updateNode("listField", (Field)emptyField);
        ((AbstractObjectAssert)Assertions.assertThat((Object)secondResponse.getFields().getStringFieldList("listField")).as("Updated field list", new Object[0])).isNotNull();
        Assertions.assertThat((List)secondResponse.getFields().getStringFieldList("listField").getItems()).as("Field value should be truncated", new Object[0]).isEmpty();
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("New version number should be generated", new Object[0])).isNotEqualTo((Object)oldVersion);
        NodeResponse thirdResponse = this.updateNode("listField", (Field)emptyField);
        Assert.assertEquals((String)"The field does not change and thus the version should not be bumped.", (Object)thirdResponse.getVersion(), (Object)secondResponse.getVersion());
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)secondResponse.getVersion()).as("No new version number should be generated", new Object[0])).isEqualTo((Object)secondResponse.getVersion());
    }

    @Override
    public NodeResponse createNodeWithField() {
        StringFieldListImpl listField = new StringFieldListImpl();
        listField.add((Object)"A");
        listField.add((Object)"B");
        return this.createNode("listField", (Field)listField);
    }
}

