/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.string;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.string.StringFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.StringFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.json.JsonUtil;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class StringFieldTest
extends AbstractFieldTest<StringFieldSchema> {
    private static final String STRING_FIELD = "stringField";

    @Override
    protected StringFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(STRING_FIELD, isRequired);
    }

    protected StringFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        StringFieldSchemaImpl schema = new StringFieldSchemaImpl();
        schema.setLabel("Some string field");
        schema.setRequired(isRequired);
        schema.setName(fieldKey);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        try (Tx tx = this.tx();){
            ContentDao contentDao = tx.contentDao();
            HibNode node = this.folder("2015");
            StringFieldSchemaImpl stringFieldSchema = new StringFieldSchemaImpl();
            stringFieldSchema.setName(STRING_FIELD);
            stringFieldSchema.setLabel("Some string field");
            stringFieldSchema.setRequired(true);
            this.prepareTypedSchema(node, (FieldSchema)stringFieldSchema, false);
            tx.commit();
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibStringField field = container.createString(STRING_FIELD);
            field.setString("someString");
            tx.success();
        }
        tx = this.tx();
        try {
            HibNode node = this.folder("2015");
            String json = this.getJson(node);
            Assert.assertTrue((String)("The json should contain the string but it did not.{" + json + "}"), (json.indexOf("someString") > 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)json);
            NodeResponse response = (NodeResponse)JsonUtil.readValue((String)json, NodeResponse.class);
            Assert.assertNotNull((Object)response);
            StringFieldImpl deserializedNodeField = response.getFields().getStringField(STRING_FIELD);
            Assert.assertNotNull((Object)deserializedNodeField);
            Assert.assertEquals((Object)"someString", (Object)deserializedNodeField.getString());
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibStringField testField = container.createString(STRING_FIELD);
            testField.setString("this is the string");
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            ((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)otherContainer.getString(STRING_FIELD)).as("cloned field", new Object[0])).isNotNull()).isEqualToIgnoringGivenFields((Object)testField, new String[]{"parentContainer"});
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibStringField stringField = container.createString(STRING_FIELD);
            Assert.assertEquals((Object)STRING_FIELD, (Object)stringField.getFieldKey());
            stringField.setString("dummyString");
            Assert.assertEquals((Object)"dummyString", (Object)stringField.getString());
            HibStringField bogusField1 = container.getString("bogus");
            Assert.assertNull((Object)bogusField1);
            HibStringField reloadedStringField = container.getString(STRING_FIELD);
            Assert.assertNotNull((Object)reloadedStringField);
            Assert.assertEquals((Object)STRING_FIELD, (Object)reloadedStringField.getFieldKey());
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true), this.createFieldSchema("stringField_2", false)});
            String testValue = "test123";
            HibStringField fieldA = container.createString(STRING_FIELD);
            HibStringField fieldB = container.createString("stringField_2");
            fieldA.setString(testValue);
            fieldB.setString(testValue);
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true), this.createFieldSchema("stringField_2", false)});
            HibStringField fieldA = container.createString(STRING_FIELD);
            HibStringField fieldB = container.createString("stringField_2");
            Assert.assertTrue((String)"Both fields should be equal to eachother", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            String dummyValue = "test123";
            HibStringField fieldA = container.createString(STRING_FIELD);
            StringFieldImpl restField = new StringFieldImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.setString(dummyValue);
            restField.setString(dummyValue + "1");
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.setString(dummyValue);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(new HtmlFieldImpl().setHTML(dummyValue)));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(STRING_FIELD, StringFieldTestHelper.FETCH, StringFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(STRING_FIELD, StringFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(STRING_FIELD, StringFieldTestHelper.FETCH, StringFieldTestHelper.FILLTEXT, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, STRING_FIELD, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(STRING_FIELD, StringFieldTestHelper.FETCH, StringFieldTestHelper.FILLTEXT, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, STRING_FIELD, null));
        }
    }

    @Test
    public void testRemoveSegmentField() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveSegmentFieldViaNullTestcase(STRING_FIELD, StringFieldTestHelper.FETCH, StringFieldTestHelper.FILLTEXT, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, STRING_FIELD, null));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(STRING_FIELD, StringFieldTestHelper.FILLTEXT, container -> {
                StringFieldImpl field = new StringFieldImpl();
                field.setString("someValue");
                this.updateContainer(ac, (HibNodeFieldContainer)container, STRING_FIELD, (Field)field);
            }, container -> {
                HibStringField field = container.getString(STRING_FIELD);
                Assert.assertNotNull((String)"The graph field {stringField} could not be found.", (Object)field);
                Assert.assertEquals((String)"The string of the field was not updated.", (Object)"someValue", (Object)field.getString());
            });
        }
    }
}

