/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.field.string;

import com.gentics.mesh.context.InternalActionContext;
import com.gentics.mesh.core.data.HibFieldContainer;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.dao.ContentDao;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.HibStringField;
import com.gentics.mesh.core.data.node.field.list.HibStringFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibListableField;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.field.AbstractFieldTest;
import com.gentics.mesh.core.field.string.StringListFieldTestHelper;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.ListFieldSchema;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.NoConsistencyCheck;
import com.gentics.mesh.util.CoreTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT_AND_NODE, startServer=false)
public class StringListFieldTest
extends AbstractFieldTest<ListFieldSchema> {
    private static final String STRING_LIST = "stringList";

    @Override
    protected ListFieldSchema createFieldSchema(boolean isRequired) {
        return this.createFieldSchema(STRING_LIST, isRequired);
    }

    protected ListFieldSchema createFieldSchema(String fieldKey, boolean isRequired) {
        ListFieldSchemaImpl schema = new ListFieldSchemaImpl();
        schema.setListType("string");
        schema.setName(fieldKey);
        schema.setRequired(isRequired);
        return schema;
    }

    @Override
    @Test
    public void testFieldTransformation() throws Exception {
        HibNode node;
        try (Tx tx = this.tx();){
            node = this.folder("2015");
            ContentDao contentDao = tx.contentDao();
            this.prepareNode(node, STRING_LIST, "string");
            HibNodeFieldContainer container = contentDao.createFieldContainer(node, this.english(), node.getProject().getLatestBranch(), this.user(), contentDao.getLatestDraftFieldContainer(node, this.english()), true);
            HibStringFieldList stringList = container.createStringList(STRING_LIST);
            stringList.createString("dummyString1");
            stringList.createString("dummyString2");
            tx.success();
        }
        tx = this.tx();
        try {
            node = this.folder("2015");
            NodeResponse response = this.transform(node);
            this.assertList(2, STRING_LIST, "string", response);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    @Override
    @Test
    public void testFieldUpdate() throws Exception {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibStringFieldList list = container.createStringList(STRING_LIST);
            list.createString("1");
            Assert.assertEquals((Object)STRING_LIST, (Object)list.getFieldKey());
            Assert.assertNotNull((Object)list.getList());
            Assert.assertEquals((long)1L, (long)list.getList().size());
            Assert.assertEquals((long)list.getSize(), (long)list.getList().size());
            list.createString("2");
            Assert.assertEquals((long)2L, (long)list.getList().size());
            list.createString("3").setString("Some string 3");
            Assert.assertEquals((long)3L, (long)list.getList().size());
            Assert.assertEquals((Object)"Some string 3", (Object)((HibStringField)list.getList().get(2)).getString());
            HibStringFieldList loadedList = container.getStringList(STRING_LIST);
            Assert.assertNotNull((Object)loadedList);
            Assert.assertEquals((long)3L, (long)loadedList.getSize());
            list.removeAll();
            Assert.assertEquals((long)0L, (long)list.getSize());
            Assert.assertEquals((long)0L, (long)list.getList().size());
        }
    }

    @Override
    @Test
    @NoConsistencyCheck
    public void testClone() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibStringFieldList testField = container.createStringList(STRING_LIST);
            testField.createString("one");
            testField.createString("two");
            testField.createString("three");
            HibNodeFieldContainer otherContainer = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            testField.cloneTo((HibFieldContainer)otherContainer);
            Assertions.assertThat((boolean)otherContainer.getStringList(STRING_LIST).equals(testField));
        }
    }

    @Override
    @Test
    public void testEquals() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema("fieldA", true), this.createFieldSchema("fieldB", true)});
            HibStringFieldList fieldA = container.createStringList("fieldA");
            HibStringFieldList fieldB = container.createStringList("fieldB");
            Assert.assertTrue((String)"The field should  be equal to itself", (boolean)fieldA.equals(fieldA));
            fieldA.addItem((HibListableField)fieldA.createString("testString"));
            Assert.assertTrue((String)"The field should  still be equal to itself", (boolean)fieldA.equals(fieldA));
            Assert.assertFalse((String)"The field should not be equal to a non-string field", (boolean)fieldA.equals("bogus"));
            Assert.assertFalse((String)"The field should not be equal since fieldB has no value", (boolean)fieldA.equals(fieldB));
            fieldB.addItem((HibListableField)fieldB.createString("testString"));
            Assert.assertTrue((String)"Both fields have the same value and should be equal", (boolean)fieldA.equals(fieldB));
        }
    }

    @Override
    @Test
    public void testEqualsNull() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            HibStringFieldList fieldA = container.createStringList(STRING_LIST);
            Assert.assertFalse((boolean)fieldA.equals(null));
            Assert.assertFalse((boolean)fieldA.equals(null));
        }
    }

    @Override
    @Test
    public void testEqualsRestField() {
        try (Tx tx = this.tx();){
            HibNodeFieldContainer container = CoreTestUtils.createContainer(new FieldSchema[]{this.createFieldSchema(true)});
            String dummyValue = "test123";
            HibStringFieldList fieldA = container.createStringList(STRING_LIST);
            StringFieldListImpl restField = new StringFieldListImpl();
            Assert.assertTrue((String)"Both fields should be equal to eachother since both values are null", (boolean)fieldA.equals(restField));
            fieldA.addItem((HibListableField)fieldA.createString(dummyValue));
            restField.add((Object)(dummyValue + "1"));
            Assert.assertFalse((String)"Both fields should be different since both values are not equal", (boolean)fieldA.equals(restField));
            restField.getItems().clear();
            restField.add((Object)dummyValue);
            Assert.assertTrue((String)"Both fields should be equal since values are equal", (boolean)fieldA.equals(restField));
            HtmlFieldListImpl otherTypeRestField = new HtmlFieldListImpl();
            otherTypeRestField.add((Object)dummyValue);
            Assert.assertFalse((String)"Fields should not be equal since the type does not match.", (boolean)fieldA.equals(otherTypeRestField));
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreate() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestTestcase(STRING_LIST, StringListFieldTestHelper.FETCH, StringListFieldTestHelper.CREATE_EMPTY);
        }
    }

    @Override
    @Test
    public void testUpdateFromRestNullOnCreateRequired() {
        try (Tx tx = this.tx();){
            this.invokeUpdateFromRestNullOnCreateRequiredTestcase(STRING_LIST, StringListFieldTestHelper.FETCH);
        }
    }

    @Override
    @Test
    public void testRemoveFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveFieldViaNullTestcase(STRING_LIST, StringListFieldTestHelper.FETCH, StringListFieldTestHelper.FILLTEXT, node -> this.updateContainer(ac, (HibNodeFieldContainer)node, STRING_LIST, null));
        }
    }

    @Override
    @Test
    public void testRemoveRequiredFieldViaNull() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeRemoveRequiredFieldViaNullTestcase(STRING_LIST, StringListFieldTestHelper.FETCH, StringListFieldTestHelper.FILLTEXT, container -> this.updateContainer(ac, (HibNodeFieldContainer)container, STRING_LIST, null));
        }
    }

    @Override
    public void testUpdateFromRestValidSimpleValue() {
        try (Tx tx = this.tx();){
            InternalActionContext ac = this.mockActionContext();
            this.invokeUpdateFromRestValidSimpleValueTestcase(STRING_LIST, StringListFieldTestHelper.FILLTEXT, container -> {
                StringFieldListImpl field = new StringFieldListImpl();
                field.getItems().add("someValue");
                field.getItems().add("someValue2");
                this.updateContainer(ac, (HibNodeFieldContainer)container, STRING_LIST, (Field)field);
            }, container -> {
                HibStringFieldList field = container.getStringList(STRING_LIST);
                Assert.assertNotNull((String)"The graph field {stringList} could not be found.", (Object)field);
                Assert.assertEquals((String)"The list of the field was not updated.", (long)2L, (long)field.getList().size());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"someValue", (Object)((HibStringField)field.getList().get(0)).getString());
                Assert.assertEquals((String)"The list item of the field was not updated.", (Object)"someValue2", (Object)((HibStringField)field.getList().get(1)).getString());
            });
        }
    }
}

