/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.tag.HibTag;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.impl.NodeFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.NodeFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.impl.SchemaCreateRequest;
import com.gentics.mesh.core.rest.schema.impl.SchemaResponse;
import com.gentics.mesh.core.rest.user.ExpandableNode;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.context.AbstractMeshTest;
import java.util.ArrayList;

public abstract class AbstractGraphQLNodeTest
extends AbstractMeshTest {
    public static final String NODE_1A_UUID = "b14469c742544efab294e0331232b9e0";
    public static final String NODE_1B_UUID = "02e3982b6ad14c1fa4a0b5998a02ff92";
    public static final String NODE_1C_UUID = "13c5981c51994d54998dd88b0c484720";
    public static final String SCHEMA_NAME = "test";

    protected void setupContents(boolean publish) {
        ArrayList<String> testNodeUuids = new ArrayList<String>();
        this.tx(tx -> {
            for (HibTag hibTag : this.tags().values()) {
                if (hibTag.getName().equals("blue")) continue;
                HibTag hibTag2 = (HibTag)tx.tagDao().findByUuid(hibTag.getUuid());
                tx.tagDao().delete((HibBaseElement)hibTag2, this.createBulkContext());
            }
        });
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        SchemaCreateRequest schemaRequest = new SchemaCreateRequest();
        schemaRequest.setName(SCHEMA_NAME);
        schemaRequest.setContainer(Boolean.valueOf(true));
        schemaRequest.setSegmentField("name");
        schemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"name"));
        schemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"extra"));
        schemaRequest.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"node"));
        schemaRequest.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"nodeList").setListType("node"));
        SchemaResponse schemaResponse = (SchemaResponse)ClientHelper.call(() -> this.client().createSchema(schemaRequest, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().assignSchemaToProject("dummy", schemaResponse.getUuid()));
        StringField level1A = FieldUtil.createStringField((String)"level1A");
        NodeCreateRequest level1ANodeCreateRequest = new NodeCreateRequest();
        level1ANodeCreateRequest.setParentNodeUuid(baseNodeUuid);
        level1ANodeCreateRequest.setSchemaName(SCHEMA_NAME);
        level1ANodeCreateRequest.setLanguage("en");
        level1ANodeCreateRequest.getFields().put("name", (Field)level1A);
        ClientHelper.call(() -> this.client().createNode(NODE_1A_UUID, "dummy", level1ANodeCreateRequest, new ParameterProvider[0]));
        testNodeUuids.add(NODE_1A_UUID);
        StringField level1B = FieldUtil.createStringField((String)"level1B");
        NodeFieldImpl node1A = FieldUtil.createNodeField((String)NODE_1A_UUID);
        NodeFieldListImpl node1AList = FieldUtil.createNodeListField((String[])new String[]{NODE_1A_UUID, NODE_1A_UUID});
        NodeCreateRequest level1BNodeCreateRequest = new NodeCreateRequest();
        level1BNodeCreateRequest.setParentNodeUuid(baseNodeUuid);
        level1BNodeCreateRequest.setSchemaName(SCHEMA_NAME);
        level1BNodeCreateRequest.setLanguage("en");
        level1BNodeCreateRequest.getFields().put("name", (Field)level1B);
        level1BNodeCreateRequest.getFields().put("node", (Field)node1A);
        level1BNodeCreateRequest.getFields().put("nodeList", (Field)node1AList);
        ClientHelper.call(() -> this.client().createNode(NODE_1B_UUID, "dummy", level1BNodeCreateRequest, new ParameterProvider[0]));
        testNodeUuids.add(NODE_1B_UUID);
        StringField level1C = FieldUtil.createStringField((String)"level1C");
        NodeFieldImpl node1B = FieldUtil.createNodeField((String)NODE_1B_UUID);
        NodeFieldListImpl node1BList = FieldUtil.createNodeListField((String[])new String[]{NODE_1B_UUID, NODE_1B_UUID});
        NodeCreateRequest level1CNodeCreateRequest = new NodeCreateRequest();
        level1CNodeCreateRequest.setParentNodeUuid(baseNodeUuid);
        level1CNodeCreateRequest.setSchemaName(SCHEMA_NAME);
        level1CNodeCreateRequest.setLanguage("en");
        level1CNodeCreateRequest.getFields().put("name", (Field)level1C);
        level1CNodeCreateRequest.getFields().put("node", (Field)node1B);
        level1CNodeCreateRequest.getFields().put("nodeList", (Field)node1BList);
        ClientHelper.call(() -> this.client().createNode(NODE_1C_UUID, "dummy", level1CNodeCreateRequest, new ParameterProvider[0]));
        testNodeUuids.add(NODE_1C_UUID);
        for (int i = 0; i < 10; ++i) {
            StringField level2i = FieldUtil.createStringField((String)("level2-" + i));
            NodeFieldListImpl node1AB = FieldUtil.createNodeListField((String[])new String[]{NODE_1A_UUID, NODE_1B_UUID});
            NodeCreateRequest subNodeCreateRequest = new NodeCreateRequest();
            subNodeCreateRequest.setParentNodeUuid(NODE_1B_UUID);
            subNodeCreateRequest.setSchemaName(SCHEMA_NAME);
            subNodeCreateRequest.setLanguage("en");
            subNodeCreateRequest.getFields().put("name", (Field)level2i);
            subNodeCreateRequest.getFields().put("node", (Field)node1A);
            subNodeCreateRequest.getFields().put("nodeList", (Field)node1AB);
            NodeResponse level2NodeResponse = (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", subNodeCreateRequest, new ParameterProvider[0]));
            testNodeUuids.add(level2NodeResponse.getUuid());
        }
        UserResponse user = (UserResponse)ClientHelper.call(() -> this.client().me(new ParameterProvider[0]));
        NodeReference nodeRef = new NodeReference();
        nodeRef.setProjectName("dummy");
        nodeRef.setUuid(NODE_1B_UUID);
        ClientHelper.call(() -> this.client().updateUser(user.getUuid(), new UserUpdateRequest().setNodeReference((ExpandableNode)nodeRef), new ParameterProvider[0]));
        String tagUuid = (String)this.tx(() -> this.tag("blue").getUuid());
        ClientHelper.call(() -> this.client().addTagToNode("dummy", NODE_1B_UUID, tagUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().addTagToNode("dummy", NODE_1A_UUID, tagUuid, new ParameterProvider[0]));
        if (publish) {
            ClientHelper.call(() -> this.client().publishNode("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        } else {
            ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        }
        for (String uuid : testNodeUuids) {
            NodeUpdateRequest subNodeUpdateRequest = new NodeUpdateRequest();
            subNodeUpdateRequest.setLanguage("en");
            subNodeUpdateRequest.getFields().putString("extra", "DRAFT");
            ClientHelper.call(() -> this.client().updateNode("dummy", uuid, subNodeUpdateRequest, new ParameterProvider[0]));
        }
        NodeUpdateRequest rootNodeUpdateRequest = new NodeUpdateRequest();
        rootNodeUpdateRequest.setLanguage("en");
        rootNodeUpdateRequest.getFields().putString("name", "root");
        ClientHelper.call(() -> this.client().updateNode("dummy", baseNodeUuid, rootNodeUpdateRequest, new ParameterProvider[0]));
    }
}

