/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.role.RolePermissionRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.client.PublishParametersImpl;
import com.gentics.mesh.parameter.client.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
@RunWith(value=Parameterized.class)
public class GraphQLAnonymousPermissionTest
extends AbstractMeshTest {
    @Parameterized.Parameter(value=0)
    public String version;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> paramData() {
        return Arrays.asList({"draft"}, {"published"});
    }

    @Test
    public void testReadViaAnonymous() throws Throwable {
        String QUERY_NAME = "anonymous-perm-query." + this.version;
        HibNode node = this.folder("news");
        String tagUuid = (String)this.tx(() -> this.tag("red").getUuid());
        String tagFamilyUuid = (String)this.tx(() -> this.tag("red").getTagFamily().getUuid());
        String nodeUuid = (String)this.tx(() -> node.getUuid());
        String anonRoleUuid = (String)this.tx(() -> this.anonymousRole().getUuid());
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        RolePermissionRequest request = new RolePermissionRequest();
        request.setRecursive(Boolean.valueOf(true));
        request.getPermissions().setRead(Boolean.valueOf(false)).setReadPublished(Boolean.valueOf(true));
        ClientHelper.call(() -> this.client().updateRolePermissions(anonRoleUuid, "projects/" + this.projectUuid(), request));
        request.getPermissions().setRead(Boolean.valueOf(true)).setReadPublished(Boolean.valueOf(false));
        ClientHelper.call(() -> this.client().updateRolePermissions(anonRoleUuid, "projects/" + this.projectUuid() + "/tagFamilies/" + tagFamilyUuid + "/tags/" + tagUuid, request));
        ClientHelper.call(() -> this.client().addTagToNode("dummy", nodeUuid, tagUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().addTagToNode("dummy", baseNodeUuid, tagUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().takeNodeOffline("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        ClientHelper.call(() -> this.client().publishNode("dummy", baseNodeUuid, new ParameterProvider[0]));
        ClientHelper.call(() -> this.client().publishNode("dummy", nodeUuid, new ParameterProvider[0]));
        this.client().logout();
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(QUERY_NAME), new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        JsonObject jsonResponse = new JsonObject(response.toJson());
        System.out.println(jsonResponse.encodePrettily());
        MeshAssertions.assertThat((JsonObject)jsonResponse).compliesToAssertions(QUERY_NAME);
    }
}

