/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.impl.DummyBulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.rest.graphql.GraphQLRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.MeshJSONAssert;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.json.JSONException;
import org.junit.Assert;
import org.junit.Test;
import org.reactivestreams.Publisher;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLEndpointBasicTest
extends AbstractMeshTest {
    @Test
    public void testIntrospection() throws IOException {
        try (Tx tx = this.tx();){
            for (HibMicroschema microschema : tx.microschemaDao().findAll()) {
                tx.microschemaDao().delete((HibBaseElement)microschema, (BulkActionContext)new DummyBulkActionContext());
            }
            tx.success();
        }
        String queryName = "introspection-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions(queryName);
    }

    @Test
    public void testSimpleQuery() throws JSONException {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", "{me{firstname}}", new ParameterProvider[0]));
        MeshJSONAssert.assertEquals("{'me':{'firstname':'Joe'}}", response.getData());
    }

    @Test
    public void testEmptyQuery() throws Throwable {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", "", new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)response.getErrors().stream().filter(error -> error.getType().equals("InvalidSyntax")).count());
    }

    @Test
    public void testErrorHandling() throws Throwable {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", "{bogus{firstname}}", new ParameterProvider[0]));
        Assert.assertEquals((long)1L, (long)response.getErrors().stream().filter(error -> error.getType().equals("ValidationError")).count());
    }

    @Test
    public void testVariables() throws Throwable {
        GraphQLRequest request = new GraphQLRequest();
        request.setQuery("query test($var: String) { node(path: $var) { node { uuid } } }");
        request.setVariables(new JsonObject().put("var", (Object)"/News"));
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphql("dummy", request, new ParameterProvider[0]));
        String uuid = response.getData().getJsonObject("node").getJsonObject("node").getString("uuid");
        MeshAssertions.assertThat((String)uuid).isNotEmpty();
    }

    @Test
    public void testConcurrentQuery() {
        Flowable calls = Single.fromCallable(() -> this.client().graphqlQuery("dummy", "{me{firstname}}", new ParameterProvider[0]).toSingle().doOnSuccess(response -> MeshJSONAssert.assertEquals("{'me':{'firstname':'Joe'}}", response.getData())).toCompletable()).repeat(100L);
        Completable.merge((Publisher)calls).blockingAwait();
    }
}

