/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.job.JobStatus;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.project.ProjectResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Before;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLEndpointBranchTest
extends AbstractMeshTest {
    private final String BRANCH_NAME = "testBranch";

    @Before
    public void setupData() {
        this.grantAdmin();
        this.createBranchRestAndWait("testBranch", false);
        NodeResponse content1 = this.createContent("test1", "test");
        this.createContent("test2", String.format("{{mesh.link('%s')}}", content1.getUuid()));
    }

    @Test
    public void testLinkResolving() throws IOException {
        String queryName = "branch/link-resolving-query";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[]{new VersioningParametersImpl().setBranch("testBranch")}));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions(queryName);
    }

    private NodeResponse createContent(String slug, String content) {
        ProjectResponse project = this.getProject();
        NodeCreateRequest request = new NodeCreateRequest();
        request.setParentNodeUuid(project.getRootNode().getUuid());
        request.setSchemaName("content");
        request.setLanguage("en");
        FieldMap fields = request.getFields();
        fields.put("slug", (Field)new StringFieldImpl().setString(slug));
        fields.put("teaser", (Field)new StringFieldImpl().setString(content));
        fields.put("content", (Field)new StringFieldImpl().setString(content));
        return (NodeResponse)ClientHelper.call(() -> this.client().createNode("dummy", request, new ParameterProvider[]{new VersioningParametersImpl().setBranch("testBranch")}));
    }

    private void createBranchRestAndWait(String name, boolean latest) {
        this.waitForJobs(() -> this.createBranchRest(name, latest), JobStatus.COMPLETED, 1);
    }
}

