/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLEndpointFilterTest
extends AbstractMeshTest {
    @Test
    public void testIsContainerFilter() {
        String queryName = "filtering/isContainer";
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        JsonArray nodes = json.getJsonObject("data").getJsonObject("nodes").getJsonArray("elements");
        MeshAssertions.assertThat((int)nodes.size()).isGreaterThan(0);
        nodes.forEach(node -> {
            JsonObject nodeObj = (JsonObject)node;
            MeshAssertions.assertThat((Boolean)nodeObj.getBoolean("isContainer")).isTrue();
        });
    }

    @Test
    public void testFilterOfNonDefaultLanguageNode() throws IOException {
        this.createNodeOfNonDefaultLanguage();
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery("filtering/nodes-de-field"), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions("filtering/nodes-de-field");
    }

    @Test
    public void testFilterOfNonDefaultLanguageNodeWithCorrectLanguage() throws IOException {
        this.createNodeOfNonDefaultLanguage();
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery("filtering/nodes-de-field-correct-language"), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions("filtering/nodes-de-field-correct-language");
    }

    private void createNodeOfNonDefaultLanguage() {
        NodeCreateRequest request = new NodeCreateRequest();
        request.setSchemaName("folder");
        request.setLanguage("de");
        request.setParentNodeUuid(this.folderUuid());
        request.setFields(FieldMap.of((String)"name", (Field)StringField.of((String)"deFieldTest")));
        this.client().createNode("dummy", request, new ParameterProvider[0]).blockingAwait();
    }
}

