/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.FieldUtil;
import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.context.BulkActionContext;
import com.gentics.mesh.context.impl.DummyBulkActionContext;
import com.gentics.mesh.core.data.HibBaseElement;
import com.gentics.mesh.core.data.HibNodeFieldContainer;
import com.gentics.mesh.core.data.binary.HibBinary;
import com.gentics.mesh.core.data.dao.MicroschemaDao;
import com.gentics.mesh.core.data.node.HibMicronode;
import com.gentics.mesh.core.data.node.HibNode;
import com.gentics.mesh.core.data.node.field.list.HibBooleanFieldList;
import com.gentics.mesh.core.data.node.field.list.HibDateFieldList;
import com.gentics.mesh.core.data.node.field.list.HibHtmlFieldList;
import com.gentics.mesh.core.data.node.field.list.HibMicronodeFieldList;
import com.gentics.mesh.core.data.node.field.list.HibNodeFieldList;
import com.gentics.mesh.core.data.node.field.list.HibNumberFieldList;
import com.gentics.mesh.core.data.node.field.list.HibStringFieldList;
import com.gentics.mesh.core.data.node.field.nesting.HibMicronodeField;
import com.gentics.mesh.core.data.s3binary.S3HibBinary;
import com.gentics.mesh.core.data.schema.HibFieldSchemaVersionElement;
import com.gentics.mesh.core.data.schema.HibMicroschema;
import com.gentics.mesh.core.data.schema.HibSchema;
import com.gentics.mesh.core.data.schema.HibSchemaVersion;
import com.gentics.mesh.core.db.Tx;
import com.gentics.mesh.core.graphql.javafilter.JavaGraphQLEndpointTest;
import com.gentics.mesh.core.graphql.nativefilter.NativeGraphQLEndpointTest;
import com.gentics.mesh.core.rest.branch.BranchUpdateRequest;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaCreateRequest;
import com.gentics.mesh.core.rest.microschema.impl.MicroschemaResponse;
import com.gentics.mesh.core.rest.node.FieldMap;
import com.gentics.mesh.core.rest.node.FieldMapImpl;
import com.gentics.mesh.core.rest.node.NodeCreateRequest;
import com.gentics.mesh.core.rest.node.NodeResponse;
import com.gentics.mesh.core.rest.node.NodeUpdateRequest;
import com.gentics.mesh.core.rest.node.field.Field;
import com.gentics.mesh.core.rest.node.field.StringField;
import com.gentics.mesh.core.rest.node.field.image.FocalPoint;
import com.gentics.mesh.core.rest.node.field.impl.HtmlFieldImpl;
import com.gentics.mesh.core.rest.node.field.impl.StringFieldImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.HtmlFieldListImpl;
import com.gentics.mesh.core.rest.node.field.list.impl.StringFieldListImpl;
import com.gentics.mesh.core.rest.schema.FieldSchema;
import com.gentics.mesh.core.rest.schema.SchemaReference;
import com.gentics.mesh.core.rest.schema.SchemaVersionModel;
import com.gentics.mesh.core.rest.schema.impl.BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.BooleanFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.DateFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.HtmlFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.ListFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.MicronodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NodeFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.NumberFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.S3BinaryFieldSchemaImpl;
import com.gentics.mesh.core.rest.schema.impl.SchemaReferenceImpl;
import com.gentics.mesh.core.rest.schema.impl.StringFieldSchemaImpl;
import com.gentics.mesh.core.rest.user.ExpandableNode;
import com.gentics.mesh.core.rest.user.NodeReference;
import com.gentics.mesh.core.rest.user.UserResponse;
import com.gentics.mesh.core.rest.user.UserUpdateRequest;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.parameter.impl.PublishParametersImpl;
import com.gentics.mesh.parameter.impl.VersioningParametersImpl;
import com.gentics.mesh.rest.client.MeshRequest;
import com.gentics.mesh.rest.client.MeshRestClient;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import com.gentics.mesh.util.UUIDUtil;
import io.reactivex.Completable;
import io.reactivex.functions.Function;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@MeshTestSetting(testSize=TestSize.FULL, startServer=true)
public class GraphQLEndpointTest
extends AbstractMeshTest {
    protected static final String NODE_WITH_LINKS_UUID = "8d2f5769fe114353af5769fe11e35355";
    protected static final String NODE_WITH_NODE_REF_UUID = "e8f5c7875b2f49a7b5c7875b2fa9a718";
    public static final String SCHEMA_UUID = "SCHEMA_UUID";
    protected final String queryName;
    protected final boolean withMicroschema;
    private final boolean withBranchPathPrefix;
    protected final String version;
    protected final String apiVersion;
    protected final Consumer<JsonObject> assertion;
    protected MeshRestClient client;

    public GraphQLEndpointTest(String queryName, boolean withMicroschema, boolean withBranchPathPrefix, String version, Consumer<JsonObject> assertion, String apiVersion) {
        this.queryName = queryName;
        this.withMicroschema = withMicroschema;
        this.withBranchPathPrefix = withBranchPathPrefix;
        this.version = version;
        this.assertion = assertion;
        this.apiVersion = apiVersion;
    }

    protected static Stream<List<Object>> queries() {
        return Stream.of(Arrays.asList("full-query", true, false, "draft"), Arrays.asList("role-user-group-query", true, false, "draft"), Arrays.asList("group-query", true, false, "draft"), Arrays.asList("schema-query", true, false, "draft"), Arrays.asList("microschema-query", true, false, "draft"), Arrays.asList("paging-query", true, false, "draft"), Arrays.asList("tagFamily-query", true, false, "draft"), Arrays.asList("node-query", true, false, "draft"), Arrays.asList("node-tag-query", true, false, "draft"), Arrays.asList("nodes-query", true, false, "draft"), Arrays.asList("nodes-query-by-uuids", true, false, "draft"), Arrays.asList("node-breadcrumb-query", true, false, "draft"), Arrays.asList("node-breadcrumb-query-with-lang", true, false, "draft"), Arrays.asList("node-language-fallback-query", true, false, "draft"), Arrays.asList("node-languages-query", true, false, "draft", GraphQLEndpointTest::checkNodeLanguageContent), Arrays.asList("node-not-found-webroot-query", true, false, "draft"), Arrays.asList("node-webroot-query", true, false, "draft"), Arrays.asList("node-webroot-urlfield-query", true, false, "draft"), Arrays.asList("node-relations-query", true, false, "draft"), Arrays.asList("node-fields-query", true, false, "draft"), Arrays.asList("node-fields-no-microschema-query", false, false, "draft"), Arrays.asList("node/link/webroot", true, false, "draft"), Arrays.asList("node/link/webroot-medium", true, false, "draft"), Arrays.asList("node/link/webroot-short", true, false, "draft"), Arrays.asList("node/link/children", true, false, "draft", GraphQLEndpointTest::checkNodeLinkChildrenResponse), Arrays.asList("node/link/webroot-language", true, false, "draft"), Arrays.asList("node/link/reference", true, false, "draft"), Arrays.asList("node-field-list-path-query", true, false, "draft"), Arrays.asList("project-query", true, false, "draft"), Arrays.asList("tag-query", true, false, "draft"), Arrays.asList("branch-query", true, true, "draft"), Arrays.asList("user-query", true, false, "draft"), Arrays.asList("microschema-projects-query", true, false, "draft"), Arrays.asList("node-version-published-query", true, false, "published"), Arrays.asList("node/breadcrumb-root", true, false, "draft"), Arrays.asList("node/versionslist", true, false, "draft"), Arrays.asList("permissions", true, false, "draft"), Arrays.asList("user-node-reference", true, false, "draft"), Arrays.asList("filtering/children", true, false, "draft"), Arrays.asList("filtering/nodes-creator-editor", true, false, "draft"), Arrays.asList("filtering/groups", true, false, "draft"), Arrays.asList("filtering/roles", true, false, "draft"), Arrays.asList("filtering/users", true, false, "draft"), Arrays.asList("filtering/nodes-string-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-boolean-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-number-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-date-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-stringlist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-numberlist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-booleanlist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-datelist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-htmllist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-node-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-micronode-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-binary-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-s3binary-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-nodelist-field-native", true, false, "draft"), Arrays.asList("filtering/nodes-micronodelist-field-native", true, false, "draft"));
    }

    @Parameterized.Parameters(name="query={0},version={3},apiVersion={5}")
    public static Collection<Object[]> paramData() {
        return Stream.of(GraphQLEndpointTest.queries(), JavaGraphQLEndpointTest.queries(), NativeGraphQLEndpointTest.queries()).flatMap(java.util.function.Function.identity()).flatMap(testCase -> IntStream.rangeClosed(1, 2).mapToObj(version -> {
            Object[] array = testCase.toArray(new Object[6]);
            array[5] = "v" + version;
            return array;
        })).collect(Collectors.toList());
    }

    @Before
    public void setUp() throws Exception {
        this.client = this.client(this.apiVersion);
    }

    @Test
    public void testNodeQuery() throws Exception {
        Tx tx;
        String microschemaUuid = null;
        if (this.withMicroschema) {
            MicroschemaCreateRequest microschemaRequest = new MicroschemaCreateRequest();
            microschemaRequest.setName("TestMicroschema");
            microschemaRequest.addField((FieldSchema)FieldUtil.createStringFieldSchema((String)"text"));
            microschemaRequest.addField((FieldSchema)FieldUtil.createNodeFieldSchema((String)"nodeRef").setAllowedSchemas(new String[]{"content"}));
            microschemaRequest.addField((FieldSchema)FieldUtil.createListFieldSchema((String)"nodeList", (String)"node"));
            Iterator microschemaResponse = (MicroschemaResponse)ClientHelper.call(() -> this.client.createMicroschema(microschemaRequest));
            microschemaUuid = microschemaResponse.getUuid();
            ClientHelper.call(() -> this.lambda$testNodeQuery$3((MicroschemaResponse)microschemaResponse));
        } else {
            tx = this.tx();
            try {
                for (HibMicroschema microschema : tx.microschemaDao().findAll()) {
                    tx.microschemaDao().delete((HibBaseElement)microschema, (BulkActionContext)new DummyBulkActionContext());
                }
                tx.success();
            }
            finally {
                if (tx != null) {
                    tx.close();
                }
            }
        }
        if (this.withBranchPathPrefix) {
            ClientHelper.call(() -> this.client.updateBranch("dummy", this.initialBranchUuid(), new BranchUpdateRequest().setHostname("getmesh.io").setSsl(Boolean.valueOf(false)).setPathPrefix("/base/path")));
        }
        tx = this.tx();
        try {
            MicroschemaDao microschemaDao = tx.microschemaDao();
            HibNode node = this.folder("2015");
            HibNode folder = this.folder("news");
            tx.contentDao().updateWebrootPathInfo(tx.contentDao().getFieldContainer(folder, "de"), this.initialBranchUuid(), null);
            tx.contentDao().updateWebrootPathInfo(tx.contentDao().getFieldContainer(folder, "de"), this.initialBranchUuid(), null);
            HibNode node2 = this.content();
            tx.contentDao().updateWebrootPathInfo(tx.contentDao().getFieldContainer(node2, "en"), this.initialBranchUuid(), null);
            tx.contentDao().updateWebrootPathInfo(tx.contentDao().getFieldContainer(node2, "de"), this.initialBranchUuid(), null);
            HibNode node3 = this.folder("2014");
            HibSchema schemaContainer = this.schemaContainer("folder");
            SchemaVersionModel schema = ((HibSchemaVersion)schemaContainer.getLatestVersion()).getSchema();
            schema.setUrlFields(new String[]{"niceUrl"});
            schema.setAutoPurge(Boolean.valueOf(true));
            NodeFieldSchemaImpl nodeFieldSchema = new NodeFieldSchemaImpl();
            nodeFieldSchema.setName("nodeRef");
            nodeFieldSchema.setLabel("Some label");
            nodeFieldSchema.setAllowedSchemas(new String[]{"folder"});
            schema.addField((FieldSchema)nodeFieldSchema);
            BinaryFieldSchemaImpl binaryFieldSchema = new BinaryFieldSchemaImpl();
            binaryFieldSchema.setName("binary");
            schema.addField((FieldSchema)binaryFieldSchema);
            S3BinaryFieldSchemaImpl s3BinaryFieldSchema = new S3BinaryFieldSchemaImpl();
            s3BinaryFieldSchema.setName("s3Binary");
            schema.addField((FieldSchema)s3BinaryFieldSchema);
            NumberFieldSchemaImpl numberFieldSchema = new NumberFieldSchemaImpl();
            numberFieldSchema.setName("number");
            schema.addField((FieldSchema)numberFieldSchema);
            DateFieldSchemaImpl dateFieldSchema = new DateFieldSchemaImpl();
            dateFieldSchema.setName("date");
            schema.addField((FieldSchema)dateFieldSchema);
            HtmlFieldSchemaImpl htmlFieldSchema = new HtmlFieldSchemaImpl();
            htmlFieldSchema.setName("html");
            schema.addField((FieldSchema)htmlFieldSchema);
            HtmlFieldSchemaImpl htmlLinkFieldSchema = new HtmlFieldSchemaImpl();
            htmlLinkFieldSchema.setName("htmlLink");
            schema.addField((FieldSchema)htmlLinkFieldSchema);
            HtmlFieldSchemaImpl emptyLinkFieldSchema = new HtmlFieldSchemaImpl();
            emptyLinkFieldSchema.setName("emptyLink");
            schema.addField((FieldSchema)emptyLinkFieldSchema);
            StringFieldSchemaImpl stringFieldSchema = new StringFieldSchemaImpl();
            stringFieldSchema.setName("string");
            schema.addField((FieldSchema)stringFieldSchema);
            StringFieldSchemaImpl niceUrlFieldSchema = new StringFieldSchemaImpl();
            niceUrlFieldSchema.setName("niceUrl");
            schema.addField((FieldSchema)niceUrlFieldSchema);
            StringFieldSchemaImpl stringLinkFieldSchema = new StringFieldSchemaImpl();
            stringLinkFieldSchema.setName("stringLink");
            schema.addField((FieldSchema)stringLinkFieldSchema);
            BooleanFieldSchemaImpl booleanFieldSchema = new BooleanFieldSchemaImpl();
            booleanFieldSchema.setName("boolean");
            schema.addField((FieldSchema)booleanFieldSchema);
            ListFieldSchemaImpl stringListSchema = new ListFieldSchemaImpl();
            stringListSchema.setListType("string");
            stringListSchema.setName("stringList");
            schema.addField((FieldSchema)stringListSchema);
            ListFieldSchemaImpl dateListSchema = new ListFieldSchemaImpl();
            dateListSchema.setListType("date");
            dateListSchema.setName("dateList");
            schema.addField((FieldSchema)dateListSchema);
            ListFieldSchemaImpl nodeListSchema = new ListFieldSchemaImpl();
            nodeListSchema.setListType("node");
            nodeListSchema.setName("nodeList");
            schema.addField((FieldSchema)nodeListSchema);
            ListFieldSchemaImpl htmlListSchema = new ListFieldSchemaImpl();
            htmlListSchema.setListType("html");
            htmlListSchema.setName("htmlList");
            schema.addField((FieldSchema)htmlListSchema);
            ListFieldSchemaImpl booleanListSchema = new ListFieldSchemaImpl();
            booleanListSchema.setListType("boolean");
            booleanListSchema.setName("booleanList");
            schema.addField((FieldSchema)booleanListSchema);
            ListFieldSchemaImpl numberListSchema = new ListFieldSchemaImpl();
            numberListSchema.setListType("number");
            numberListSchema.setName("numberList");
            schema.addField((FieldSchema)numberListSchema);
            ListFieldSchemaImpl micronodeListSchema = new ListFieldSchemaImpl();
            micronodeListSchema.setListType("micronode");
            micronodeListSchema.setName("micronodeList");
            schema.addField((FieldSchema)micronodeListSchema);
            if (this.withMicroschema) {
                MicronodeFieldSchemaImpl micronodeFieldSchema = new MicronodeFieldSchemaImpl();
                micronodeFieldSchema.setAllowedMicroSchemas(new String[]{"vcard"});
                micronodeFieldSchema.setName("micronode");
                schema.addField((FieldSchema)micronodeFieldSchema);
            }
            ((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()).setSchema(schema);
            this.actions().updateSchemaVersion((HibFieldSchemaVersionElement)((HibSchemaVersion)this.schemaContainer("folder").getLatestVersion()));
            HibNodeFieldContainer container = tx.contentDao().createFieldContainer(node, "en", this.initialBranch(), this.user());
            container.createNode("nodeRef", node2);
            container.createNumber("number").setNumber((Number)42.1);
            long milisec = this.dateToMilis("2012-07-11 10:55:21");
            container.createDate("date").setDate(Long.valueOf(milisec));
            container.createHTML("html").setHtml("some html");
            container.createHTML("htmlLink").setHtml("Link: {{mesh.link(\"43ee8f9ff71e4016ae8f9ff71e10161c\", \"en\")}}");
            container.createHTML("emptyLink").setHtml("Link to nowhere: {{mesh.link(\"00000000000000000000000000000000\", \"en\")}}");
            container.createString("string").setString("some string");
            container.createString("niceUrl").setString("/some/url");
            container.createString("stringLink").setString("Link: {{mesh.link(\"43ee8f9ff71e4016ae8f9ff71e10161c\", \"en\")}}");
            container.createBoolean("boolean").setBoolean(Boolean.valueOf(true));
            HibBinary binary = (HibBinary)tx.binaries().create("hashsumvalue", 1L).runInExistingTx(tx);
            binary.setImageHeight(Integer.valueOf(10)).setImageWidth(Integer.valueOf(20)).setSize(2048L);
            container.createBinary("binary", binary).setImageDominantColor("00FF00").setImageFocalPoint(new FocalPoint(0.2f, 0.3f)).setMimeType("image/jpeg");
            S3HibBinary s3binary = (S3HibBinary)tx.s3binaries().create(UUIDUtil.randomUUID(), node.getUuid() + "/s3", "test.jpg").runInExistingTx(tx);
            container.createS3Binary("s3Binary", s3binary).setImageDominantColor("00FF00");
            HibStringFieldList stringList = container.createStringList("stringList");
            stringList.createString("A");
            stringList.createString("B");
            stringList.createString("C");
            stringList.createString("D Link: {{mesh.link(\"43ee8f9ff71e4016ae8f9ff71e10161c\", \"en\")}}");
            HibHtmlFieldList htmlList = container.createHTMLList("htmlList");
            htmlList.createHTML("A");
            htmlList.createHTML("B");
            htmlList.createHTML("C");
            htmlList.createHTML("D Link: {{mesh.link(\"43ee8f9ff71e4016ae8f9ff71e10161c\", \"en\")}}");
            HibDateFieldList dateList = container.createDateList("dateList");
            dateList.createDate(Long.valueOf(this.dateToMilis("2012-07-11 10:55:21")));
            dateList.createDate(Long.valueOf(this.dateToMilis("2014-07-11 10:55:30")));
            dateList.createDate(Long.valueOf(this.dateToMilis("2000-07-11 10:55:00")));
            HibNumberFieldList numberList = container.createNumberList("numberList");
            numberList.createNumber((Number)42L);
            numberList.createNumber((Number)1337);
            numberList.createNumber((Number)Float.valueOf(0.314f));
            HibBooleanFieldList booleanList = container.createBooleanList("booleanList");
            booleanList.createBoolean(Boolean.valueOf(true));
            booleanList.createBoolean(null);
            booleanList.createBoolean(Boolean.valueOf(false));
            HibNodeFieldList nodeList = container.createNodeList("nodeList");
            nodeList.createNode(0, node2);
            nodeList.createNode(1, node3);
            if (this.withMicroschema) {
                HibMicronodeFieldList micronodeList = container.createMicronodeList("micronodeList");
                HibMicronode firstMicronode = micronodeList.createMicronode(this.microschemaContainer("vcard").getLatestVersion());
                firstMicronode.createString("firstName").setString("Joe");
                firstMicronode.createString("lastName").setString("Doe");
                firstMicronode.createString("address").setString("Somewhere");
                firstMicronode.createString("postcode").setString("1010");
                HibMicronode secondMicronode = micronodeList.createMicronode(((HibMicroschema)microschemaDao.findByUuid(microschemaUuid)).getLatestVersion());
                secondMicronode.createString("text").setString("Joe");
                secondMicronode.createNode("nodeRef", this.content());
                HibNodeFieldList micrnodeNodeList = secondMicronode.createNodeList("nodeList");
                micrnodeNodeList.createNode(0, node2);
                micrnodeNodeList.createNode(1, node3);
                HibMicronodeField micronodeField = container.createMicronode("micronode", this.microschemaContainer("vcard").getLatestVersion());
                micronodeField.getMicronode().createString("firstName").setString("Joe");
                micronodeField.getMicronode().createString("lastName").setString("Doe");
                micronodeField.getMicronode().createString("address").setString("Somewhere");
                micronodeField.getMicronode().createString("postcode").setString("1010");
            }
            tx.contentDao().updateWebrootPathInfo(container, this.initialBranchUuid(), null);
            tx.success();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        String baseNodeUuid = (String)this.tx(() -> this.project().getBaseNode().getUuid());
        ClientHelper.call(() -> this.client.publishNode("dummy", baseNodeUuid, new ParameterProvider[]{new PublishParametersImpl().setRecursive(true)}));
        NodeCreateRequest request = new NodeCreateRequest();
        request.setLanguage("en");
        request.setSchema((SchemaReference)new SchemaReferenceImpl().setName("content"));
        request.getFields().put("title", (Field)FieldUtil.createStringField((String)"some title"));
        request.getFields().put("teaser", (Field)FieldUtil.createStringField((String)"some teaser"));
        request.getFields().put("slug", (Field)FieldUtil.createStringField((String)"new-page"));
        request.setParentNode(new NodeReference().setUuid(baseNodeUuid));
        ClientHelper.call(() -> this.client.createNode("dummy", request, new ParameterProvider[0]));
        this.createLanguageLinkResolvingNode(NODE_WITH_LINKS_UUID, baseNodeUuid, "43ee8f9ff71e4016ae8f9ff71e10161c").blockingAwait();
        NodeCreateRequest request2 = new NodeCreateRequest();
        request2.setLanguage("en");
        request2.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        request2.getFields().put("nodeRef", (Field)FieldUtil.createNodeField((String)NODE_WITH_LINKS_UUID));
        request2.getFields().put("nodeList", (Field)FieldUtil.createNodeListField((String[])new String[]{NODE_WITH_LINKS_UUID}));
        request2.getFields().put("slug", (Field)FieldUtil.createStringField((String)"node-with-reference-en"));
        request2.setParentNode(new NodeReference().setUuid("4b1346a2163a4ff89346a2163a9ff883"));
        ClientHelper.call(() -> this.client.createNode(NODE_WITH_NODE_REF_UUID, "dummy", request2, new ParameterProvider[0]));
        NodeUpdateRequest nodeUpdateRequest = new NodeUpdateRequest();
        nodeUpdateRequest.setLanguage("de");
        nodeUpdateRequest.setVersion("0.1");
        nodeUpdateRequest.getFields().put("nodeRef", (Field)FieldUtil.createNodeField((String)NODE_WITH_LINKS_UUID));
        nodeUpdateRequest.getFields().put("nodeList", (Field)FieldUtil.createNodeListField((String[])new String[]{NODE_WITH_LINKS_UUID}));
        nodeUpdateRequest.getFields().put("slug", (Field)FieldUtil.createStringField((String)"node-with-reference-de"));
        ClientHelper.call(() -> this.client.updateNode("dummy", NODE_WITH_NODE_REF_UUID, nodeUpdateRequest, new ParameterProvider[0]));
        UserResponse user = (UserResponse)ClientHelper.call(() -> this.client.me(new ParameterProvider[0]));
        NodeResponse newsNode = (NodeResponse)ClientHelper.call(() -> this.client.findNodeByUuid("dummy", "4b1346a2163a4ff89346a2163a9ff883", new ParameterProvider[0]));
        ClientHelper.call(() -> this.client.updateUser(user.getUuid(), new UserUpdateRequest().setNodeReference((ExpandableNode)newsNode), new ParameterProvider[0]));
        String query = this.getGraphQLQuery(this.queryName, this.apiVersion).replace("%SCHEMA_UUID%", this.schemaContainer("folder").getUuid());
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client.graphqlQuery("dummy", query, new ParameterProvider[]{new VersioningParametersImpl().setVersion(this.version)}));
        JsonObject jsonResponse = new JsonObject(response.toJson());
        if (this.assertion == null) {
            MeshAssertions.assertThat((JsonObject)jsonResponse).replacingPlaceholderVariable(SCHEMA_UUID, this.schemaContainer("folder").getUuid()).compliesToAssertions(this.queryName, this.apiVersion);
        } else {
            this.assertion.accept(jsonResponse);
        }
    }

    protected long dateToMilis(String date) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date).getTime();
    }

    protected Completable createLanguageLinkResolvingNode(String nodeUuid, String parentUuid, String referencedUuid) throws Exception {
        Function createFields = language -> {
            FieldMapImpl map = new FieldMapImpl();
            StringFieldListImpl stringList = new StringFieldListImpl();
            stringList.add((Object)("A Link: {{mesh.link(\"" + referencedUuid + "\", \"en\")}}"));
            stringList.add((Object)("B Link: {{mesh.link(\"" + referencedUuid + "\", \"de\")}}"));
            stringList.add((Object)("C Link: {{mesh.link(\"" + referencedUuid + "\")}}"));
            map.put("stringList", (Field)stringList);
            HtmlFieldListImpl htmlList = new HtmlFieldListImpl();
            htmlList.add((Object)("A Link: {{mesh.link(\"" + referencedUuid + "\", \"en\")}}"));
            htmlList.add((Object)("B Link: {{mesh.link(\"" + referencedUuid + "\", \"de\")}}"));
            htmlList.add((Object)("C Link: {{mesh.link(\"" + referencedUuid + "\")}}"));
            map.put("htmlList", (Field)htmlList);
            HtmlFieldImpl htmlField = new HtmlFieldImpl().setHTML("HTML Link: {{mesh.link(\"" + referencedUuid + "\")}}");
            map.put("html", (Field)htmlField);
            StringField stringField = new StringFieldImpl().setString("String Link: {{mesh.link(\"" + referencedUuid + "\")}}");
            map.put("string", (Field)stringField);
            map.put("slug", (Field)new StringFieldImpl().setString("new-page-" + language));
            return map;
        };
        Function updateNode = response -> {
            NodeUpdateRequest updateRequest = new NodeUpdateRequest();
            updateRequest.setFields((FieldMap)createFields.apply((Object)"de"));
            updateRequest.setLanguage("de");
            return this.client.updateNode("dummy", response.getUuid(), updateRequest, new ParameterProvider[0]).toSingle();
        };
        NodeCreateRequest createRequest = new NodeCreateRequest();
        createRequest.setLanguage("en");
        createRequest.setSchema((SchemaReference)new SchemaReferenceImpl().setName("folder"));
        createRequest.setParentNode(new NodeReference().setUuid(parentUuid));
        createRequest.setFields((FieldMap)createFields.apply((Object)"en"));
        return this.client.createNode(nodeUuid, "dummy", createRequest, new ParameterProvider[0]).toSingle().flatMap(updateNode).ignoreElement();
    }

    protected static void checkNodeLinkChildrenResponse(JsonObject result) {
        Collector<Object, ?, Map<String, List<Object>>> groupByLanguage = Collectors.groupingBy(o -> ((JsonObject)o).getString("language"));
        System.out.println(result.encodePrettily());
        JsonObject node = result.getJsonObject("data").getJsonObject("node");
        ((AbstractCharSequenceAssert)MeshAssertions.assertThat((String)node.getString("language")).as("Node language", new Object[0])).isEqualTo((Object)"de");
        Map<String, List<Object>> childCount = node.getJsonObject("c1").getJsonArray("elements").stream().collect(groupByLanguage);
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)childCount.get("de").size()).as("German children of c1", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)childCount.get("en").size()).as("English children of c1", new Object[0])).isEqualTo(2);
        childCount = node.getJsonObject("c2").getJsonArray("elements").stream().collect(groupByLanguage);
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)childCount.get("de").size()).as("German children of c2", new Object[0])).isEqualTo(2);
        ((AbstractIntegerAssert)MeshAssertions.assertThat((int)childCount.get("en").size()).as("English children of c2", new Object[0])).isEqualTo(2);
        JsonArray hipChildren = node.getJsonObject("hip").getJsonArray("elements");
        IntStream.range(0, hipChildren.size()).mapToObj(idx -> hipChildren.getJsonObject(idx).put("idx", (Object)idx)).forEach(c -> {
            Map count = (Map)c.getJsonObject("parent").getJsonObject("children").getJsonArray("elements").stream().collect(groupByLanguage);
            ((AbstractIntegerAssert)MeshAssertions.assertThat((int)((List)count.get("de")).size()).as("{} german children of hip", new Object[]{c.getInteger("idx")})).isEqualTo(2);
            ((AbstractIntegerAssert)MeshAssertions.assertThat((int)((List)count.get("en")).size()).as("{} english children of hip", new Object[]{c.getInteger("idx")})).isEqualTo(2);
        });
    }

    protected static void checkNodeLanguageContent(JsonObject result) {
        JsonArray languages = result.getJsonObject("data").getJsonObject("node").getJsonArray("languages");
        MeshAssertions.assertThat((JsonArray)languages).containsJsonObjectHashesInAnyOrder(obj -> Objects.hash(obj.getString("language"), obj.getString("path")), new Integer[]{Objects.hash("en", "/News/2015/News_2015.en.html"), Objects.hash("de", "/Neuigkeiten/2015/News_2015.de.html")});
    }

    private /* synthetic */ MeshRequest lambda$testNodeQuery$3(MicroschemaResponse microschemaResponse) throws Exception {
        return this.client.assignMicroschemaToProject("dummy", microschemaResponse.getUuid());
    }
}

