/*
 * Decompiled with CFR 0.152.
 */
package com.gentics.mesh.core.graphql;

import com.gentics.mesh.assertj.MeshAssertions;
import com.gentics.mesh.core.rest.graphql.GraphQLResponse;
import com.gentics.mesh.parameter.ParameterProvider;
import com.gentics.mesh.test.ClientHelper;
import com.gentics.mesh.test.MeshTestSetting;
import com.gentics.mesh.test.TestSize;
import com.gentics.mesh.test.context.AbstractMeshTest;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import org.junit.Test;

@MeshTestSetting(testSize=TestSize.PROJECT, startServer=true)
public class GraphQLMeshTypeTest
extends AbstractMeshTest {
    @Test
    public void testMeshType() throws IOException {
        this.options().getHttpServerOptions().setServerTokens(true);
        this.assertType("mesh/mesh-query");
    }

    @Test
    public void testWithDisabledServerTokens() throws IOException {
        this.options().getHttpServerOptions().setServerTokens(false);
        this.assertType("mesh/mesh-no-servertoken-query");
    }

    @Test
    public void testWithDisabledServerTokensAsAdmin() throws IOException {
        this.grantAdmin();
        this.options().getHttpServerOptions().setServerTokens(false);
        this.assertType("mesh/mesh-query");
    }

    public void assertType(String queryName) throws IOException {
        GraphQLResponse response = (GraphQLResponse)ClientHelper.call(() -> this.client().graphqlQuery("dummy", this.getGraphQLQuery(queryName), new ParameterProvider[0]));
        JsonObject json = new JsonObject(response.toJson());
        MeshAssertions.assertThat((JsonObject)json).compliesToAssertions(queryName);
    }
}

